/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.ExampleExpression;
import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.InTuples;
import io.ebean.Junction;
import io.ebean.LikeType;
import io.ebean.Pairs;
import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.SpiExpressionFactory;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.expression.AllEqualsExpression;
import io.ebeaninternal.server.expression.ArrayContainsExpression;
import io.ebeaninternal.server.expression.ArrayIsEmptyExpression;
import io.ebeaninternal.server.expression.BetweenExpression;
import io.ebeaninternal.server.expression.BetweenPropertyExpression;
import io.ebeaninternal.server.expression.BitwiseExpression;
import io.ebeaninternal.server.expression.BitwiseOp;
import io.ebeaninternal.server.expression.CaseInsensitiveEqualExpression;
import io.ebeaninternal.server.expression.DefaultExampleExpression;
import io.ebeaninternal.server.expression.DefaultExpressionList;
import io.ebeaninternal.server.expression.ExistsQueryExpression;
import io.ebeaninternal.server.expression.ExistsSqlQueryExpression;
import io.ebeaninternal.server.expression.IdExpression;
import io.ebeaninternal.server.expression.IdInExpression;
import io.ebeaninternal.server.expression.InExpression;
import io.ebeaninternal.server.expression.InPairsExpression;
import io.ebeaninternal.server.expression.InRangeExpression;
import io.ebeaninternal.server.expression.InTuplesExpression;
import io.ebeaninternal.server.expression.IsEmptyExpression;
import io.ebeaninternal.server.expression.JsonPathExpression;
import io.ebeaninternal.server.expression.JunctionExpression;
import io.ebeaninternal.server.expression.LikeExpression;
import io.ebeaninternal.server.expression.LogicExpression;
import io.ebeaninternal.server.expression.NativeILikeExpression;
import io.ebeaninternal.server.expression.NoopExpression;
import io.ebeaninternal.server.expression.NotExpression;
import io.ebeaninternal.server.expression.NullExpression;
import io.ebeaninternal.server.expression.Op;
import io.ebeaninternal.server.expression.RawExpression;
import io.ebeaninternal.server.expression.RawExpressionBuilder;
import io.ebeaninternal.server.expression.SimpleExpression;
import io.ebeaninternal.server.expression.SubQueryExpression;
import io.ebeaninternal.server.expression.SubQueryOp;
import io.ebeaninternal.server.expression.SubQueryRawExpression;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class DefaultExpressionFactory
implements SpiExpressionFactory {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final boolean nativeIlike;
    private final boolean equalsWithNullAsNoop;

    public DefaultExpressionFactory(boolean equalsWithNullAsNoop, boolean nativeIlike) {
        this.equalsWithNullAsNoop = equalsWithNullAsNoop;
        this.nativeIlike = nativeIlike;
    }

    @Override
    public ExpressionFactory createExpressionFactory() {
        return this;
    }

    public String getLang() {
        return "sql";
    }

    public <T> ExpressionList<T> expressionList() {
        return new DefaultExpressionList(this);
    }

    public Expression jsonExists(String propertyName, String path) {
        return new JsonPathExpression(propertyName, path, Op.EXISTS, null);
    }

    public Expression jsonNotExists(String propertyName, String path) {
        return new JsonPathExpression(propertyName, path, Op.NOT_EXISTS, null);
    }

    public Expression jsonEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.EQ, value);
    }

    public Expression jsonNotEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.NOT_EQ, value);
    }

    public Expression jsonGreaterThan(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.GT, value);
    }

    public Expression jsonGreaterOrEqual(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.GT_EQ, value);
    }

    public Expression jsonLessThan(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.LT, value);
    }

    public Expression jsonLessOrEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.LT_EQ, value);
    }

    public Expression jsonBetween(String propertyName, String path, Object lowerValue, Object upperValue) {
        return new JsonPathExpression(propertyName, path, lowerValue, upperValue);
    }

    public Expression arrayContains(String propertyName, Object ... values) {
        return new ArrayContainsExpression(propertyName, true, values);
    }

    public Expression arrayNotContains(String propertyName, Object ... values) {
        return new ArrayContainsExpression(propertyName, false, values);
    }

    public Expression arrayIsEmpty(String propertyName) {
        return new ArrayIsEmptyExpression(propertyName, true);
    }

    public Expression arrayIsNotEmpty(String propertyName) {
        return new ArrayIsEmptyExpression(propertyName, false);
    }

    public Expression bitwiseAny(String propertyName, long flags) {
        return new BitwiseExpression(propertyName, BitwiseOp.ANY, flags, "!=", 0L);
    }

    public Expression bitwiseAll(String propertyName, long flags) {
        return new BitwiseExpression(propertyName, BitwiseOp.ALL, flags, "=", flags);
    }

    public Expression bitwiseAnd(String propertyName, long flags, long match) {
        return new BitwiseExpression(propertyName, BitwiseOp.AND, flags, "=", match);
    }

    public Expression eq(String propertyName, Query<?> subQuery) {
        return new SubQueryExpression(SubQueryOp.EQ, propertyName, (SpiQuery)subQuery);
    }

    public Expression eq(String propertyName, Object value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNull(propertyName);
        }
        return new SimpleExpression(propertyName, Op.EQ, value);
    }

    public Expression eqOrNull(String propertyName, Object value) {
        return this.or(this.eq(propertyName, value), this.isNull(propertyName));
    }

    public Expression ne(String propertyName, Query<?> subQuery) {
        return new SubQueryExpression(SubQueryOp.NE, propertyName, (SpiQuery)subQuery);
    }

    public Expression ne(String propertyName, Object value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNotNull(propertyName);
        }
        return new SimpleExpression(propertyName, Op.NOT_EQ, value);
    }

    public Expression ieq(String propertyName, String value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNull(propertyName);
        }
        return new CaseInsensitiveEqualExpression(propertyName, value, false);
    }

    public Expression ine(String propertyName, String value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNotNull(propertyName);
        }
        return new CaseInsensitiveEqualExpression(propertyName, value, true);
    }

    public Expression ieqObject(String propertyName, Object value) {
        return new CaseInsensitiveEqualExpression(propertyName, value, false);
    }

    public Expression ineObject(String propertyName, Object value) {
        return new CaseInsensitiveEqualExpression(propertyName, value, true);
    }

    public Expression inRange(String propertyName, Object value1, Object value2) {
        return new InRangeExpression(propertyName, value1, value2);
    }

    public Expression inRangeWith(String lowProperty, String highProperty, Object value) {
        return this.and(this.le(lowProperty, value), this.gtOrNull(highProperty, value));
    }

    public Expression inRangeWithProperties(String propertyName, String lowProperty, String highProperty) {
        return this.raw(lowProperty + " <= " + propertyName + " and (" + propertyName + " < " + highProperty + " or " + highProperty + " is null)");
    }

    public Expression between(String propertyName, Object value1, Object value2) {
        return new BetweenExpression(propertyName, value1, value2);
    }

    public Expression betweenProperties(String lowProperty, String highProperty, Object value) {
        return new BetweenPropertyExpression(lowProperty, highProperty, value);
    }

    public Expression gt(String propertyName, Query<?> subQuery) {
        return new SubQueryExpression(SubQueryOp.GT, propertyName, (SpiQuery)subQuery);
    }

    public Expression gt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.GT, value);
    }

    public Expression gtOrNull(String propertyName, Object value) {
        return this.or(this.gt(propertyName, value), this.isNull(propertyName));
    }

    public Expression geOrNull(String propertyName, Object value) {
        return this.or(this.ge(propertyName, value), this.isNull(propertyName));
    }

    public Expression ge(String propertyName, Query<?> subQuery) {
        return new SubQueryExpression(SubQueryOp.GE, propertyName, (SpiQuery)subQuery);
    }

    public Expression ge(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.GT_EQ, value);
    }

    public Expression ltOrNull(String propertyName, Object value) {
        return this.or(this.lt(propertyName, value), this.isNull(propertyName));
    }

    public Expression leOrNull(String propertyName, Object value) {
        return this.or(this.le(propertyName, value), this.isNull(propertyName));
    }

    public Expression lt(String propertyName, Query<?> subQuery) {
        return new SubQueryExpression(SubQueryOp.LT, propertyName, (SpiQuery)subQuery);
    }

    public Expression lt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.LT, value);
    }

    public Expression le(String propertyName, Query<?> subQuery) {
        return new SubQueryExpression(SubQueryOp.LE, propertyName, (SpiQuery)subQuery);
    }

    public Expression le(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.LT_EQ, value);
    }

    public Expression isNull(String propertyName) {
        return new NullExpression(propertyName, false);
    }

    public Expression isNotNull(String propertyName) {
        return new NullExpression(propertyName, true);
    }

    private EntityBean checkEntityBean(Object bean) {
        if (!(bean instanceof EntityBean)) {
            throw new IllegalStateException("Expecting an EntityBean");
        }
        return (EntityBean)bean;
    }

    public ExampleExpression iexampleLike(Object example) {
        return new DefaultExampleExpression(this.checkEntityBean(example), true, LikeType.RAW);
    }

    public ExampleExpression exampleLike(Object example) {
        return new DefaultExampleExpression(this.checkEntityBean(example), false, LikeType.RAW);
    }

    public ExampleExpression exampleLike(Object example, boolean caseInsensitive, LikeType likeType) {
        return new DefaultExampleExpression(this.checkEntityBean(example), caseInsensitive, likeType);
    }

    public Expression like(String propertyName, Object value, boolean caseInsensitive, LikeType likeType) {
        return new LikeExpression(propertyName, value, caseInsensitive, likeType);
    }

    public Expression like(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.RAW);
    }

    public Expression ilike(String propertyName, String value) {
        if (this.nativeIlike) {
            return new NativeILikeExpression(propertyName, value);
        }
        return new LikeExpression(propertyName, value, true, LikeType.RAW);
    }

    public Expression startsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.STARTS_WITH);
    }

    public Expression istartsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.STARTS_WITH);
    }

    public Expression endsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.ENDS_WITH);
    }

    public Expression iendsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.ENDS_WITH);
    }

    public Expression contains(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.CONTAINS);
    }

    public Expression icontains(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.CONTAINS);
    }

    public Expression inPairs(Pairs pairs) {
        return new InPairsExpression(pairs, false);
    }

    public Expression inTuples(InTuples pairs) {
        return new InTuplesExpression(pairs, false);
    }

    public Expression in(String propertyName, Object[] values) {
        return new InExpression(propertyName, values, false);
    }

    public Expression exists(String subQuery, Object ... bindValues) {
        return new ExistsSqlQueryExpression(false, subQuery, bindValues);
    }

    public Expression notExists(String subQuery, Object ... bindValues) {
        return new ExistsSqlQueryExpression(true, subQuery, bindValues);
    }

    public Expression in(String propertyName, Query<?> subQuery) {
        return new SubQueryExpression(SubQueryOp.IN, propertyName, (SpiQuery)subQuery);
    }

    public Expression inSubQuery(String propertyName, String subQuery, Object ... bindValues) {
        return new SubQueryRawExpression(SubQueryOp.IN, propertyName, subQuery, bindValues);
    }

    public Expression notInSubQuery(String propertyName, String subQuery, Object ... bindValues) {
        return new SubQueryRawExpression(SubQueryOp.NOTIN, propertyName, subQuery, bindValues);
    }

    public Expression eqSubQuery(String propertyName, String subQuery, Object ... bindValues) {
        return new SubQueryRawExpression(SubQueryOp.EQ, propertyName, subQuery, bindValues);
    }

    public Expression neSubQuery(String propertyName, String subQuery, Object ... bindValues) {
        return new SubQueryRawExpression(SubQueryOp.NE, propertyName, subQuery, bindValues);
    }

    public Expression geSubQuery(String propertyName, String subQuery, Object ... bindValues) {
        return new SubQueryRawExpression(SubQueryOp.GE, propertyName, subQuery, bindValues);
    }

    public Expression gtSubQuery(String propertyName, String subQuery, Object ... bindValues) {
        return new SubQueryRawExpression(SubQueryOp.GT, propertyName, subQuery, bindValues);
    }

    public Expression leSubQuery(String propertyName, String subQuery, Object ... bindValues) {
        return new SubQueryRawExpression(SubQueryOp.LE, propertyName, subQuery, bindValues);
    }

    public Expression ltSubQuery(String propertyName, String subQuery, Object ... bindValues) {
        return new SubQueryRawExpression(SubQueryOp.LT, propertyName, subQuery, bindValues);
    }

    public Expression in(String propertyName, Collection<?> values) {
        return new InExpression(propertyName, values, false);
    }

    public Expression inOrEmpty(String propertyName, Collection<?> values) {
        return new InExpression(propertyName, values, false, true);
    }

    public Expression notIn(String propertyName, Object[] values) {
        return new InExpression(propertyName, values, true);
    }

    public Expression notIn(String propertyName, Collection<?> values) {
        return new InExpression(propertyName, values, true);
    }

    public Expression notIn(String propertyName, Query<?> subQuery) {
        return new SubQueryExpression(SubQueryOp.NOTIN, propertyName, (SpiQuery)subQuery);
    }

    public Expression exists(Query<?> subQuery) {
        return new ExistsQueryExpression((SpiQuery)subQuery, false);
    }

    public Expression notExists(Query<?> subQuery) {
        return new ExistsQueryExpression((SpiQuery)subQuery, true);
    }

    public Expression isEmpty(String propertyName) {
        return new IsEmptyExpression(propertyName, true);
    }

    public Expression isNotEmpty(String propertyName) {
        return new IsEmptyExpression(propertyName, false);
    }

    public Expression idEq(Object value) {
        if (value == null) {
            throw new NullPointerException("The id value is null");
        }
        return new IdExpression(value);
    }

    public Expression idIn(Collection<?> idCollection) {
        return new IdInExpression(idCollection);
    }

    public Expression idIn(Object ... idValues) {
        return new IdInExpression(Arrays.asList(idValues));
    }

    public Expression allEq(Map<String, Object> propertyMap) {
        return new AllEqualsExpression(propertyMap);
    }

    public Expression raw(String raw, Object value) {
        return RawExpressionBuilder.buildSingle(raw, value);
    }

    public Expression raw(String raw, Object[] values) {
        return RawExpressionBuilder.build(raw, values);
    }

    public Expression raw(String raw) {
        return new RawExpression(raw, EMPTY_ARRAY);
    }

    public Expression and(Expression expOne, Expression expTwo) {
        return new LogicExpression.And(expOne, expTwo);
    }

    public Expression or(Expression expOne, Expression expTwo) {
        return new LogicExpression.Or(expOne, expTwo);
    }

    public Expression not(Expression exp) {
        return new NotExpression(exp);
    }

    public <T> Junction<T> conjunction(Query<T> query) {
        return new JunctionExpression<T>(Junction.Type.AND, query, this, query.where());
    }

    public <T> Junction<T> disjunction(Query<T> query) {
        return new JunctionExpression<T>(Junction.Type.OR, query, this, query.where());
    }

    public <T> Junction<T> conjunction(Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(Junction.Type.AND, query, this, parent);
    }

    public <T> Junction<T> disjunction(Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(Junction.Type.OR, query, this, parent);
    }

    public <T> Junction<T> junction(Junction.Type type, Query<T> query) {
        return new JunctionExpression<T>(type, query, this, query.where());
    }

    public <T> Junction<T> junction(Junction.Type type, Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(type, query, this, parent);
    }
}

