/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.el.ElPropertyValue;

abstract class AbstractExpression
implements SpiExpression {
    protected String propName;

    protected AbstractExpression(String propName) {
        this.propName = propName;
    }

    @Override
    public void prefixProperty(String path) {
        this.propName = path + "." + this.propName;
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public SpiExpression copyForPlanKey() {
        return this;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        this.propertyContainsMany(this.propName, desc, manyWhereJoin);
    }

    protected void propertyContainsMany(String propertyName, BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        ElPropertyDeploy elProp;
        if (propertyName != null && (elProp = desc.elPropertyDeploy(propertyName)) != null) {
            if (elProp.containsFormulaWithJoin()) {
                manyWhereJoin.addFormulaWithJoin(elProp.elPrefix(), elProp.name());
            }
            if (elProp.containsMany()) {
                manyWhereJoin.add(elProp);
                if (elProp.isAggregation()) {
                    manyWhereJoin.setAggregation();
                }
            }
        }
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        validation.validate(this.propName);
    }

    protected final ElPropertyValue getElProp(SpiExpressionBind request) {
        return request.descriptor().elGetValue(this.propName);
    }
}

