/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.config.BeanNotRegisteredException;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.deploy.BeanTable;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import io.ebeaninternal.server.deploy.parse.AnnotationParser;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.deploy.parse.ReadAnnotationConfig;

abstract class AnnotationAssoc
extends AnnotationParser {
    final BeanDescriptorManager factory;

    AnnotationAssoc(DeployBeanInfo<?> info, ReadAnnotationConfig readConfig, BeanDescriptorManager factory) {
        super(info, readConfig);
        this.factory = factory;
    }

    void setTargetType(Class<?> targetType, DeployBeanPropertyAssoc<?> prop) {
        if (!targetType.equals(Void.TYPE)) {
            prop.setTargetType(targetType);
        }
    }

    void setBeanTable(DeployBeanPropertyAssoc<?> prop) {
        BeanTable assoc = this.getBeanTable(prop);
        if (assoc == null) {
            throw new BeanNotRegisteredException(this.errorMsgMissingBeanTable(prop.getTargetType(), prop.toString()));
        }
        prop.setBeanTable(assoc);
    }

    BeanTable getBeanTable(DeployBeanPropertyAssoc<?> prop) {
        return this.factory.beanTable(prop.getTargetType());
    }

    private String errorMsgMissingBeanTable(Class<?> type, String from) {
        return "Error with association to [" + String.valueOf(type) + "] from [" + from + "]. Is " + String.valueOf(type) + " registered? See https://ebean.io/docs/trouble-shooting#not-registered";
    }
}

