/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.id;

import io.ebean.SqlUpdate;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.deploy.BeanFkeyProperty;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.IntersectionBuilder;
import io.ebeaninternal.server.deploy.IntersectionRow;
import io.ebeaninternal.server.deploy.id.ImportedId;
import io.ebeaninternal.server.deploy.id.ImportedIdSimple;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dmlbind.BindableRequest;
import jakarta.persistence.PersistenceException;
import java.sql.SQLException;

public final class ImportedIdEmbedded
implements ImportedId {
    private final BeanPropertyAssoc<?> owner;
    private final BeanPropertyAssocOne<?> foreignAssocOne;
    private final ImportedIdSimple[] imported;

    public ImportedIdEmbedded(BeanPropertyAssoc<?> owner, BeanPropertyAssocOne<?> foreignAssocOne, ImportedIdSimple[] imported) {
        this.owner = owner;
        this.foreignAssocOne = foreignAssocOne;
        this.imported = imported;
    }

    @Override
    public void addFkeys(String name) {
        BeanProperty[] embeddedProps = this.foreignAssocOne.properties();
        for (int i = 0; i < this.imported.length; ++i) {
            String n = name + "." + this.foreignAssocOne.name() + "." + embeddedProps[i].name();
            this.owner.descriptor().add(new BeanFkeyProperty(n, this.imported[i].localDbColumn, this.foreignAssocOne.deployOrder()));
        }
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public String getDbColumn() {
        return null;
    }

    @Override
    public void sqlAppend(DbSqlContext ctx) {
        for (ImportedIdSimple anImported : this.imported) {
            ctx.appendColumn(anImported.localDbColumn);
        }
    }

    @Override
    public void dmlAppend(GenerateDmlRequest request) {
        boolean update = request.isUpdate();
        for (ImportedIdSimple anImported : this.imported) {
            if (!anImported.isInclude(update)) continue;
            request.appendColumn(anImported.localDbColumn);
        }
    }

    @Override
    public String importedIdClause() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.imported.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.imported[i].localDbColumn).append(" = ?");
        }
        return sb.toString();
    }

    @Override
    public int bind(int position, SqlUpdate update, EntityBean bean) {
        int pos = position;
        EntityBean embedded = (EntityBean)this.foreignAssocOne.getValue(bean);
        for (ImportedIdSimple anImported : this.imported) {
            if (!anImported.owner.isUpdateable()) continue;
            Object scalarValue = anImported.foreignProperty.getValue(embedded);
            if (scalarValue == null) {
                return -1;
            }
            update.setParameter(pos++, scalarValue);
        }
        return pos;
    }

    @Override
    public Object bind(BindableRequest request, EntityBean bean) throws SQLException {
        Object embeddedId = bean == null ? null : this.foreignAssocOne.getValue(bean);
        boolean update = request.isUpdate();
        if (embeddedId == null) {
            for (ImportedIdSimple anImported : this.imported) {
                if (!anImported.isInclude(update)) continue;
                request.bind(null, anImported.foreignProperty);
            }
            return Object.class;
        }
        EntityBean embedded = (EntityBean)embeddedId;
        for (ImportedIdSimple anImported : this.imported) {
            if (!anImported.isInclude(update)) continue;
            Object scalarValue = anImported.foreignProperty.getValue(embedded);
            request.bind(scalarValue, anImported.foreignProperty);
        }
        return embedded;
    }

    @Override
    public void buildImport(IntersectionRow row, EntityBean other) {
        EntityBean embeddedId = (EntityBean)this.foreignAssocOne.getValue(other);
        if (embeddedId == null) {
            throw new PersistenceException("Foreign Key value null?");
        }
        for (ImportedIdSimple anImported : this.imported) {
            Object scalarValue = anImported.foreignProperty.getValue(embeddedId);
            row.put(anImported.localDbColumn, scalarValue);
        }
    }

    @Override
    public void buildImport(IntersectionBuilder row) {
        for (ImportedIdSimple importedScalar : this.imported) {
            row.addColumn(importedScalar.localDbColumn);
        }
    }

    @Override
    public void bindImport(SqlUpdate sql, EntityBean other) {
        EntityBean embeddedId = (EntityBean)this.foreignAssocOne.getValue(other);
        if (embeddedId == null) {
            throw new PersistenceException("Foreign Key value null?");
        }
        for (ImportedIdSimple anImported : this.imported) {
            Object scalarValue = anImported.foreignProperty.getValue(embeddedId);
            sql.setParameter(scalarValue);
        }
    }

    @Override
    public BeanProperty findMatchImport(String matchDbColumn) {
        for (ImportedIdSimple anImported : this.imported) {
            BeanProperty p = anImported.findMatchImport(matchDbColumn);
            if (p == null) continue;
            return p;
        }
        return null;
    }
}

