/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanFindController;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;

final class BeanFinderManager {
    private static final System.Logger log = CoreLog.internal;
    private final List<BeanFindController> list;

    BeanFinderManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanFindControllers();
    }

    int getRegisterCount() {
        return this.list.size();
    }

    void addFindControllers(DeployBeanDescriptor<?> deployDesc) {
        for (BeanFindController c : this.list) {
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            log.log(System.Logger.Level.DEBUG, "BeanFindController on[{0}] {1}", deployDesc.getFullName(), c.getClass().getName());
            deployDesc.setBeanFinder(c);
        }
    }
}

