/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.bean.EntityBean;
import io.ebean.text.json.EJson;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.persist.DmlUtil;
import java.io.IOException;
import java.util.LinkedHashMap;

final class BeanDescriptorJsonHelp<T> {
    private final BeanDescriptor<T> desc;

    BeanDescriptorJsonHelp(BeanDescriptor<T> desc) {
        this.desc = desc;
    }

    void jsonWrite(SpiJsonWriter writeJson, EntityBean bean, String key) throws IOException {
        writeJson.writeStartObject(key);
        this.jsonWriteProperties(writeJson, bean);
        writeJson.writeEndObject();
    }

    void jsonWriteProperties(SpiJsonWriter writeJson, EntityBean bean) {
        writeJson.writeBean(this.desc, bean);
    }

    void jsonWriteDirty(SpiJsonWriter writeJson, EntityBean bean, boolean[] dirtyProps) throws IOException {
        this.jsonWriteDirtyProperties(writeJson, bean, dirtyProps);
    }

    void jsonWriteDirtyProperties(SpiJsonWriter writeJson, EntityBean bean, boolean[] dirtyProps) throws IOException {
        BeanProperty[] props;
        writeJson.writeStartObject(null);
        for (BeanProperty prop : props = this.desc.propertiesNonTransient()) {
            if (!dirtyProps[prop.propertyIndex()]) continue;
            prop.jsonWrite(writeJson, bean);
        }
        writeJson.writeEndObject();
    }

    T jsonRead(SpiJsonReader jsonRead, String path, boolean withInheritance, T target) throws IOException {
        JsonParser parser = jsonRead.parser();
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            JsonToken token = parser.nextToken();
            if (JsonToken.VALUE_NULL == token || JsonToken.END_ARRAY == token) {
                return null;
            }
            if (JsonToken.START_OBJECT != token) {
                throw new JsonParseException(parser, "Unexpected token " + String.valueOf(token) + " - expecting start_object", parser.getCurrentLocation());
            }
        }
        return this.jsonReadObject(jsonRead, path, target);
    }

    private T jsonReadObject(SpiJsonReader readJson, String path, T target) throws IOException {
        EntityBean bean;
        if (target == null) {
            bean = this.desc.createEntityBeanForJson();
        } else if (this.desc.beanType.isInstance(target)) {
            bean = (EntityBean)target;
        } else {
            throw new ClassCastException(target.getClass().getName() + " provided, but " + this.desc.beanType.getClass().getName() + " expected");
        }
        return this.jsonReadProperties(readJson, bean, path);
    }

    private T jsonReadProperties(SpiJsonReader readJson, EntityBean bean, String path) throws IOException {
        JsonParser parser;
        JsonToken event;
        if (path != null) {
            readJson.pushPath(path);
        }
        LinkedHashMap<String, Object> unmappedProperties = null;
        while (JsonToken.FIELD_NAME == (event = (parser = readJson.parser()).nextToken())) {
            String key = parser.getCurrentName();
            BeanProperty p = this.desc.beanProperty(key);
            if (p != null) {
                if (p.isVersion() && readJson.update()) {
                    p.jsonRead(readJson);
                    continue;
                }
                p.jsonRead(readJson, bean);
                continue;
            }
            if (unmappedProperties == null) {
                unmappedProperties = new LinkedHashMap<String, Object>();
            }
            unmappedProperties.put(key, EJson.parse((JsonParser)parser));
        }
        if (JsonToken.END_OBJECT != event) {
            throw new RuntimeException("Unexpected token " + String.valueOf(event) + " - expecting key or end_object at: " + String.valueOf(parser.getCurrentLocation()));
        }
        if (unmappedProperties != null) {
            this.desc.setUnmappedJson(bean, unmappedProperties);
        }
        Object contextBean = null;
        Object id = this.desc.id(bean);
        if (!DmlUtil.isNullOrZero(id)) {
            contextBean = readJson.persistenceContextPutIfAbsent(id, bean, this.desc);
        }
        if (contextBean == null) {
            readJson.beanVisitor(bean, unmappedProperties);
            if (!DmlUtil.isNullOrZero(id)) {
                this.desc.setReferenceIfIdOnly(bean._ebean_getIntercept());
            }
        }
        if (path != null) {
            readJson.popPath();
        }
        return (T)(contextBean == null ? bean : contextBean);
    }
}

