/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.InterceptReadOnly;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import java.util.LinkedHashMap;

public final class CachedBeanDataFromBean {
    public static CachedBeanData extract(BeanDescriptor<?> desc, EntityBean bean) {
        int propertyIndex;
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        BeanProperty idProperty = desc.idProperty();
        if (idProperty != null && ebi.isLoadedProperty(propertyIndex = idProperty.propertyIndex())) {
            data.put(idProperty.name(), idProperty.getCacheDataValue(bean));
        }
        boolean dirty = ebi.isDirty();
        for (BeanProperty beanProperty : desc.propertiesNonMany()) {
            if (dirty && ebi.isDirtyProperty(beanProperty.propertyIndex())) {
                data.put(beanProperty.name(), beanProperty.getCacheDataValueOrig(ebi));
                continue;
            }
            if (!ebi.isLoadedProperty(beanProperty.propertyIndex())) continue;
            data.put(beanProperty.name(), beanProperty.getCacheDataValue(bean));
        }
        for (BeanProperty beanProperty : desc.propertiesMany()) {
            if (!((BeanPropertyAssocMany)beanProperty).isElementCollection()) continue;
            data.put(beanProperty.name(), ((BeanPropertyAssocMany)beanProperty).getCacheDataValue(bean));
        }
        long version = desc.getVersion(bean);
        EntityBean sharableBean = CachedBeanDataFromBean.createSharableBean(desc, bean, ebi);
        return new CachedBeanData(sharableBean, data, version);
    }

    private static EntityBean createSharableBean(BeanDescriptor<?> desc, EntityBean bean, EntityBeanIntercept beanEbi) {
        if (!desc.isCacheSharableBeans() || !beanEbi.isFullyLoadedBean()) {
            return null;
        }
        if (beanEbi instanceof InterceptReadOnly) {
            return bean;
        }
        EntityBean sharableBean = desc.createEntityBean2(true);
        BeanProperty idProp = desc.idProperty();
        if (idProp != null) {
            Object v = idProp.getValue(bean);
            idProp.setValue(sharableBean, v);
        }
        for (BeanProperty nonTransient : desc.propertiesNonTransient()) {
            Object v = nonTransient.getValue(bean);
            nonTransient.setValue(sharableBean, v);
        }
        desc.freeze(sharableBean);
        return sharableBean;
    }
}

