/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CachedBeanData
implements Externalizable {
    private long whenCreated;
    private long version;
    private Map<String, Object> data;
    private transient Object sharableBean;

    public CachedBeanData(Object sharableBean, Map<String, Object> data, long version) {
        this.whenCreated = System.currentTimeMillis();
        this.sharableBean = sharableBean;
        this.data = data;
        this.version = version;
    }

    public CachedBeanData() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeLong(this.whenCreated);
        out.writeInt(this.data.size());
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = in.readLong();
        this.whenCreated = in.readLong();
        this.data = new LinkedHashMap<String, Object>();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String key = in.readUTF();
            Object val = in.readObject();
            this.data.put(key, val);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public CachedBeanData update(Map<String, Object> changes, long version) {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        copy.putAll(this.data);
        copy.putAll(changes);
        return new CachedBeanData(null, copy, version);
    }

    public long getWhenCreated() {
        return this.whenCreated;
    }

    public long getVersion() {
        return this.version;
    }

    public Object getSharableBean() {
        return this.sharableBean;
    }

    public boolean isLoaded(String propertyName) {
        return this.data.containsKey(propertyName);
    }

    public Object getData(String propertyName) {
        return this.data.get(propertyName);
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

