/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.Transaction;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.util.JdbcClose;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SimpleSequenceIdGenerator
implements PlatformIdGenerator {
    private final String sql;
    private final DataSource dataSource;
    private final String seqName;

    public SimpleSequenceIdGenerator(DataSource dataSource, String sql, String seqName) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.seqName = seqName;
    }

    @Override
    public String getName() {
        return this.seqName;
    }

    @Override
    public boolean isDbSequence() {
        return true;
    }

    @Override
    public void preAllocateIds(int batchSize) {
    }

    @Override
    public Object nextId(Transaction t) {
        ResultSet rset;
        PreparedStatement pstmt;
        Connection c;
        boolean useTxnConnection;
        block9: {
            useTxnConnection = t != null;
            c = null;
            pstmt = null;
            rset = null;
            c = useTxnConnection ? t.connection() : this.dataSource.getConnection();
            pstmt = c.prepareStatement(this.sql);
            rset = pstmt.executeQuery();
            if (!rset.next()) break block9;
            Integer n = rset.getInt(1);
            if (useTxnConnection) {
                this.closeResources(rset, pstmt, null);
            } else {
                this.closeResources(rset, pstmt, c);
            }
            return n;
        }
        try {
            try {
                String m = "Always expecting 1 row from " + this.sql;
                throw new PersistenceException(m);
            }
            catch (SQLException e) {
                throw new PersistenceException("Error getting sequence nextval", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (useTxnConnection) {
                this.closeResources(rset, pstmt, null);
            } else {
                this.closeResources(rset, pstmt, c);
            }
            throw throwable;
        }
    }

    private void closeResources(ResultSet rset, PreparedStatement pstmt, Connection c) {
        JdbcClose.close(rset);
        JdbcClose.close(pstmt);
        JdbcClose.close(c);
    }
}

