/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.config.PropertiesWrapper;

public class ProfilingConfig {
    private boolean enabled;
    private boolean verbose;
    private long minimumMicros;
    private int[] includeProfileIds = new int[0];
    private long profilesPerFile = 1000L;
    private String directory = "profiling";

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public long getMinimumMicros() {
        return this.minimumMicros;
    }

    public void setMinimumMicros(long minimumMicros) {
        this.minimumMicros = minimumMicros;
    }

    public int[] getIncludeProfileIds() {
        return this.includeProfileIds;
    }

    public void setIncludeProfileIds(int[] includeProfileIds) {
        this.includeProfileIds = includeProfileIds;
    }

    public long getProfilesPerFile() {
        return this.profilesPerFile;
    }

    public void setProfilesPerFile(long profilesPerFile) {
        this.profilesPerFile = profilesPerFile;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void loadSettings(PropertiesWrapper p, String name) {
        this.enabled = p.getBoolean("profiling", this.enabled);
        this.verbose = p.getBoolean("profiling.verbose", this.verbose);
        this.directory = p.get("profiling.directory", this.directory);
        this.profilesPerFile = p.getLong("profiling.profilesPerFile", this.profilesPerFile);
        this.minimumMicros = p.getLong("profiling.minimumMicros", this.minimumMicros);
        String includeIds = p.get("profiling.includeProfileIds");
        if (includeIds != null) {
            this.includeProfileIds = this.parseIds(includeIds);
        }
    }

    private int[] parseIds(String includeIds) {
        String[] ids = includeIds.split(",");
        int[] vals = new int[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            vals[i] = Integer.parseInt(ids[i]);
        }
        return vals;
    }
}

