/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebean.bean.ToStringBuilder;
import io.ebean.common.AbstractBeanCollection;
import io.ebean.common.ModifyCollection;
import io.ebean.common.ModifyEntrySet;
import io.ebean.common.ModifyKeySet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class BeanMap<K, E>
extends AbstractBeanCollection<E>
implements Map<K, E> {
    private static final long serialVersionUID = 1L;
    private Map<K, E> map;

    public BeanMap(Map<K, E> map) {
        this.map = map;
    }

    public BeanMap() {
        this(new LinkedHashMap());
    }

    public BeanMap(BeanCollectionLoader ebeanServer, EntityBean ownerBean, String propertyName) {
        super(ebeanServer, ownerBean, propertyName);
    }

    @Override
    public Map<K, E> freeze() {
        return this.map == null ? null : Collections.unmodifiableMap(this.map);
    }

    @Override
    public void toString(ToStringBuilder builder) {
        if (this.map == null || this.map.isEmpty()) {
            builder.addRaw("{}");
        } else {
            builder.addRaw("{");
            for (Map.Entry<K, E> entry : this.map.entrySet()) {
                builder.add(String.valueOf(entry.getKey()), entry.getValue());
            }
            builder.addRaw("}");
        }
    }

    @Override
    public void reset(EntityBean ownerBean, String propertyName) {
        this.ownerBean = ownerBean;
        this.propertyName = propertyName;
        this.map = null;
    }

    @Override
    public boolean isSkipSave() {
        return this.map == null || this.map.isEmpty() && !this.holdsModifications();
    }

    @Override
    public void loadFrom(BeanCollection<?> other) {
        BeanMap otherMap = (BeanMap)other;
        this.internalPutNull();
        this.map.putAll(otherMap.actualMap());
    }

    public void internalPutNull() {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
        }
    }

    public void internalPut(Object key, Object bean) {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
        }
        if (key != null) {
            this.map.put(key, bean);
        }
    }

    public void internalPutWithCheck(Object key, Object bean) {
        if (this.map == null || key == null || !this.map.containsKey(key)) {
            this.internalPut(key, bean);
        }
    }

    @Override
    public void internalAddWithCheck(Object bean) {
        throw new RuntimeException("Not allowed for map");
    }

    @Override
    public void internalAdd(Object bean) {
        throw new RuntimeException("Not allowed for map");
    }

    @Override
    public boolean isPopulated() {
        return this.map != null;
    }

    @Override
    public boolean isReference() {
        return this.map == null;
    }

    @Override
    public boolean checkEmptyLazyLoad() {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
            return true;
        }
        return false;
    }

    private void initClear() {
        this.lock.lock();
        try {
            if (this.map == null) {
                if (!this.disableLazyLoad && this.modifyListening) {
                    this.lazyLoadCollection(true);
                } else {
                    this.map = new LinkedHashMap<K, E>();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void init() {
        this.lock.lock();
        try {
            if (this.map == null) {
                if (this.disableLazyLoad) {
                    this.map = new LinkedHashMap<K, E>();
                } else {
                    this.lazyLoadCollection(false);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setActualMap(Map<?, ?> map) {
        this.map = map;
    }

    public Map<K, E> actualMap() {
        return this.map;
    }

    @Override
    public Collection<E> actualDetails() {
        return this.map.values();
    }

    @Override
    public Collection<?> actualEntries() {
        return this.map.entrySet();
    }

    public String toString() {
        if (this.map == null) {
            return "BeanMap<deferred>";
        }
        return this.map.toString();
    }

    @Override
    public boolean equals(Object object) {
        this.init();
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        this.init();
        return this.map.hashCode();
    }

    @Override
    public void clear() {
        this.initClear();
        if (this.modifyListening) {
            for (E bean : this.map.values()) {
                this.modifyRemoval(bean);
            }
        }
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.init();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.init();
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, E>> entrySet() {
        this.init();
        return this.modifyListening ? new ModifyEntrySet<K, E>(this, this.map.entrySet()) : this.map.entrySet();
    }

    @Override
    public E get(Object key) {
        this.init();
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        this.init();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.init();
        return this.modifyListening ? new ModifyKeySet<K>(this, this.map.keySet()) : this.map.keySet();
    }

    @Override
    public E put(K key, E value) {
        this.init();
        if (this.modifyListening) {
            E oldBean = this.map.put(key, value);
            if (value != oldBean) {
                this.modifyAddition((Object)value);
                this.modifyRemoval(oldBean);
            }
            return oldBean;
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends E> puts) {
        this.init();
        if (this.modifyListening) {
            for (Map.Entry<K, E> entry : puts.entrySet()) {
                E oldBean = this.map.put(entry.getKey(), entry.getValue());
                if (entry.getValue() == oldBean) continue;
                this.modifyAddition((Object)entry.getValue());
                this.modifyRemoval(oldBean);
            }
        } else {
            this.map.putAll(puts);
        }
    }

    @Override
    public void addBean(E bean) {
        throw new UnsupportedOperationException("Method not allowed on Map. Please use List instead.");
    }

    @Override
    public void removeBean(E bean) {
        throw new UnsupportedOperationException("Method not allowed on Map. Please use List instead.");
    }

    @Override
    public E remove(Object key) {
        this.init();
        if (this.modifyListening) {
            E o = this.map.remove(key);
            this.modifyRemoval(o);
            return o;
        }
        return this.map.remove(key);
    }

    @Override
    public int size() {
        this.init();
        return this.map.size();
    }

    @Override
    public Collection<E> values() {
        this.init();
        return this.modifyListening ? new ModifyCollection<E>(this, this.map.values()) : this.map.values();
    }
}

