/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.cache;

import io.ebean.cache.ServerCacheStatistics;
import io.ebean.meta.MetricVisitor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public interface ServerCache {
    default public Map<Object, Object> getAll(Set<Object> keys) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (Object key : keys) {
            Object value = this.get(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public Object get(Object var1);

    default public void putAll(Map<Object, Object> keyValues) {
        keyValues.forEach(this::put);
    }

    public void put(Object var1, Object var2);

    default public void removeAll(Set<Object> keys) {
        keys.forEach(this::remove);
    }

    public void remove(Object var1);

    public void clear();

    default public int size() {
        return 0;
    }

    default public int hitRatio() {
        return 0;
    }

    default public @Nullable ServerCacheStatistics statistics(boolean reset) {
        return null;
    }

    default public void visit(MetricVisitor visitor) {
    }

    default public <T> T unwrap(Class<T> cls) {
        return (T)this;
    }
}

