/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.FetchGroup;
import io.ebean.FetchGroupBuilder;
import io.ebean.metric.MetricFactory;
import io.ebean.service.BootstrapService;
import io.ebean.service.SpiContainerFactory;
import io.ebean.service.SpiFetchGroupQuery;
import io.ebean.service.SpiFetchGroupService;
import io.ebean.service.SpiJsonService;
import io.ebean.service.SpiProfileLocationFactory;
import io.ebean.service.SpiRawSqlService;
import java.util.ServiceLoader;

public final class XBootstrapService {
    private static final SpiContainerFactory containerFactory;
    private static final SpiRawSqlService rawSqlService;
    private static final SpiProfileLocationFactory profileLocationFactory;
    private static final SpiFetchGroupService fetchGroupService;
    private static final MetricFactory metricFactory;
    private static final SpiJsonService jsonService;

    public static MetricFactory metricFactory() {
        return metricFactory;
    }

    public static SpiJsonService jsonService() {
        return jsonService;
    }

    static SpiContainerFactory containerFactory() {
        return containerFactory;
    }

    static SpiRawSqlService rawSql() {
        return rawSqlService;
    }

    static SpiProfileLocationFactory profileLocationFactory() {
        return profileLocationFactory;
    }

    static <T> FetchGroup<T> fetchGroupOf(Class<T> cls, String select) {
        return fetchGroupService.of(cls, select);
    }

    static <T> FetchGroupBuilder<T> fetchGroupOf(Class<T> cls) {
        return fetchGroupService.of(cls);
    }

    static <T> SpiFetchGroupQuery<T> fetchGroupQueryFor(Class<T> cls) {
        return fetchGroupService.queryFor(cls);
    }

    static {
        SpiContainerFactory _factory = null;
        SpiRawSqlService _raw = null;
        SpiProfileLocationFactory _profile = null;
        SpiFetchGroupService _fetch = null;
        MetricFactory _metric = null;
        SpiJsonService _json = null;
        for (BootstrapService extension : ServiceLoader.load(BootstrapService.class)) {
            if (extension instanceof SpiContainerFactory) {
                _factory = (SpiContainerFactory)extension;
                continue;
            }
            if (extension instanceof SpiRawSqlService) {
                _raw = (SpiRawSqlService)extension;
                continue;
            }
            if (extension instanceof SpiProfileLocationFactory) {
                _profile = (SpiProfileLocationFactory)extension;
                continue;
            }
            if (extension instanceof SpiFetchGroupService) {
                _fetch = (SpiFetchGroupService)extension;
                continue;
            }
            if (extension instanceof MetricFactory) {
                _metric = (MetricFactory)extension;
                continue;
            }
            if (!(extension instanceof SpiJsonService)) continue;
            _json = (SpiJsonService)extension;
        }
        containerFactory = _factory;
        rawSqlService = _raw;
        profileLocationFactory = _profile;
        fetchGroupService = _fetch;
        metricFactory = _metric;
        jsonService = _json;
    }
}

