/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.ContractManager;
import com.xorrus.trading.common.contract.Exchange;
import com.xorrus.trading.common.contract.ExchangeAsStringSerializer;
import com.xorrus.trading.common.contract.Future;
import com.xorrus.trading.common.contract.FutureFamily$;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 02\u00020\u0001:\u000201B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tBC\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0086@\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001d\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001aJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J1\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u000bH\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J%\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0001\u00a2\u0006\u0002\b/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u00062"}, d2={"Lcom/xorrus/trading/common/contract/FutureFamily;", "", "rootSymbol", "", "tradingClass", "exchange", "Lcom/xorrus/trading/common/contract/Exchange;", "currency", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/xorrus/trading/common/contract/Exchange;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lcom/xorrus/trading/common/contract/Exchange;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getRootSymbol", "()Ljava/lang/String;", "getTradingClass", "getExchange", "()Lcom/xorrus/trading/common/contract/Exchange;", "getCurrency", "symbol", "getSymbol", "getFutures", "", "Lcom/xorrus/trading/common/contract/Future;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMultiplier", "Lcom/xorrus/trading/common/bignum/XBigNum;", "getContinuousFuture", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$common_trading_common", "Companion", "$serializer", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nFutureFamily.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FutureFamily.kt\ncom/xorrus/trading/common/contract/FutureFamily\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class FutureFamily {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootSymbol;
    @NotNull
    private final String tradingClass;
    @NotNull
    private final Exchange exchange;
    @NotNull
    private final String currency;
    @NotNull
    private static final Regex futureSymbolRegex = new Regex("^/(?<rootSymbol>[A-Z0-9]+)(@(?<currency>[A-Z]{3}))?(/(?<tradingClass>[A-Z0-9]+))? (?<exchange>[A-Z]+)$");
    @NotNull
    private static final Lazy<FutureFamily> ES$delegate = LazyKt.lazy(FutureFamily::ES_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> MES$delegate = LazyKt.lazy(FutureFamily::MES_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> NQ$delegate = LazyKt.lazy(FutureFamily::NQ_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> MNQ$delegate = LazyKt.lazy(FutureFamily::MNQ_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> RTY$delegate = LazyKt.lazy(FutureFamily::RTY_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> M2K$delegate = LazyKt.lazy(FutureFamily::M2K_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> YM$delegate = LazyKt.lazy(FutureFamily::YM_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> MYM$delegate = LazyKt.lazy(FutureFamily::MYM_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> Z$delegate = LazyKt.lazy(FutureFamily::Z_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> ESTX50$delegate = LazyKt.lazy(FutureFamily::ESTX50_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> CAC40$delegate = LazyKt.lazy(FutureFamily::CAC40_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> DAX$delegate = LazyKt.lazy(FutureFamily::DAX_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> MINI_DAX$delegate = LazyKt.lazy(FutureFamily::MINI_DAX_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> MICRO_DAX$delegate = LazyKt.lazy(FutureFamily::MICRO_DAX_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> GC$delegate = LazyKt.lazy(FutureFamily::GC_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> SI$delegate = LazyKt.lazy(FutureFamily::SI_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> SIL$delegate = LazyKt.lazy(FutureFamily::SIL_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> HG$delegate = LazyKt.lazy(FutureFamily::HG_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> PL$delegate = LazyKt.lazy(FutureFamily::PL_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> PA$delegate = LazyKt.lazy(FutureFamily::PA_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> HE$delegate = LazyKt.lazy(FutureFamily::HE_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> GF$delegate = LazyKt.lazy(FutureFamily::GF_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> LE$delegate = LazyKt.lazy(FutureFamily::LE_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> ZC$delegate = LazyKt.lazy(FutureFamily::ZC_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> ZL$delegate = LazyKt.lazy(FutureFamily::ZL_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> ZM$delegate = LazyKt.lazy(FutureFamily::ZM_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> ZO$delegate = LazyKt.lazy(FutureFamily::ZO_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> ZR$delegate = LazyKt.lazy(FutureFamily::ZR_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> ZS$delegate = LazyKt.lazy(FutureFamily::ZS_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> ZW$delegate = LazyKt.lazy(FutureFamily::ZW_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> CC$delegate = LazyKt.lazy(FutureFamily::CC_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> CT$delegate = LazyKt.lazy(FutureFamily::CT_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> KC$delegate = LazyKt.lazy(FutureFamily::KC_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> OJ$delegate = LazyKt.lazy(FutureFamily::OJ_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> SB$delegate = LazyKt.lazy(FutureFamily::SB_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> CL$delegate = LazyKt.lazy(FutureFamily::CL_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> HO$delegate = LazyKt.lazy(FutureFamily::HO_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> NG$delegate = LazyKt.lazy(FutureFamily::NG_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> RB$delegate = LazyKt.lazy(FutureFamily::RB_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> _6A$delegate = LazyKt.lazy(FutureFamily::_6A_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> _6B$delegate = LazyKt.lazy(FutureFamily::_6B_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> _6C$delegate = LazyKt.lazy(FutureFamily::_6C_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> _6E$delegate = LazyKt.lazy(FutureFamily::_6E_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> _6S$delegate = LazyKt.lazy(FutureFamily::_6S_delegate$lambda$0);
    @NotNull
    private static final Lazy<FutureFamily> _6J$delegate = LazyKt.lazy(FutureFamily::_6J_delegate$lambda$0);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FutureFamily(@NotNull String rootSymbol, @NotNull String tradingClass, @NotNull Exchange exchange, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)rootSymbol, (String)"rootSymbol");
        Intrinsics.checkNotNullParameter((Object)tradingClass, (String)"tradingClass");
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        this.rootSymbol = rootSymbol;
        this.tradingClass = tradingClass;
        this.exchange = exchange;
        this.currency = currency;
        String string = this.rootSymbol.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)this.rootSymbol, (Object)string)) {
            boolean $i$a$-require-FutureFamily$42 = false;
            String $i$a$-require-FutureFamily$42 = "rootSymbol must be uppercase";
            throw new IllegalArgumentException($i$a$-require-FutureFamily$42.toString());
        }
        String string2 = this.tradingClass.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)this.tradingClass, (Object)string2)) {
            boolean $i$a$-require-FutureFamily$52 = false;
            String $i$a$-require-FutureFamily$52 = "tradingClass must be uppercase";
            throw new IllegalArgumentException($i$a$-require-FutureFamily$52.toString());
        }
        if (this.currency.length() == 3) {
            String string3 = this.currency.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            if (Intrinsics.areEqual((Object)this.currency, (Object)string3)) {
                return;
            }
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = false;
        String string4 = "currency must be a 3-letter uppercase code";
        throw new IllegalArgumentException(string4.toString());
    }

    public /* synthetic */ FutureFamily(String string, String string2, Exchange exchange, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string3 = "USD";
        }
        this(string, string2, exchange, string3);
    }

    @NotNull
    public final String getRootSymbol() {
        return this.rootSymbol;
    }

    @NotNull
    public final String getTradingClass() {
        return this.tradingClass;
    }

    @NotNull
    public final Exchange getExchange() {
        return this.exchange;
    }

    @NotNull
    public final String getCurrency() {
        return this.currency;
    }

    @NotNull
    public final String getSymbol() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_symbol__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_symbol__u24lambda_u240.append("/").append(this.rootSymbol);
        if (!Intrinsics.areEqual((Object)this.currency, (Object)"USD")) {
            $this$_get_symbol__u24lambda_u240.append("@").append(this.currency);
        }
        if (!Intrinsics.areEqual((Object)this.tradingClass, (Object)this.rootSymbol)) {
            $this$_get_symbol__u24lambda_u240.append("/").append(this.tradingClass);
        }
        $this$_get_symbol__u24lambda_u240.append(" ").append(this.exchange);
        return stringBuilder.toString();
    }

    @Nullable
    public final Object getFutures(@NotNull Continuation<? super List<Future>> $completion) {
        return ContractManager.INSTANCE.getFutureContracts(this, $completion);
    }

    @Nullable
    public final Object getMultiplier(@NotNull Continuation<? super XBigNum> $completion) {
        return ContractManager.INSTANCE.getFutureFamilyMultiplier(this, $completion);
    }

    @Nullable
    public final Object getContinuousFuture(@NotNull Continuation<? super Future> $completion) {
        return ContractManager.INSTANCE.getContinuousFuture(this, $completion);
    }

    @NotNull
    public final String component1() {
        return this.rootSymbol;
    }

    @NotNull
    public final String component2() {
        return this.tradingClass;
    }

    @NotNull
    public final Exchange component3() {
        return this.exchange;
    }

    @NotNull
    public final String component4() {
        return this.currency;
    }

    @NotNull
    public final FutureFamily copy(@NotNull String rootSymbol, @NotNull String tradingClass, @NotNull Exchange exchange, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)rootSymbol, (String)"rootSymbol");
        Intrinsics.checkNotNullParameter((Object)tradingClass, (String)"tradingClass");
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return new FutureFamily(rootSymbol, tradingClass, exchange, currency);
    }

    public static /* synthetic */ FutureFamily copy$default(FutureFamily futureFamily, String string, String string2, Exchange exchange, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = futureFamily.rootSymbol;
        }
        if ((n & 2) != 0) {
            string2 = futureFamily.tradingClass;
        }
        if ((n & 4) != 0) {
            exchange = futureFamily.exchange;
        }
        if ((n & 8) != 0) {
            string3 = futureFamily.currency;
        }
        return futureFamily.copy(string, string2, exchange, string3);
    }

    @NotNull
    public String toString() {
        return "FutureFamily(rootSymbol=" + this.rootSymbol + ", tradingClass=" + this.tradingClass + ", exchange=" + this.exchange + ", currency=" + this.currency + ")";
    }

    public int hashCode() {
        int result = this.rootSymbol.hashCode();
        result = result * 31 + this.tradingClass.hashCode();
        result = result * 31 + this.exchange.hashCode();
        result = result * 31 + this.currency.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FutureFamily)) {
            return false;
        }
        FutureFamily futureFamily = (FutureFamily)other;
        if (!Intrinsics.areEqual((Object)this.rootSymbol, (Object)futureFamily.rootSymbol)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tradingClass, (Object)futureFamily.tradingClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.exchange, (Object)futureFamily.exchange)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currency, (Object)futureFamily.currency);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$common_trading_common(FutureFamily self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.rootSymbol);
        output.encodeStringElement(serialDesc, 1, self.tradingClass);
        output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)ExchangeAsStringSerializer.INSTANCE, (Object)self.exchange);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual((Object)self.currency, (Object)"USD")) {
            output.encodeStringElement(serialDesc, 3, self.currency);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public /* synthetic */ FutureFamily(int seen0, String rootSymbol, String tradingClass, Exchange exchange, String currency, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.rootSymbol = rootSymbol;
        this.tradingClass = tradingClass;
        this.exchange = exchange;
        this.currency = (seen0 & 8) == 0 ? "USD" : currency;
        String string = this.rootSymbol.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)this.rootSymbol, (Object)string)) {
            boolean $i$a$-require-FutureFamily$42 = false;
            String $i$a$-require-FutureFamily$42 = "rootSymbol must be uppercase";
            throw new IllegalArgumentException($i$a$-require-FutureFamily$42.toString());
        }
        String string2 = this.tradingClass.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)this.tradingClass, (Object)string2)) {
            boolean $i$a$-require-FutureFamily$52 = false;
            String $i$a$-require-FutureFamily$52 = "tradingClass must be uppercase";
            throw new IllegalArgumentException($i$a$-require-FutureFamily$52.toString());
        }
        if (this.currency.length() == 3) {
            String string3 = this.currency.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            if (Intrinsics.areEqual((Object)this.currency, (Object)string3)) {
                return;
            }
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = false;
        String string4 = "currency must be a 3-letter uppercase code";
        throw new IllegalArgumentException(string4.toString());
    }

    private static final FutureFamily ES_delegate$lambda$0() {
        return Companion.fromSymbol("/ES CME");
    }

    private static final FutureFamily MES_delegate$lambda$0() {
        return Companion.fromSymbol("/MES CME");
    }

    private static final FutureFamily NQ_delegate$lambda$0() {
        return Companion.fromSymbol("/NQ CME");
    }

    private static final FutureFamily MNQ_delegate$lambda$0() {
        return Companion.fromSymbol("/MNQ CME");
    }

    private static final FutureFamily RTY_delegate$lambda$0() {
        return Companion.fromSymbol("/RTY CME");
    }

    private static final FutureFamily M2K_delegate$lambda$0() {
        return Companion.fromSymbol("/M2K CME");
    }

    private static final FutureFamily YM_delegate$lambda$0() {
        return Companion.fromSymbol("/YM CBOT");
    }

    private static final FutureFamily MYM_delegate$lambda$0() {
        return Companion.fromSymbol("/MYM CBOT");
    }

    private static final FutureFamily Z_delegate$lambda$0() {
        return Companion.fromSymbol("/Z@GBP ICEEU");
    }

    private static final FutureFamily ESTX50_delegate$lambda$0() {
        return Companion.fromSymbol("/ESTX50@EUR/FSXE EUREX");
    }

    private static final FutureFamily CAC40_delegate$lambda$0() {
        return Companion.fromSymbol("/CAC40@EUR/MFC MONEP");
    }

    private static final FutureFamily DAX_delegate$lambda$0() {
        return Companion.fromSymbol("/DAX@EUR/FDAX EUREX");
    }

    private static final FutureFamily MINI_DAX_delegate$lambda$0() {
        return Companion.fromSymbol("/DAX@EUR/FDXM EUREX");
    }

    private static final FutureFamily MICRO_DAX_delegate$lambda$0() {
        return Companion.fromSymbol("/DAX@EUR/FDXS EUREX");
    }

    private static final FutureFamily GC_delegate$lambda$0() {
        return Companion.fromSymbol("/GC COMEX");
    }

    private static final FutureFamily SI_delegate$lambda$0() {
        return Companion.fromSymbol("/SI COMEX");
    }

    private static final FutureFamily SIL_delegate$lambda$0() {
        return Companion.fromSymbol("/SI/SIL COMEX");
    }

    private static final FutureFamily HG_delegate$lambda$0() {
        return Companion.fromSymbol("/HG COMEX");
    }

    private static final FutureFamily PL_delegate$lambda$0() {
        return Companion.fromSymbol("/PL NYMEX");
    }

    private static final FutureFamily PA_delegate$lambda$0() {
        return Companion.fromSymbol("/PA NYMEX");
    }

    private static final FutureFamily HE_delegate$lambda$0() {
        return Companion.fromSymbol("/HE CME");
    }

    private static final FutureFamily GF_delegate$lambda$0() {
        return Companion.fromSymbol("/GF CME");
    }

    private static final FutureFamily LE_delegate$lambda$0() {
        return Companion.fromSymbol("/LE CME");
    }

    private static final FutureFamily ZC_delegate$lambda$0() {
        return Companion.fromSymbol("/ZC CBOT");
    }

    private static final FutureFamily ZL_delegate$lambda$0() {
        return Companion.fromSymbol("/ZL CBOT");
    }

    private static final FutureFamily ZM_delegate$lambda$0() {
        return Companion.fromSymbol("/ZM CBOT");
    }

    private static final FutureFamily ZO_delegate$lambda$0() {
        return Companion.fromSymbol("/ZO CBOT");
    }

    private static final FutureFamily ZR_delegate$lambda$0() {
        return Companion.fromSymbol("/ZR CBOT");
    }

    private static final FutureFamily ZS_delegate$lambda$0() {
        return Companion.fromSymbol("/ZS CBOT");
    }

    private static final FutureFamily ZW_delegate$lambda$0() {
        return Companion.fromSymbol("/ZW CBOT");
    }

    private static final FutureFamily CC_delegate$lambda$0() {
        return Companion.fromSymbol("/CC NYBOT");
    }

    private static final FutureFamily CT_delegate$lambda$0() {
        return Companion.fromSymbol("/CT NYBOT");
    }

    private static final FutureFamily KC_delegate$lambda$0() {
        return Companion.fromSymbol("/KC NYBOT");
    }

    private static final FutureFamily OJ_delegate$lambda$0() {
        return Companion.fromSymbol("/OJ NYBOT");
    }

    private static final FutureFamily SB_delegate$lambda$0() {
        return Companion.fromSymbol("/SB NYBOT");
    }

    private static final FutureFamily CL_delegate$lambda$0() {
        return Companion.fromSymbol("/CL NYMEX");
    }

    private static final FutureFamily HO_delegate$lambda$0() {
        return Companion.fromSymbol("/HO NYMEX");
    }

    private static final FutureFamily NG_delegate$lambda$0() {
        return Companion.fromSymbol("/NG NYMEX");
    }

    private static final FutureFamily RB_delegate$lambda$0() {
        return Companion.fromSymbol("/RB NYMEX");
    }

    private static final FutureFamily _6A_delegate$lambda$0() {
        return Companion.fromSymbol("/AUD/6A CME");
    }

    private static final FutureFamily _6B_delegate$lambda$0() {
        return Companion.fromSymbol("/GBP/6B CME");
    }

    private static final FutureFamily _6C_delegate$lambda$0() {
        return Companion.fromSymbol("/CAD/6C CME");
    }

    private static final FutureFamily _6E_delegate$lambda$0() {
        return Companion.fromSymbol("/EUR/6E CME");
    }

    private static final FutureFamily _6S_delegate$lambda$0() {
        return Companion.fromSymbol("/CHF/6S CME");
    }

    private static final FutureFamily _6J_delegate$lambda$0() {
        return Companion.fromSymbol("/JPY/6J CME");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000)\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0003\b\u008a\u0001\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0095\u0001\u001a\t\u0012\u0004\u0012\u00020\t0\u0096\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\f\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000eR\u001b\u0010\u0014\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0015\u0010\u000eR\u001b\u0010\u0017\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u0018\u0010\u000eR\u001b\u0010\u001a\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0010\u001a\u0004\b\u001b\u0010\u000eR\u001b\u0010\u001d\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b\u001e\u0010\u000eR\u001b\u0010 \u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0010\u001a\u0004\b!\u0010\u000eR\u001b\u0010#\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0010\u001a\u0004\b$\u0010\u000eR\u001b\u0010&\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0010\u001a\u0004\b'\u0010\u000eR\u001b\u0010)\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0010\u001a\u0004\b*\u0010\u000eR\u001b\u0010,\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0010\u001a\u0004\b-\u0010\u000eR\u001b\u0010/\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0010\u001a\u0004\b0\u0010\u000eR\u001b\u00102\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0010\u001a\u0004\b3\u0010\u000eR\u001b\u00105\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\u0010\u001a\u0004\b6\u0010\u000eR\u001b\u00108\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u0010\u001a\u0004\b9\u0010\u000eR\u001b\u0010;\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\u0010\u001a\u0004\b<\u0010\u000eR\u001b\u0010>\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u0010\u001a\u0004\b?\u0010\u000eR\u001b\u0010A\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010\u0010\u001a\u0004\bB\u0010\u000eR\u001b\u0010D\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010\u0010\u001a\u0004\bE\u0010\u000eR\u001b\u0010G\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010\u0010\u001a\u0004\bH\u0010\u000eR\u001b\u0010J\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u0010\u0010\u001a\u0004\bK\u0010\u000eR\u001b\u0010M\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010\u0010\u001a\u0004\bN\u0010\u000eR\u001b\u0010P\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bR\u0010\u0010\u001a\u0004\bQ\u0010\u000eR\u001b\u0010S\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bU\u0010\u0010\u001a\u0004\bT\u0010\u000eR\u001b\u0010V\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bX\u0010\u0010\u001a\u0004\bW\u0010\u000eR\u001b\u0010Y\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010\u0010\u001a\u0004\bZ\u0010\u000eR\u001b\u0010\\\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b^\u0010\u0010\u001a\u0004\b]\u0010\u000eR\u001b\u0010_\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\ba\u0010\u0010\u001a\u0004\b`\u0010\u000eR\u001b\u0010b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bd\u0010\u0010\u001a\u0004\bc\u0010\u000eR\u001b\u0010e\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bg\u0010\u0010\u001a\u0004\bf\u0010\u000eR\u001b\u0010h\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bj\u0010\u0010\u001a\u0004\bi\u0010\u000eR\u001b\u0010k\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bm\u0010\u0010\u001a\u0004\bl\u0010\u000eR\u001b\u0010n\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bp\u0010\u0010\u001a\u0004\bo\u0010\u000eR\u001b\u0010q\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bs\u0010\u0010\u001a\u0004\br\u0010\u000eR\u001b\u0010t\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bv\u0010\u0010\u001a\u0004\bu\u0010\u000eR\u001b\u0010w\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\by\u0010\u0010\u001a\u0004\bx\u0010\u000eR\u001b\u0010z\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b|\u0010\u0010\u001a\u0004\b{\u0010\u000eR\u001b\u0010}\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u007f\u0010\u0010\u001a\u0004\b~\u0010\u000eR\u001e\u0010\u0080\u0001\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0082\u0001\u0010\u0010\u001a\u0005\b\u0081\u0001\u0010\u000eR\u001e\u0010\u0083\u0001\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0085\u0001\u0010\u0010\u001a\u0005\b\u0084\u0001\u0010\u000eR\u001e\u0010\u0086\u0001\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0088\u0001\u0010\u0010\u001a\u0005\b\u0087\u0001\u0010\u000eR\u001e\u0010\u0089\u0001\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u008b\u0001\u0010\u0010\u001a\u0005\b\u008a\u0001\u0010\u000eR\u001e\u0010\u008c\u0001\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u008e\u0001\u0010\u0010\u001a\u0005\b\u008d\u0001\u0010\u000eR\u001e\u0010\u008f\u0001\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0091\u0001\u0010\u0010\u001a\u0005\b\u0090\u0001\u0010\u000eR\u001e\u0010\u0092\u0001\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0094\u0001\u0010\u0010\u001a\u0005\b\u0093\u0001\u0010\u000e\u00a8\u0006\u0097\u0001"}, d2={"Lcom/xorrus/trading/common/contract/FutureFamily$Companion;", "", "<init>", "()V", "futureSymbolRegex", "Lkotlin/text/Regex;", "getFutureSymbolRegex$common_trading_common", "()Lkotlin/text/Regex;", "fromSymbol", "Lcom/xorrus/trading/common/contract/FutureFamily;", "symbol", "", "ES", "getES", "()Lcom/xorrus/trading/common/contract/FutureFamily;", "ES$delegate", "Lkotlin/Lazy;", "MES", "getMES", "MES$delegate", "NQ", "getNQ", "NQ$delegate", "MNQ", "getMNQ", "MNQ$delegate", "RTY", "getRTY", "RTY$delegate", "M2K", "getM2K", "M2K$delegate", "YM", "getYM", "YM$delegate", "MYM", "getMYM", "MYM$delegate", "Z", "getZ", "Z$delegate", "ESTX50", "getESTX50", "ESTX50$delegate", "CAC40", "getCAC40", "CAC40$delegate", "DAX", "getDAX", "DAX$delegate", "MINI_DAX", "getMINI_DAX", "MINI_DAX$delegate", "MICRO_DAX", "getMICRO_DAX", "MICRO_DAX$delegate", "GC", "getGC", "GC$delegate", "SI", "getSI", "SI$delegate", "SIL", "getSIL", "SIL$delegate", "HG", "getHG", "HG$delegate", "PL", "getPL", "PL$delegate", "PA", "getPA", "PA$delegate", "HE", "getHE", "HE$delegate", "GF", "getGF", "GF$delegate", "LE", "getLE", "LE$delegate", "ZC", "getZC", "ZC$delegate", "ZL", "getZL", "ZL$delegate", "ZM", "getZM", "ZM$delegate", "ZO", "getZO", "ZO$delegate", "ZR", "getZR", "ZR$delegate", "ZS", "getZS", "ZS$delegate", "ZW", "getZW", "ZW$delegate", "CC", "getCC", "CC$delegate", "CT", "getCT", "CT$delegate", "KC", "getKC", "KC$delegate", "OJ", "getOJ", "OJ$delegate", "SB", "getSB", "SB$delegate", "CL", "getCL", "CL$delegate", "HO", "getHO", "HO$delegate", "NG", "getNG", "NG$delegate", "RB", "getRB", "RB$delegate", "_6A", "get_6A", "_6A$delegate", "_6B", "get_6B", "_6B$delegate", "_6C", "get_6C", "_6C$delegate", "_6E", "get_6E", "_6E$delegate", "_6S", "get_6S", "_6S$delegate", "_6J", "get_6J", "_6J$delegate", "serializer", "Lkotlinx/serialization/KSerializer;", "common-trading-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getFutureSymbolRegex$common_trading_common() {
            return futureSymbolRegex;
        }

        @NotNull
        public final FutureFamily fromSymbol(@NotNull String symbol) {
            Object object;
            Object currency;
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            MatchResult matchResult = this.getFutureSymbolRegex$common_trading_common().matchEntire((CharSequence)symbol);
            if (matchResult == null) {
                throw new IllegalStateException(("Ung\u00fcltiges Basis-Futuresymbol: " + symbol).toString());
            }
            MatchResult match = matchResult;
            MatchGroupCollection groups = match.getGroups();
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"rootSymbol");
            Intrinsics.checkNotNull((Object)matchGroup);
            String rootSymbol = matchGroup.getValue();
            Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"currency");
            if (object2 == null || (object2 = object2.getValue()) == null) {
                object2 = currency = "USD";
            }
            if ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"tradingClass")) == null || (object = object.getValue()) == null) {
                object = rootSymbol;
            }
            Object tradingClass = object;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"exchange");
            Intrinsics.checkNotNull((Object)matchGroup2);
            String exchange = matchGroup2.getValue();
            return new FutureFamily(rootSymbol, (String)tradingClass, new Exchange(exchange), (String)currency);
        }

        @NotNull
        public final FutureFamily getES() {
            Lazy lazy = ES$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getMES() {
            Lazy lazy = MES$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getNQ() {
            Lazy lazy = NQ$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getMNQ() {
            Lazy lazy = MNQ$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getRTY() {
            Lazy lazy = RTY$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getM2K() {
            Lazy lazy = M2K$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getYM() {
            Lazy lazy = YM$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getMYM() {
            Lazy lazy = MYM$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getZ() {
            Lazy lazy = Z$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getESTX50() {
            Lazy lazy = ESTX50$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getCAC40() {
            Lazy lazy = CAC40$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getDAX() {
            Lazy lazy = DAX$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getMINI_DAX() {
            Lazy lazy = MINI_DAX$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getMICRO_DAX() {
            Lazy lazy = MICRO_DAX$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getGC() {
            Lazy lazy = GC$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getSI() {
            Lazy lazy = SI$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getSIL() {
            Lazy lazy = SIL$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getHG() {
            Lazy lazy = HG$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getPL() {
            Lazy lazy = PL$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getPA() {
            Lazy lazy = PA$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getHE() {
            Lazy lazy = HE$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getGF() {
            Lazy lazy = GF$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getLE() {
            Lazy lazy = LE$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getZC() {
            Lazy lazy = ZC$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getZL() {
            Lazy lazy = ZL$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getZM() {
            Lazy lazy = ZM$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getZO() {
            Lazy lazy = ZO$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getZR() {
            Lazy lazy = ZR$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getZS() {
            Lazy lazy = ZS$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getZW() {
            Lazy lazy = ZW$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getCC() {
            Lazy lazy = CC$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getCT() {
            Lazy lazy = CT$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getKC() {
            Lazy lazy = KC$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getOJ() {
            Lazy lazy = OJ$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getSB() {
            Lazy lazy = SB$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getCL() {
            Lazy lazy = CL$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getHO() {
            Lazy lazy = HO$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getNG() {
            Lazy lazy = NG$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily getRB() {
            Lazy lazy = RB$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily get_6A() {
            Lazy lazy = _6A$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily get_6B() {
            Lazy lazy = _6B$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily get_6C() {
            Lazy lazy = _6C$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily get_6E() {
            Lazy lazy = _6E$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily get_6S() {
            Lazy lazy = _6S$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final FutureFamily get_6J() {
            Lazy lazy = _6J$delegate;
            return (FutureFamily)lazy.getValue();
        }

        @NotNull
        public final KSerializer<FutureFamily> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

