/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract;

import com.xorrus.trading.common.contract.ExchangeAsStringSerializer;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=ExchangeAsStringSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0011\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/xorrus/trading/common/contract/Exchange;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "compareTo", "Companion", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchange.kt\ncom/xorrus/trading/common/contract/Exchange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class Exchange
implements Comparable<Exchange> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Lazy<Exchange> AMEX$delegate = LazyKt.lazy(Exchange::AMEX_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> EUREX$delegate = LazyKt.lazy(Exchange::EUREX_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> CBOE$delegate = LazyKt.lazy(Exchange::CBOE_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> CBOT$delegate = LazyKt.lazy(Exchange::CBOT_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> CME$delegate = LazyKt.lazy(Exchange::CME_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> COMEX$delegate = LazyKt.lazy(Exchange::COMEX_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> CEDX$delegate = LazyKt.lazy(Exchange::CEDX_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> ICEEU$delegate = LazyKt.lazy(Exchange::ICEEU_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> NYBOT$delegate = LazyKt.lazy(Exchange::NYBOT_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> NYMEX$delegate = LazyKt.lazy(Exchange::NYMEX_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> MONEP$delegate = LazyKt.lazy(Exchange::MONEP_delegate$lambda$0);
    @NotNull
    private static final Lazy<Exchange> SMART$delegate = LazyKt.lazy(Exchange::SMART_delegate$lambda$0);

    public Exchange(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        if (!(((CharSequence)this.name).length() > 0)) {
            boolean $i$a$-require-Exchange$32 = false;
            String $i$a$-require-Exchange$32 = "Exchange name must not be empty";
            throw new IllegalArgumentException($i$a$-require-Exchange$32.toString());
        }
        String string = this.name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)this.name, (Object)string)) {
            boolean bl = false;
            String string2 = "Exchange name must be uppercase";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return object instanceof Exchange ? Intrinsics.areEqual((Object)this.name, (Object)((Exchange)other).name) : (object instanceof String ? Intrinsics.areEqual((Object)this.name, (Object)other) : false);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(@NotNull Exchange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.name.compareTo(other.name);
    }

    private static final Exchange AMEX_delegate$lambda$0() {
        return new Exchange("AMEX");
    }

    private static final Exchange EUREX_delegate$lambda$0() {
        return new Exchange("EUREX");
    }

    private static final Exchange CBOE_delegate$lambda$0() {
        return new Exchange("CBOE");
    }

    private static final Exchange CBOT_delegate$lambda$0() {
        return new Exchange("CBOT");
    }

    private static final Exchange CME_delegate$lambda$0() {
        return new Exchange("CME");
    }

    private static final Exchange COMEX_delegate$lambda$0() {
        return new Exchange("COMEX");
    }

    private static final Exchange CEDX_delegate$lambda$0() {
        return new Exchange("CEDX");
    }

    private static final Exchange ICEEU_delegate$lambda$0() {
        return new Exchange("ICEEU");
    }

    private static final Exchange NYBOT_delegate$lambda$0() {
        return new Exchange("NYBOT");
    }

    private static final Exchange NYMEX_delegate$lambda$0() {
        return new Exchange("NYMEX");
    }

    private static final Exchange MONEP_delegate$lambda$0() {
        return new Exchange("MONEP");
    }

    private static final Exchange SMART_delegate$lambda$0() {
        return new Exchange("SMART");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050,R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u001b\u0010\r\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\u000e\u0010\u0007R\u001b\u0010\u0010\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\t\u001a\u0004\b\u0011\u0010\u0007R\u001b\u0010\u0013\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\t\u001a\u0004\b\u0014\u0010\u0007R\u001b\u0010\u0016\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0017\u0010\u0007R\u001b\u0010\u0019\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\t\u001a\u0004\b\u001a\u0010\u0007R\u001b\u0010\u001c\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\t\u001a\u0004\b\u001d\u0010\u0007R\u001b\u0010\u001f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\t\u001a\u0004\b \u0010\u0007R\u001b\u0010\"\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\t\u001a\u0004\b#\u0010\u0007R\u001b\u0010%\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\t\u001a\u0004\b&\u0010\u0007R\u001b\u0010(\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\t\u001a\u0004\b)\u0010\u0007\u00a8\u0006-"}, d2={"Lcom/xorrus/trading/common/contract/Exchange$Companion;", "", "<init>", "()V", "AMEX", "Lcom/xorrus/trading/common/contract/Exchange;", "getAMEX", "()Lcom/xorrus/trading/common/contract/Exchange;", "AMEX$delegate", "Lkotlin/Lazy;", "EUREX", "getEUREX", "EUREX$delegate", "CBOE", "getCBOE", "CBOE$delegate", "CBOT", "getCBOT", "CBOT$delegate", "CME", "getCME", "CME$delegate", "COMEX", "getCOMEX", "COMEX$delegate", "CEDX", "getCEDX", "CEDX$delegate", "ICEEU", "getICEEU", "ICEEU$delegate", "NYBOT", "getNYBOT", "NYBOT$delegate", "NYMEX", "getNYMEX", "NYMEX$delegate", "MONEP", "getMONEP", "MONEP$delegate", "SMART", "getSMART", "SMART$delegate", "serializer", "Lkotlinx/serialization/KSerializer;", "common-trading-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Exchange getAMEX() {
            Lazy lazy = AMEX$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getEUREX() {
            Lazy lazy = EUREX$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getCBOE() {
            Lazy lazy = CBOE$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getCBOT() {
            Lazy lazy = CBOT$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getCME() {
            Lazy lazy = CME$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getCOMEX() {
            Lazy lazy = COMEX$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getCEDX() {
            Lazy lazy = CEDX$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getICEEU() {
            Lazy lazy = ICEEU$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getNYBOT() {
            Lazy lazy = NYBOT$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getNYMEX() {
            Lazy lazy = NYMEX$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getMONEP() {
            Lazy lazy = MONEP$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final Exchange getSMART() {
            Lazy lazy = SMART$delegate;
            return (Exchange)lazy.getValue();
        }

        @NotNull
        public final KSerializer<Exchange> serializer() {
            return ExchangeAsStringSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

