/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.statistic;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.OpenEndRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 D2\u00020\u0001:\u0001DBO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u00101\u001a\u00020*H\u0016J\u0006\u00102\u001a\u00020*J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\u0010\u00104\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b5\u0010\u0015J\t\u00106\u001a\u00020\u0007H\u00c6\u0003J\t\u00107\u001a\u00020\u0007H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\nH\u00c6\u0003Jh\u0010<\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0004\b=\u0010>J\u0013\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010B\u001a\u00020CH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010 \"\u0004\b$\u0010\"R\u001c\u0010\f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010 \"\u0004\b&\u0010\"R\u001c\u0010\r\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u0013\u0010)\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006E"}, d2={"Lcom/xorrus/trading/common/statistic/Bar;", "", "contract", "Lcom/xorrus/trading/common/contract/Contract;", "duration", "Lkotlin/time/Duration;", "start", "Lkotlin/time/Instant;", "end", "open", "Lcom/xorrus/trading/common/bignum/XBigNum;", "high", "low", "close", "<init>", "(Lcom/xorrus/trading/common/contract/Contract;JLkotlin/time/Instant;Lkotlin/time/Instant;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getContract", "()Lcom/xorrus/trading/common/contract/Contract;", "setContract", "(Lcom/xorrus/trading/common/contract/Contract;)V", "getDuration-UwyO8pc", "()J", "setDuration-LRDsOJo", "(J)V", "J", "getStart", "()Lkotlin/time/Instant;", "setStart", "(Lkotlin/time/Instant;)V", "getEnd", "setEnd", "getOpen", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "setOpen", "(Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getHigh", "setHigh", "getLow", "setLow", "getClose", "setClose", "direction", "", "getDirection", "()Ljava/lang/String;", "timeWindow", "Lkotlin/ranges/OpenEndRange;", "getTimeWindow", "()Lkotlin/ranges/OpenEndRange;", "toString", "toCsv", "component1", "component2", "component2-UwyO8pc", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "copy-5fuBHu4", "(Lcom/xorrus/trading/common/contract/Contract;JLkotlin/time/Instant;Lkotlin/time/Instant;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;)Lcom/xorrus/trading/common/statistic/Bar;", "equals", "", "other", "hashCode", "", "Companion", "common-trading-common"})
public final class Bar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Contract contract;
    private long duration;
    @NotNull
    private Instant start;
    @NotNull
    private Instant end;
    @Nullable
    private XBigNum open;
    @Nullable
    private XBigNum high;
    @Nullable
    private XBigNum low;
    @Nullable
    private XBigNum close;

    private Bar(Contract contract, long duration, Instant start, Instant end, XBigNum open, XBigNum high, XBigNum low, XBigNum close) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.contract = contract;
        this.duration = duration;
        this.start = start;
        this.end = end;
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
    }

    @NotNull
    public final Contract getContract() {
        return this.contract;
    }

    public final void setContract(@NotNull Contract contract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"<set-?>");
        this.contract = contract;
    }

    public final long getDuration-UwyO8pc() {
        return this.duration;
    }

    public final void setDuration-LRDsOJo(long l) {
        this.duration = l;
    }

    @NotNull
    public final Instant getStart() {
        return this.start;
    }

    public final void setStart(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.start = instant;
    }

    @NotNull
    public final Instant getEnd() {
        return this.end;
    }

    public final void setEnd(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.end = instant;
    }

    @Nullable
    public final XBigNum getOpen() {
        return this.open;
    }

    public final void setOpen(@Nullable XBigNum xBigNum) {
        this.open = xBigNum;
    }

    @Nullable
    public final XBigNum getHigh() {
        return this.high;
    }

    public final void setHigh(@Nullable XBigNum xBigNum) {
        this.high = xBigNum;
    }

    @Nullable
    public final XBigNum getLow() {
        return this.low;
    }

    public final void setLow(@Nullable XBigNum xBigNum) {
        this.low = xBigNum;
    }

    @Nullable
    public final XBigNum getClose() {
        return this.close;
    }

    public final void setClose(@Nullable XBigNum xBigNum) {
        this.close = xBigNum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getDirection() {
        if (this.open != null && this.close != null) {
            XBigNum xBigNum = this.open;
            Intrinsics.checkNotNull((Object)xBigNum);
            XBigNum xBigNum2 = this.close;
            Intrinsics.checkNotNull((Object)xBigNum2);
            if (xBigNum.compareTo(xBigNum2) < 0) {
                return "BULLISH";
            }
        }
        if (this.open != null && this.close != null) {
            XBigNum xBigNum = this.open;
            Intrinsics.checkNotNull((Object)xBigNum);
            XBigNum xBigNum3 = this.close;
            Intrinsics.checkNotNull((Object)xBigNum3);
            if (xBigNum.compareTo(xBigNum3) > 0) {
                return "BEARISH";
            }
        }
        if (this.open == null) return null;
        if (this.close == null) return null;
        XBigNum xBigNum = this.open;
        Intrinsics.checkNotNull((Object)xBigNum);
        XBigNum xBigNum4 = this.close;
        Intrinsics.checkNotNull((Object)xBigNum4);
        if (!Intrinsics.areEqual((Object)xBigNum, (Object)xBigNum4)) return null;
        return "NEUTRAL";
    }

    @NotNull
    public final OpenEndRange<Instant> getTimeWindow() {
        return RangesKt.rangeUntil((Comparable)((Comparable)this.start), (Comparable)((Comparable)this.end));
    }

    @NotNull
    public String toString() {
        return "Bar " + this.contract + " " + Duration.toString-impl((long)this.duration) + " " + this.start + ".." + this.end + " f\u00fcr " + this.contract + ": O: " + this.open + ", H: " + this.high + ", L: " + this.low + ", C: " + this.close;
    }

    @NotNull
    public final String toCsv() {
        StringBuilder stringBuilder;
        StringBuilder $this$toCsv_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toCsv_u24lambda_u240.append(this.contract.getSymbol());
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(Duration.box-impl((long)this.duration));
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.start);
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.end);
        $this$toCsv_u24lambda_u240.append(";");
        XBigNum xBigNum = this.open;
        $this$toCsv_u24lambda_u240.append(xBigNum != null && (xBigNum = xBigNum.toMinScale()) != null ? (Comparable)xBigNum : (Comparable)((Object)""));
        $this$toCsv_u24lambda_u240.append(";");
        XBigNum xBigNum2 = this.high;
        $this$toCsv_u24lambda_u240.append(xBigNum2 != null && (xBigNum2 = xBigNum2.toMinScale()) != null ? (Comparable)xBigNum2 : (Comparable)((Object)""));
        $this$toCsv_u24lambda_u240.append(";");
        XBigNum xBigNum3 = this.low;
        $this$toCsv_u24lambda_u240.append(xBigNum3 != null && (xBigNum3 = xBigNum3.toMinScale()) != null ? (Comparable)xBigNum3 : (Comparable)((Object)""));
        $this$toCsv_u24lambda_u240.append(";");
        XBigNum xBigNum4 = this.close;
        $this$toCsv_u24lambda_u240.append(xBigNum4 != null && (xBigNum4 = xBigNum4.toMinScale()) != null ? (Comparable)xBigNum4 : (Comparable)((Object)""));
        return stringBuilder.toString();
    }

    @NotNull
    public final Contract component1() {
        return this.contract;
    }

    public final long component2-UwyO8pc() {
        return this.duration;
    }

    @NotNull
    public final Instant component3() {
        return this.start;
    }

    @NotNull
    public final Instant component4() {
        return this.end;
    }

    @Nullable
    public final XBigNum component5() {
        return this.open;
    }

    @Nullable
    public final XBigNum component6() {
        return this.high;
    }

    @Nullable
    public final XBigNum component7() {
        return this.low;
    }

    @Nullable
    public final XBigNum component8() {
        return this.close;
    }

    @NotNull
    public final Bar copy-5fuBHu4(@NotNull Contract contract, long l, @NotNull Instant start, @NotNull Instant end, @Nullable XBigNum open, @Nullable XBigNum high, @Nullable XBigNum low, @Nullable XBigNum close) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new Bar(contract, l, start, end, open, high, low, close, null);
    }

    public static /* synthetic */ Bar copy-5fuBHu4$default(Bar bar, Contract contract, long l, Instant instant, Instant instant2, XBigNum xBigNum, XBigNum xBigNum2, XBigNum xBigNum3, XBigNum xBigNum4, int n, Object object) {
        if ((n & 1) != 0) {
            contract = bar.contract;
        }
        if ((n & 2) != 0) {
            l = bar.duration;
        }
        if ((n & 4) != 0) {
            instant = bar.start;
        }
        if ((n & 8) != 0) {
            instant2 = bar.end;
        }
        if ((n & 0x10) != 0) {
            xBigNum = bar.open;
        }
        if ((n & 0x20) != 0) {
            xBigNum2 = bar.high;
        }
        if ((n & 0x40) != 0) {
            xBigNum3 = bar.low;
        }
        if ((n & 0x80) != 0) {
            xBigNum4 = bar.close;
        }
        return bar.copy-5fuBHu4(contract, l, instant, instant2, xBigNum, xBigNum2, xBigNum3, xBigNum4);
    }

    public int hashCode() {
        int result = this.contract.hashCode();
        result = result * 31 + Duration.hashCode-impl((long)this.duration);
        result = result * 31 + this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + (this.open == null ? 0 : this.open.hashCode());
        result = result * 31 + (this.high == null ? 0 : this.high.hashCode());
        result = result * 31 + (this.low == null ? 0 : this.low.hashCode());
        result = result * 31 + (this.close == null ? 0 : this.close.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bar)) {
            return false;
        }
        Bar bar = (Bar)other;
        if (!Intrinsics.areEqual((Object)this.contract, (Object)bar.contract)) {
            return false;
        }
        if (!Duration.equals-impl0((long)this.duration, (long)bar.duration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)bar.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)bar.end)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.open, (Object)bar.open)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.high, (Object)bar.high)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.low, (Object)bar.low)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.close, (Object)bar.close);
    }

    public /* synthetic */ Bar(Contract contract, long duration, Instant start, Instant end, XBigNum open, XBigNum high, XBigNum low, XBigNum close, DefaultConstructorMarker $constructor_marker) {
        this(contract, duration, start, end, open, high, low, close);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fJ\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u000e\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lcom/xorrus/trading/common/statistic/Bar$Companion;", "", "<init>", "()V", "fromCsv", "Lcom/xorrus/trading/common/statistic/Bar;", "cells", "", "", "idx", "", "setIdx", "Lkotlin/Function1;", "", "csv", "common-trading-common"})
    @SourceDebugExtension(value={"SMAP\nBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bar.kt\ncom/xorrus/trading/common/statistic/Bar$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n774#3:94\n865#3,2:95\n1563#3:97\n1634#3,3:98\n*S KotlinDebug\n*F\n+ 1 Bar.kt\ncom/xorrus/trading/common/statistic/Bar$Companion\n*L\n85#1:94\n85#1:95,2\n86#1:97\n86#1:98,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Bar fromCsv(@NotNull List<String> cells, int idx, @NotNull Function1<? super Integer, Unit> setIdx) {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter(cells, (String)"cells");
            Intrinsics.checkNotNullParameter(setIdx, (String)"setIdx");
            int i = idx;
            String it = cells.get(i++);
            boolean bl = false;
            Contract symbol = Contract.Companion.fromSymbol(it);
            long duration = DateKt.toDuration(cells.get(i++));
            Instant start = DateKt.toInstant(cells.get(i++));
            Instant end = DateKt.toInstant(cells.get(i++));
            String it2 = string2 = cells.get(i++);
            boolean bl2 = false;
            String string3 = ((CharSequence)it2).length() > 0 ? string2 : null;
            XBigNum open = string3 != null ? XbignumKt.toXBigNum(string3) : null;
            String it3 = it2 = cells.get(i++);
            boolean bl3 = false;
            String string4 = ((CharSequence)it3).length() > 0 ? it2 : null;
            XBigNum high = string4 != null ? XbignumKt.toXBigNum(string4) : null;
            String it4 = it3 = cells.get(i++);
            boolean bl4 = false;
            String string5 = ((CharSequence)it4).length() > 0 ? it3 : null;
            XBigNum low = string5 != null ? XbignumKt.toXBigNum(string5) : null;
            String it5 = string = cells.get(i);
            boolean bl5 = false;
            String string6 = ((CharSequence)it5).length() > 0 ? string : null;
            XBigNum close = string6 != null ? XbignumKt.toXBigNum(string6) : null;
            Bar result = new Bar(symbol, duration, start, end, open, high, low, close, null);
            setIdx.invoke((Object)i);
            return result;
        }

        public static /* synthetic */ Bar fromCsv$default(Companion companion, List list, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                function1 = Companion::fromCsv$lambda$0;
            }
            return companion.fromCsv(list, n, (Function1<? super Integer, Unit>)function1);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Bar> fromCsv(@NotNull String csv) {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)csv, (String)"csv");
            String[] stringArray = new String[]{"\n"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)csv, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{";"};
                collection.add(com.xorrus.trading.common.statistic.Bar$Companion.fromCsv$default(Companion, StringsKt.split$default((CharSequence)((CharSequence)line), (String[])stringArray2, (boolean)false, (int)0, (int)6, null), 0, null, 6, null));
            }
            return (List)destination$iv$iv;
        }

        private static final Unit fromCsv$lambda$0(int it) {
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

