/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.bignum;

import com.xorrus.trading.common.bignum.XBigNum;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0013\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/xorrus/trading/common/bignum/XClosedBigNumRange;", "Lkotlin/ranges/ClosedRange;", "Lcom/xorrus/trading/common/bignum/XBigNum;", "start", "endInclusive", "<init>", "(Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getStart", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getEndInclusive", "contains", "", "value", "isEmpty", "equals", "other", "", "hashCode", "", "toString", "", "common-trading-common"})
public final class XClosedBigNumRange
implements ClosedRange<XBigNum> {
    @NotNull
    private final XBigNum start;
    @NotNull
    private final XBigNum endInclusive;

    public XClosedBigNumRange(@NotNull XBigNum start, @NotNull XBigNum endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        this.start = start;
        this.endInclusive = endInclusive;
    }

    @NotNull
    public XBigNum getStart() {
        return this.start;
    }

    @NotNull
    public XBigNum getEndInclusive() {
        return this.endInclusive;
    }

    public boolean contains(@NotNull XBigNum value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.compareTo(this.getStart()) >= 0 && value.compareTo(this.getEndInclusive()) <= 0;
    }

    public boolean isEmpty() {
        return this.getStart().compareTo(this.getEndInclusive()) > 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof XClosedBigNumRange && (this.isEmpty() && ((XClosedBigNumRange)other).isEmpty() || Intrinsics.areEqual((Object)this.getStart(), (Object)((XClosedBigNumRange)other).getStart()) && Intrinsics.areEqual((Object)this.getEndInclusive(), (Object)((XClosedBigNumRange)other).getEndInclusive()));
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : 31 * this.getStart().hashCode() + this.getEndInclusive().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getStart() + ".." + this.getEndInclusive();
    }
}

