/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract.indicator;

import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/xorrus/trading/common/contract/indicator/Rotation;", "", "contract", "Lcom/xorrus/trading/common/contract/Contract;", "from", "Lkotlin/time/Instant;", "to", "move", "Lcom/xorrus/trading/common/bignum/XBigNum;", "<init>", "(Lcom/xorrus/trading/common/contract/Contract;Lkotlin/time/Instant;Lkotlin/time/Instant;Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getContract", "()Lcom/xorrus/trading/common/contract/Contract;", "getFrom", "()Lkotlin/time/Instant;", "getTo", "getMove", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "toCsv", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "common-trading-common"})
public final class Rotation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Contract contract;
    @NotNull
    private final Instant from;
    @NotNull
    private final Instant to;
    @NotNull
    private final XBigNum move;
    @NotNull
    public static final String VERSION = "1";

    public Rotation(@NotNull Contract contract, @NotNull Instant from, @NotNull Instant to, @NotNull XBigNum move) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        this.contract = contract;
        this.from = from;
        this.to = to;
        this.move = move;
    }

    @NotNull
    public final Contract getContract() {
        return this.contract;
    }

    @NotNull
    public final Instant getFrom() {
        return this.from;
    }

    @NotNull
    public final Instant getTo() {
        return this.to;
    }

    @NotNull
    public final XBigNum getMove() {
        return this.move;
    }

    @NotNull
    public final String toCsv() {
        StringBuilder stringBuilder;
        StringBuilder $this$toCsv_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toCsv_u24lambda_u240.append(VERSION);
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.contract.getSymbol());
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.from);
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.to);
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.move);
        return stringBuilder.toString();
    }

    @NotNull
    public final Contract component1() {
        return this.contract;
    }

    @NotNull
    public final Instant component2() {
        return this.from;
    }

    @NotNull
    public final Instant component3() {
        return this.to;
    }

    @NotNull
    public final XBigNum component4() {
        return this.move;
    }

    @NotNull
    public final Rotation copy(@NotNull Contract contract, @NotNull Instant from, @NotNull Instant to, @NotNull XBigNum move) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        return new Rotation(contract, from, to, move);
    }

    public static /* synthetic */ Rotation copy$default(Rotation rotation, Contract contract, Instant instant, Instant instant2, XBigNum xBigNum, int n, Object object) {
        if ((n & 1) != 0) {
            contract = rotation.contract;
        }
        if ((n & 2) != 0) {
            instant = rotation.from;
        }
        if ((n & 4) != 0) {
            instant2 = rotation.to;
        }
        if ((n & 8) != 0) {
            xBigNum = rotation.move;
        }
        return rotation.copy(contract, instant, instant2, xBigNum);
    }

    @NotNull
    public String toString() {
        return "Rotation(contract=" + this.contract + ", from=" + this.from + ", to=" + this.to + ", move=" + this.move + ")";
    }

    public int hashCode() {
        int result = this.contract.hashCode();
        result = result * 31 + this.from.hashCode();
        result = result * 31 + this.to.hashCode();
        result = result * 31 + this.move.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rotation)) {
            return false;
        }
        Rotation rotation = (Rotation)other;
        if (!Intrinsics.areEqual((Object)this.contract, (Object)rotation.contract)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.from, (Object)rotation.from)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.to, (Object)rotation.to)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.move, (Object)rotation.move);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/xorrus/trading/common/contract/indicator/Rotation$Companion;", "", "<init>", "()V", "VERSION", "", "fromCsv", "Lcom/xorrus/trading/common/contract/indicator/Rotation;", "cells", "", "idx", "", "setIdx", "Lkotlin/Function1;", "", "csv", "common-trading-common"})
    @SourceDebugExtension(value={"SMAP\nRotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rotation.kt\ncom/xorrus/trading/common/contract/indicator/Rotation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n774#2:50\n865#2,2:51\n1563#2:53\n1634#2,3:54\n*S KotlinDebug\n*F\n+ 1 Rotation.kt\ncom/xorrus/trading/common/contract/indicator/Rotation$Companion\n*L\n44#1:50\n44#1:51,2\n45#1:53\n45#1:54,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rotation fromCsv(@NotNull List<String> cells, int idx, @NotNull Function1<? super Integer, Unit> setIdx) {
            Intrinsics.checkNotNullParameter(cells, (String)"cells");
            Intrinsics.checkNotNullParameter(setIdx, (String)"setIdx");
            int i = idx;
            boolean bl = Intrinsics.areEqual((Object)cells.get(i++), (Object)Rotation.VERSION);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Rotation result = new Rotation(Contract.Companion.fromSymbol(cells.get(i++)), Instant.Companion.parse((CharSequence)cells.get(i++)), Instant.Companion.parse((CharSequence)cells.get(i++)), XbignumKt.toXBigNum(cells.get(i++)));
            setIdx.invoke((Object)i);
            return result;
        }

        public static /* synthetic */ Rotation fromCsv$default(Companion companion, List list, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                function1 = Companion::fromCsv$lambda$0;
            }
            return companion.fromCsv(list, n, (Function1<? super Integer, Unit>)function1);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Rotation> fromCsv(@NotNull String csv) {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)csv, (String)"csv");
            String[] stringArray = new String[]{"\n"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)csv, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{";"};
                collection.add(com.xorrus.trading.common.contract.indicator.Rotation$Companion.fromCsv$default(Companion, StringsKt.split$default((CharSequence)((CharSequence)line), (String[])stringArray2, (boolean)false, (int)0, (int)6, null), 0, null, 6, null));
            }
            return (List)destination$iv$iv;
        }

        private static final Unit fromCsv$lambda$0(int it) {
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

