/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract;

import com.xorrus.trading.common.TimezoneKt;
import com.xorrus.trading.common.contract.ContractManager;
import com.xorrus.trading.common.contract.ContractVisitor;
import com.xorrus.trading.common.contract.Index$;
import com.xorrus.trading.common.contract.OptionFilter;
import com.xorrus.trading.common.contract.Underlying;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="Index")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ!\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J%\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0001\u00a2\u0006\u0002\b+R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\u00a8\u0006."}, d2={"Lcom/xorrus/trading/common/contract/Index;", "Lcom/xorrus/trading/common/contract/Underlying;", "tickerSymbol", "", "currency", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTickerSymbol", "()Ljava/lang/String;", "getCurrency", "symbol", "getSymbol", "visit", "RESULT", "visitor", "Lcom/xorrus/trading/common/contract/ContractVisitor;", "(Lcom/xorrus/trading/common/contract/ContractVisitor;)Ljava/lang/Object;", "getUnderlyingExpirationTime", "Lkotlinx/datetime/LocalTime;", "tradingClass", "getTimezone", "Lkotlinx/datetime/TimeZone;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$common_trading_common", "Companion", "$serializer", "common-trading-common"})
public final class Index
extends Underlying {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tickerSymbol;
    @NotNull
    private final String currency;
    @NotNull
    private static final Regex indexSymbolRegEx = new Regex("^@(?<tickerSymbol>[^/@ ]+)(?:@(?<currency>[A-Z]{3}))?$");

    public Index(@NotNull String tickerSymbol, @NotNull String currency) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tickerSymbol, (String)"tickerSymbol");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        super(null);
        this.tickerSymbol = tickerSymbol;
        this.currency = currency;
        String string2 = string = this.getTickerSymbol();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)string2, (Object)string3)) {
            boolean bl = false;
            String string4 = "Ticker symbol must be uppercase.";
            throw new IllegalArgumentException(string4.toString());
        }
    }

    public /* synthetic */ Index(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "USD";
        }
        this(string, string2);
    }

    @Override
    @NotNull
    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    @Override
    @NotNull
    public String getCurrency() {
        return this.currency;
    }

    @Override
    @NotNull
    public String getSymbol() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_symbol__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_symbol__u24lambda_u240.append("@");
        $this$_get_symbol__u24lambda_u240.append(this.getTickerSymbol());
        if (!Intrinsics.areEqual((Object)this.getCurrency(), (Object)"USD")) {
            $this$_get_symbol__u24lambda_u240.append("@").append(this.getCurrency());
        }
        return stringBuilder.toString();
    }

    @Override
    public <RESULT> RESULT visit(@NotNull ContractVisitor<RESULT> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return visitor.visit(this);
    }

    @Override
    @NotNull
    public LocalTime getUnderlyingExpirationTime(@NotNull String tradingClass) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)tradingClass, (String)"tradingClass");
        Index index = this;
        LocalTime localTime = Intrinsics.areEqual((Object)index, (Object)Companion.getSPX()) ? (Intrinsics.areEqual((Object)(string2 = tradingClass), (Object)"SPX") ? new LocalTime(9, 31, 0, 0, 12, null) : (Intrinsics.areEqual((Object)string2, (Object)"SPXW") ? new LocalTime(16, 0, 0, 0, 12, null) : super.getUnderlyingExpirationTime(tradingClass))) : (Intrinsics.areEqual((Object)index, (Object)Companion.getRUT()) ? (Intrinsics.areEqual((Object)(string = tradingClass), (Object)"RUT") ? new LocalTime(9, 31, 0, 0, 12, null) : (Intrinsics.areEqual((Object)string, (Object)"RUTW") ? new LocalTime(16, 0, 0, 0, 12, null) : super.getUnderlyingExpirationTime(tradingClass))) : super.getUnderlyingExpirationTime(tradingClass));
        return localTime;
    }

    @Override
    @NotNull
    public TimeZone getTimezone() {
        Index index = this;
        return Intrinsics.areEqual((Object)index, (Object)Companion.getSPX()) ? TimezoneKt.getNewYorkTimezone() : (Intrinsics.areEqual((Object)index, (Object)Companion.getRUT()) ? TimezoneKt.getNewYorkTimezone() : super.getTimezone());
    }

    @NotNull
    public final String component1() {
        return this.tickerSymbol;
    }

    @NotNull
    public final String component2() {
        return this.currency;
    }

    @NotNull
    public final Index copy(@NotNull String tickerSymbol, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)tickerSymbol, (String)"tickerSymbol");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return new Index(tickerSymbol, currency);
    }

    public static /* synthetic */ Index copy$default(Index index, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = index.tickerSymbol;
        }
        if ((n & 2) != 0) {
            string2 = index.currency;
        }
        return index.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Index(tickerSymbol=" + this.tickerSymbol + ", currency=" + this.currency + ")";
    }

    public int hashCode() {
        int result = this.tickerSymbol.hashCode();
        result = result * 31 + this.currency.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Index)) {
            return false;
        }
        Index index = (Index)other;
        if (!Intrinsics.areEqual((Object)this.tickerSymbol, (Object)index.tickerSymbol)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currency, (Object)index.currency);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$common_trading_common(Index self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Underlying.write$Self(self, output, serialDesc);
        output.encodeStringElement(serialDesc, 0, self.getTickerSymbol());
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual((Object)self.getCurrency(), (Object)"USD")) {
            output.encodeStringElement(serialDesc, 1, self.getCurrency());
        }
    }

    public /* synthetic */ Index(int seen0, String tickerSymbol, String currency, SerializationConstructorMarker serializationConstructorMarker) {
        String string;
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, serializationConstructorMarker);
        this.tickerSymbol = tickerSymbol;
        this.currency = (seen0 & 2) == 0 ? "USD" : currency;
        String string2 = string = this.getTickerSymbol();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)string2, (Object)string3)) {
            boolean bl = false;
            String string4 = "Ticker symbol must be uppercase.";
            throw new IllegalArgumentException(string4.toString());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u0011\u0010\u001e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u0011\u0010 \u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/xorrus/trading/common/contract/Index$Companion;", "", "<init>", "()V", "indexSymbolRegEx", "Lkotlin/text/Regex;", "getIndexSymbolRegEx$common_trading_common", "()Lkotlin/text/Regex;", "fromSymbol", "Lcom/xorrus/trading/common/contract/Index;", "symbol", "", "search", "Lkotlinx/coroutines/flow/Flow;", "searchKey", "withOptions", "Lcom/xorrus/trading/common/contract/OptionFilter;", "SPX", "getSPX", "()Lcom/xorrus/trading/common/contract/Index;", "RUT", "getRUT", "VIX", "getVIX", "VIX3M", "getVIX3M", "VVIX", "getVVIX", "PCCI", "getPCCI", "PCCE", "getPCCE", "DJX", "getDJX", "serializer", "Lkotlinx/serialization/KSerializer;", "common-trading-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getIndexSymbolRegEx$common_trading_common() {
            return indexSymbolRegEx;
        }

        @NotNull
        public final Index fromSymbol(@NotNull String symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            try {
                String string;
                String string2;
                MatchResult matchResult = this.getIndexSymbolRegEx$common_trading_common().matchEntire((CharSequence)symbol);
                if (matchResult == null) {
                    throw new IllegalStateException("symbol does not match pattern".toString());
                }
                MatchResult matchResult2 = matchResult;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"tickerSymbol");
                if (object != null && (object = object.getValue()) != null) {
                    String string3 = ((String)object).toUpperCase(Locale.ROOT);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                } else {
                    string2 = null;
                }
                Intrinsics.checkNotNull(string2);
                String tickerSymbol = string2;
                Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"currency");
                if (object2 != null && (object2 = object2.getValue()) != null) {
                    String string4 = ((String)object2).toUpperCase(Locale.ROOT);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                } else {
                    string = null;
                }
                String currency = string;
                return currency != null ? new Index(tickerSymbol, currency) : new Index(tickerSymbol, null, 2, null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid index symbol: " + symbol, e);
            }
        }

        @NotNull
        public final Flow<Index> search(@NotNull String searchKey, @NotNull OptionFilter withOptions) {
            Intrinsics.checkNotNullParameter((Object)searchKey, (String)"searchKey");
            Intrinsics.checkNotNullParameter((Object)((Object)withOptions), (String)"withOptions");
            return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super Index>, Continuation<? super Unit>, Object>(searchKey, withOptions, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ String $searchKey;
                final /* synthetic */ OptionFilter $withOptions;
                {
                    this.$searchKey = $searchKey;
                    this.$withOptions = $withOptions;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (FlowCollector)this.L$0;
                    var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = $this$flow;
                            this.label = 1;
                            v0 = ContractManager.INSTANCE.searchUnderlyings(this.$searchKey, this.$withOptions, true, false, false, (Continuation<? super List<? extends Underlying>>)((Continuation)this));
                            if (v0 == var9_3) {
                                return var9_3;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            $this$forEach$iv = (Iterable)v0;
                            $i$f$forEach = 0;
                            var5_6 = $this$forEach$iv.iterator();
lbl19:
                            // 3 sources

                            while (var5_6.hasNext()) {
                                element$iv = var5_6.next();
                                underlying = (Underlying)element$iv;
                                $i$a$-forEach-Index$Companion$search$1$1 = 0;
                                Intrinsics.checkNotNull((Object)underlying, (String)"null cannot be cast to non-null type com.xorrus.trading.common.contract.Index");
                                this.L$0 = $this$flow;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                                this.L$2 = var5_6;
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)underlying);
                                this.I$0 = $i$f$forEach;
                                this.I$1 = $i$a$-forEach-Index$Companion$search$1$1;
                                this.label = 2;
                                v1 = $this$flow.emit((Object)((Index)underlying), (Continuation)this);
                                if (v1 != var9_3) continue;
                                return var9_3;
                            }
                            break;
                        }
                        case 2: {
                            $i$a$-forEach-Index$Companion$search$1$1 = this.I$1;
                            $i$f$forEach = this.I$0;
                            underlying = (Underlying)this.L$4;
                            element$iv = this.L$3;
                            var5_6 = (Iterator)this.L$2;
                            $this$forEach$iv = (Iterable)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl19
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(FlowCollector<? super Index> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public static /* synthetic */ Flow search$default(Companion companion, String string, OptionFilter optionFilter, int n, Object object) {
            if ((n & 2) != 0) {
                optionFilter = OptionFilter.WITH_AND_WITHOUT;
            }
            return companion.search(string, optionFilter);
        }

        @NotNull
        public final Index getSPX() {
            return new Index("SPX", null, 2, null);
        }

        @NotNull
        public final Index getRUT() {
            return new Index("RUT", null, 2, null);
        }

        @NotNull
        public final Index getVIX() {
            return new Index("VIX", null, 2, null);
        }

        @NotNull
        public final Index getVIX3M() {
            return new Index("VIX3M", null, 2, null);
        }

        @NotNull
        public final Index getVVIX() {
            return new Index("VVIX", null, 2, null);
        }

        @NotNull
        public final Index getPCCI() {
            return new Index("PCUSINXR", null, 2, null);
        }

        @NotNull
        public final Index getPCCE() {
            return new Index("PCUSEQETR", null, 2, null);
        }

        @NotNull
        public final Index getDJX() {
            return new Index("DJX", null, 2, null);
        }

        @NotNull
        public final KSerializer<Index> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

