/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.XBigNumAsDoubleSerializer;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.ContractManager;
import com.xorrus.trading.common.contract.ContractVisitor;
import com.xorrus.trading.common.contract.Future;
import com.xorrus.trading.common.contract.IContractManager;
import com.xorrus.trading.common.contract.Index;
import com.xorrus.trading.common.contract.Option$;
import com.xorrus.trading.common.contract.OptionChainDef;
import com.xorrus.trading.common.contract.PriceWithGreeks;
import com.xorrus.trading.common.contract.Right;
import com.xorrus.trading.common.contract.Stock;
import com.xorrus.trading.common.contract.Underlying;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.serializers.LocalDateSerializer;
import kotlinx.serialization.Contextual;
import kotlinx.serialization.ContextualSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="Option")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 G2\u00020\u0001:\u0002GHB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB!\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0010B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0011BM\b\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\f\u0010\u0016J\u000e\u0010%\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010&J\u001c\u0010'\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*H\u0086@\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020*J\u0006\u0010-\u001a\u00020\u000fJ!\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0016\u00a2\u0006\u0002\u00102J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\t\u00106\u001a\u00020\tH\u00c6\u0003J\t\u00107\u001a\u00020\u000bH\u00c6\u0003J=\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020\u0013H\u00d6\u0001J\t\u0010>\u001a\u00020\u0005H\u00d6\u0001J%\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0001\u00a2\u0006\u0002\bFR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001a\u00a8\u0006I"}, d2={"Lcom/xorrus/trading/common/contract/Option;", "Lcom/xorrus/trading/common/contract/Contract;", "underlying", "Lcom/xorrus/trading/common/contract/Underlying;", "tradingClass", "", "expiration", "Lkotlinx/datetime/LocalDate;", "strike", "Lcom/xorrus/trading/common/bignum/XBigNum;", "right", "Lcom/xorrus/trading/common/contract/Right;", "<init>", "(Lcom/xorrus/trading/common/contract/Underlying;Ljava/lang/String;Lkotlinx/datetime/LocalDate;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/contract/Right;)V", "chainDef", "Lcom/xorrus/trading/common/contract/OptionChainDef;", "(Lcom/xorrus/trading/common/contract/OptionChainDef;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/contract/Right;)V", "(Lcom/xorrus/trading/common/contract/Underlying;Lkotlinx/datetime/LocalDate;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/contract/Right;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/xorrus/trading/common/contract/Underlying;Ljava/lang/String;Lkotlinx/datetime/LocalDate;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/contract/Right;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getUnderlying", "()Lcom/xorrus/trading/common/contract/Underlying;", "getTradingClass", "()Ljava/lang/String;", "getExpiration", "()Lkotlinx/datetime/LocalDate;", "getStrike$annotations", "()V", "getStrike", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getRight", "()Lcom/xorrus/trading/common/contract/Right;", "symbol", "getSymbol", "getMultiplier", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPriceWithGreek", "Lcom/xorrus/trading/common/contract/PriceWithGreeks;", "timestamp", "Lkotlin/time/Instant;", "(Lkotlin/time/Instant;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getExpirationTimestamp", "toOptionChainDef", "visit", "RESULT", "visitor", "Lcom/xorrus/trading/common/contract/ContractVisitor;", "(Lcom/xorrus/trading/common/contract/ContractVisitor;)Ljava/lang/Object;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$common_trading_common", "Companion", "$serializer", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Option.kt\ncom/xorrus/trading/common/contract/Option\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class Option
extends Contract {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Underlying underlying;
    @Nullable
    private final String tradingClass;
    @NotNull
    private final LocalDate expiration;
    @NotNull
    private final XBigNum strike;
    @NotNull
    private final Right right;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public Option(@NotNull Underlying underlying, @Nullable String tradingClass, @NotNull LocalDate expiration, @NotNull XBigNum strike, @NotNull Right right) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
        Intrinsics.checkNotNullParameter((Object)strike, (String)"strike");
        Intrinsics.checkNotNullParameter((Object)((Object)right), (String)"right");
        super(null);
        this.underlying = underlying;
        this.tradingClass = tradingClass;
        this.expiration = expiration;
        this.strike = strike;
        this.right = right;
        if (this.underlying instanceof Future) {
            if (!(this.tradingClass == null)) {
                boolean $i$a$-require-Option$22 = false;
                String $i$a$-require-Option$22 = "Futureoption darf keine Tradeklasse haben, " + this.tradingClass + " wurde aber \u00fcbergeben.";
                throw new IllegalArgumentException($i$a$-require-Option$22.toString());
            }
            v0 = Unit.INSTANCE;
        } else {
            v0 = this.tradingClass;
            if (v0 == null) {
                boolean bl = false;
                String string = "Index-/Stockoptionen m\u00fcssen eine Tradingklasse haben.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @NotNull
    public final Underlying getUnderlying() {
        return this.underlying;
    }

    @Nullable
    public final String getTradingClass() {
        return this.tradingClass;
    }

    @NotNull
    public final LocalDate getExpiration() {
        return this.expiration;
    }

    @NotNull
    public final XBigNum getStrike() {
        return this.strike;
    }

    @Contextual
    public static /* synthetic */ void getStrike$annotations() {
    }

    @NotNull
    public final Right getRight() {
        return this.right;
    }

    public Option(@NotNull OptionChainDef chainDef, @NotNull XBigNum strike, @NotNull Right right) {
        Intrinsics.checkNotNullParameter((Object)chainDef, (String)"chainDef");
        Intrinsics.checkNotNullParameter((Object)strike, (String)"strike");
        Intrinsics.checkNotNullParameter((Object)((Object)right), (String)"right");
        this(chainDef.getUnderlying(), chainDef.getTradingClass(), chainDef.getExpiration(), strike, right);
    }

    public Option(@NotNull Underlying underlying, @NotNull LocalDate expiration, @NotNull XBigNum strike, @NotNull Right right) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
        Intrinsics.checkNotNullParameter((Object)strike, (String)"strike");
        Intrinsics.checkNotNullParameter((Object)((Object)right), (String)"right");
        this(underlying, underlying instanceof Future ? null : underlying.getTickerSymbol(), expiration, strike, right);
    }

    @Override
    @NotNull
    public String getSymbol() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_symbol__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_symbol__u24lambda_u240.append(this.underlying.getSymbol());
        if (!(this.underlying instanceof Future) && !Intrinsics.areEqual((Object)this.tradingClass, (Object)this.underlying.getTickerSymbol())) {
            $this$_get_symbol__u24lambda_u240.append("/");
            $this$_get_symbol__u24lambda_u240.append(this.tradingClass);
        }
        $this$_get_symbol__u24lambda_u240.append(" OPT ");
        $this$_get_symbol__u24lambda_u240.append(this.expiration.toString()).append(" ");
        String string = this.right.name().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        $this$_get_symbol__u24lambda_u240.append(StringsKt.first((CharSequence)string)).append(" ");
        $this$_get_symbol__u24lambda_u240.append(this.strike.toMinScale());
        return stringBuilder.toString();
    }

    @Nullable
    public final Object getMultiplier(@NotNull Continuation<? super XBigNum> $completion) {
        return ContractManager.INSTANCE.getOptionMultiplier(this, $completion);
    }

    @Nullable
    public final Object getPriceWithGreek(@Nullable Instant timestamp, @NotNull Continuation<? super PriceWithGreeks> $completion) {
        return IContractManager.getPriceWithGreeks-exY8QGI$default(ContractManager.INSTANCE, this, timestamp, 0L, $completion, 4, null);
    }

    public static /* synthetic */ Object getPriceWithGreek$default(Option option, Instant instant, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            instant = null;
        }
        return option.getPriceWithGreek(instant, (Continuation<? super PriceWithGreeks>)continuation);
    }

    @NotNull
    public final Instant getExpirationTimestamp() {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final OptionChainDef toOptionChainDef() {
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    public <RESULT> RESULT visit(@NotNull ContractVisitor<RESULT> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return visitor.visit(this);
    }

    @NotNull
    public final Underlying component1() {
        return this.underlying;
    }

    @Nullable
    public final String component2() {
        return this.tradingClass;
    }

    @NotNull
    public final LocalDate component3() {
        return this.expiration;
    }

    @NotNull
    public final XBigNum component4() {
        return this.strike;
    }

    @NotNull
    public final Right component5() {
        return this.right;
    }

    @NotNull
    public final Option copy(@NotNull Underlying underlying, @Nullable String tradingClass, @NotNull LocalDate expiration, @NotNull XBigNum strike, @NotNull Right right) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
        Intrinsics.checkNotNullParameter((Object)strike, (String)"strike");
        Intrinsics.checkNotNullParameter((Object)((Object)right), (String)"right");
        return new Option(underlying, tradingClass, expiration, strike, right);
    }

    public static /* synthetic */ Option copy$default(Option option, Underlying underlying, String string, LocalDate localDate, XBigNum xBigNum, Right right, int n, Object object) {
        if ((n & 1) != 0) {
            underlying = option.underlying;
        }
        if ((n & 2) != 0) {
            string = option.tradingClass;
        }
        if ((n & 4) != 0) {
            localDate = option.expiration;
        }
        if ((n & 8) != 0) {
            xBigNum = option.strike;
        }
        if ((n & 0x10) != 0) {
            right = option.right;
        }
        return option.copy(underlying, string, localDate, xBigNum, right);
    }

    @NotNull
    public String toString() {
        return "Option(underlying=" + this.underlying + ", tradingClass=" + this.tradingClass + ", expiration=" + this.expiration + ", strike=" + this.strike + ", right=" + this.right + ")";
    }

    public int hashCode() {
        int result = this.underlying.hashCode();
        result = result * 31 + (this.tradingClass == null ? 0 : this.tradingClass.hashCode());
        result = result * 31 + this.expiration.hashCode();
        result = result * 31 + this.strike.hashCode();
        result = result * 31 + this.right.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Option)) {
            return false;
        }
        Option option = (Option)other;
        if (!Intrinsics.areEqual((Object)this.underlying, (Object)option.underlying)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tradingClass, (Object)option.tradingClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expiration, (Object)option.expiration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.strike, (Object)option.strike)) {
            return false;
        }
        return this.right == option.right;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$common_trading_common(Option self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Contract.write$Self(self, output, serialDesc);
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), (Object)self.underlying);
        output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.tradingClass);
        output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)LocalDateSerializer.INSTANCE, (Object)self.expiration);
        output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)lazyArray[3].getValue(), (Object)self.strike);
        output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)lazyArray[4].getValue(), (Object)self.right);
    }

    public /* synthetic */ Option(int seen0, Underlying underlying, String tradingClass, LocalDate expiration, XBigNum strike, Right right, SerializationConstructorMarker serializationConstructorMarker) {
        if (31 != (0x1F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, serializationConstructorMarker);
        this.underlying = underlying;
        this.tradingClass = tradingClass;
        this.expiration = expiration;
        this.strike = strike;
        this.right = right;
        if (this.underlying instanceof Future) {
            if (!(this.tradingClass == null)) {
                boolean $i$a$-require-Option$22 = false;
                String $i$a$-require-Option$22 = "Futureoption darf keine Tradeklasse haben, " + this.tradingClass + " wurde aber \u00fcbergeben.";
                throw new IllegalArgumentException($i$a$-require-Option$22.toString());
            }
            v0 = Unit.INSTANCE;
        } else {
            v0 = this.tradingClass;
            if (v0 == null) {
                boolean bl = false;
                String string = "Index-/Stockoptionen m\u00fcssen eine Tradingklasse haben.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Underlying.Companion.serializer()), null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ContextualSerializer(Reflection.getOrCreateKotlinClass(XBigNum.class), (KSerializer)XBigNumAsDoubleSerializer.INSTANCE, new KSerializer[0])), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.xorrus.trading.common.contract.Right", (Enum[])Right.values()))};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a8\u0006\r"}, d2={"Lcom/xorrus/trading/common/contract/Option$Companion;", "", "<init>", "()V", "fromSymbol", "Lcom/xorrus/trading/common/contract/Option;", "symbol", "", "parseStockOption", "parseIndexOption", "parseFutureOption", "serializer", "Lkotlinx/serialization/KSerializer;", "common-trading-common"})
    @SourceDebugExtension(value={"SMAP\nOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Option.kt\ncom/xorrus/trading/common/contract/Option$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Option fromSymbol(@NotNull String symbol) {
            Option option;
            Character c;
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Character c2 = c = StringsKt.firstOrNull((CharSequence)symbol);
            char c3 = '@';
            if (c2 != null && c2.charValue() == c3) {
                option = this.parseIndexOption(symbol);
            } else {
                Character c4 = c;
                c3 = '/';
                option = c4 != null && c4.charValue() == c3 ? this.parseFutureOption(symbol) : this.parseStockOption(symbol);
            }
            return option;
        }

        private final Option parseStockOption(String symbol) {
            XBigNum strike;
            Right right;
            String r;
            String tradingClass;
            String currency;
            Regex stockOptionSymbolRegEx = new Regex("^" + StringsKt.removeSuffix((String)Stock.Companion.getStockSymbolRegEx$common_trading_common().getPattern(), (CharSequence)"$") + "(?:/(?<tradingClass>[^\\s]+))? OPT (?<expiration>\\d{4}-\\d{2}-\\d{2}) (?<right>[CP]) (?<strike>\\d+(?:\\.\\d+)?)$");
            MatchResult matchResult = stockOptionSymbolRegEx.matchEntire((CharSequence)symbol);
            if (matchResult == null) {
                throw new IllegalStateException("symbol does not match pattern".toString());
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"tickerSymbol");
            Intrinsics.checkNotNull((Object)matchGroup);
            String string = matchGroup.getValue().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String tickerSymbol = string;
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"currency");
            if (object != null && (object = object.getValue()) != null) {
                String string2 = ((String)object).toUpperCase(Locale.ROOT);
                v5 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            } else {
                v5 = currency = null;
            }
            if (!(!Intrinsics.areEqual((Object)currency, (Object)"USD"))) {
                boolean $i$a$-require-Option$Companion$parseStockOption$32 = false;
                String $i$a$-require-Option$Companion$parseStockOption$32 = "currency must not be USD otherwise it should be omitted";
                throw new IllegalArgumentException($i$a$-require-Option$Companion$parseStockOption$32.toString());
            }
            Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"tradingClass");
            if (object2 != null && (object2 = object2.getValue()) != null) {
                String string3 = ((String)object2).toUpperCase(Locale.ROOT);
                v8 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            } else {
                v8 = tradingClass = null;
            }
            if (!(!Intrinsics.areEqual((Object)tradingClass, (Object)tickerSymbol))) {
                boolean $i$a$-require-Option$Companion$parseStockOption$42 = false;
                String $i$a$-require-Option$Companion$parseStockOption$42 = "trading class must differ from underlying symbol otherwise it should be omitted";
                throw new IllegalArgumentException($i$a$-require-Option$Companion$parseStockOption$42.toString());
            }
            Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"expiration");
            LocalDate expiration = object3 != null && (object3 = object3.getValue()) != null ? DateKt.toLocalDate$default((String)object3, "yyyy-MM-dd", null, 2, null) : null;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"right");
            String string4 = r = matchGroup2 != null ? matchGroup2.getValue() : null;
            if (Intrinsics.areEqual((Object)r, (Object)"P")) {
                right = Right.PUT;
            } else if (Intrinsics.areEqual((Object)r, (Object)"C")) {
                right = Right.CALL;
            } else {
                throw new IllegalStateException(("invalid right: " + r).toString());
            }
            Right right2 = right;
            Object object4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"strike");
            XBigNum xBigNum = strike = object4 != null && (object4 = object4.getValue()) != null ? XbignumKt.toXBigNum((String)object4) : null;
            String string5 = currency;
            if (string5 == null) {
                string5 = "USD";
            }
            Stock stock = new Stock(tickerSymbol, string5);
            Underlying underlying = stock;
            String string6 = tradingClass;
            if (string6 == null) {
                string6 = tickerSymbol;
            }
            LocalDate localDate = expiration;
            Intrinsics.checkNotNull((Object)localDate);
            XBigNum xBigNum2 = strike;
            Intrinsics.checkNotNull((Object)xBigNum2);
            return new Option(underlying, string6, localDate, xBigNum2, right2);
        }

        private final Option parseIndexOption(String symbol) {
            XBigNum strike;
            Right right;
            String r;
            String string;
            Object object;
            String currency;
            Regex indexOptionRegex = new Regex("^" + StringsKt.removeSuffix((String)Index.Companion.getIndexSymbolRegEx$common_trading_common().getPattern(), (CharSequence)"$") + "(?:/(?<tradingClass>[A-Z]+))? OPT\\s+(?<expiration>\\d{4}-\\d{2}-\\d{2}) (?<right>[CP]) (?<strike>\\d+(\\.\\d+)?)$");
            MatchResult matchResult = indexOptionRegex.matchEntire((CharSequence)symbol);
            if (matchResult == null) {
                throw new IllegalStateException("symbol does not match pattern".toString());
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"tickerSymbol");
            Intrinsics.checkNotNull((Object)matchGroup);
            String string2 = matchGroup.getValue().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            String tickerSymbol = string2;
            Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"currency");
            if (object2 != null && (object2 = object2.getValue()) != null) {
                String string3 = ((String)object2).toUpperCase(Locale.ROOT);
                v5 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            } else {
                v5 = currency = null;
            }
            if ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"tradingClass")) != null && (object = object.getValue()) != null) {
                String string4 = ((String)object).toUpperCase(Locale.ROOT);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            } else {
                string = null;
            }
            String tradingClass = string;
            Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"expiration");
            LocalDate expiration = object3 != null && (object3 = object3.getValue()) != null ? DateKt.toLocalDate$default((String)object3, "yyyy-MM-dd", null, 2, null) : null;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"right");
            String string5 = r = matchGroup2 != null ? matchGroup2.getValue() : null;
            if (Intrinsics.areEqual((Object)r, (Object)"P")) {
                right = Right.PUT;
            } else if (Intrinsics.areEqual((Object)r, (Object)"C")) {
                right = Right.CALL;
            } else {
                throw new IllegalStateException(("invalid right: " + r).toString());
            }
            Right right2 = right;
            Object object4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"strike");
            XBigNum xBigNum = strike = object4 != null && (object4 = object4.getValue()) != null ? XbignumKt.toXBigNum((String)object4) : null;
            if (!(!Intrinsics.areEqual((Object)tradingClass, (Object)tickerSymbol))) {
                boolean $i$a$-require-Option$Companion$parseIndexOption$32 = false;
                String $i$a$-require-Option$Companion$parseIndexOption$32 = "trading class must differ from underlying symbol otherwise it should be omitted";
                throw new IllegalArgumentException($i$a$-require-Option$Companion$parseIndexOption$32.toString());
            }
            if (!(!Intrinsics.areEqual((Object)currency, (Object)"USD"))) {
                boolean bl = false;
                String string6 = "currency must not be USD otherwise it should be omitted";
                throw new IllegalArgumentException(string6.toString());
            }
            String string7 = currency;
            if (string7 == null) {
                string7 = "USD";
            }
            Index index = new Index(tickerSymbol, string7);
            Underlying underlying = index;
            String string8 = tradingClass;
            if (string8 == null) {
                string8 = tickerSymbol;
            }
            LocalDate localDate = expiration;
            Intrinsics.checkNotNull((Object)localDate);
            XBigNum xBigNum2 = strike;
            Intrinsics.checkNotNull((Object)xBigNum2);
            return new Option(underlying, string8, localDate, xBigNum2, right2);
        }

        private final Option parseFutureOption(String symbol) {
            Right right;
            String r;
            Regex futureOptionRegex = new Regex("^" + StringsKt.removeSuffix((String)Future.Companion.getFutureSymbolRegEx$common_trading_common().getPattern(), (CharSequence)"$") + " OPT\\s+(?<expiration>\\d{4}-\\d{2}-\\d{2}) (?<right>[CP]) (?<strike>\\d+(\\.\\d+)?)$");
            MatchResult matchResult = futureOptionRegex.matchEntire((CharSequence)symbol);
            if (matchResult == null) {
                throw new IllegalStateException("symbol does not match pattern".toString());
            }
            MatchResult matchResult2 = matchResult;
            int futureSymbolEnd = StringsKt.indexOf$default((CharSequence)symbol, (String)" OPT ", (int)0, (boolean)false, (int)6, null);
            if (futureSymbolEnd == -1) {
                throw new IllegalStateException("Invalid future option symbol format".toString());
            }
            String string = symbol.substring(0, futureSymbolEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String futureSymbol = string;
            Future future = Future.Companion.fromSymbol(futureSymbol);
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"expiration");
            LocalDate expiration = object != null && (object = object.getValue()) != null ? DateKt.toLocalDate$default((String)object, "yyyy-MM-dd", null, 2, null) : null;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"right");
            String string2 = r = matchGroup != null ? matchGroup.getValue() : null;
            if (Intrinsics.areEqual((Object)r, (Object)"P")) {
                right = Right.PUT;
            } else if (Intrinsics.areEqual((Object)r, (Object)"C")) {
                right = Right.CALL;
            } else {
                throw new IllegalStateException(("invalid right: " + r).toString());
            }
            Right right2 = right;
            Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"strike");
            XBigNum strike = object2 != null && (object2 = object2.getValue()) != null ? XbignumKt.toXBigNum((String)object2) : null;
            Underlying underlying = future;
            LocalDate localDate = expiration;
            Intrinsics.checkNotNull((Object)localDate);
            XBigNum xBigNum = strike;
            Intrinsics.checkNotNull((Object)xBigNum);
            return new Option(underlying, localDate, xBigNum, right2);
        }

        @NotNull
        public final KSerializer<Option> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

