/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract;

import com.xorrus.trading.common.contract.ExchangeAsStringSerializer;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=ExchangeAsStringSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0011\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/xorrus/trading/common/contract/Exchange;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "compareTo", "Companion", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchange.kt\ncom/xorrus/trading/common/contract/Exchange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class Exchange
implements Comparable<Exchange> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;

    public Exchange(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        String string = this.name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)this.name, (Object)string)) {
            boolean bl = false;
            String string2 = "Exchange must be uppercase";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return object instanceof Exchange ? Intrinsics.areEqual((Object)this.name, (Object)((Exchange)other).name) : (object instanceof String ? Intrinsics.areEqual((Object)this.name, (Object)other) : false);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(@NotNull Exchange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.name.compareTo(other.name);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/xorrus/trading/common/contract/Exchange$Companion;", "", "<init>", "()V", "AMEX", "Lcom/xorrus/trading/common/contract/Exchange;", "getAMEX", "()Lcom/xorrus/trading/common/contract/Exchange;", "EUREX", "getEUREX", "CBOE", "getCBOE", "CBOT", "getCBOT", "CME", "getCME", "COMEX", "getCOMEX", "CEDX", "getCEDX", "ICEEU", "getICEEU", "NYBOT", "getNYBOT", "NYMEX", "getNYMEX", "MONEP", "getMONEP", "SMART", "getSMART", "serializer", "Lkotlinx/serialization/KSerializer;", "common-trading-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Exchange getAMEX() {
            return new Exchange("AMEX");
        }

        @NotNull
        public final Exchange getEUREX() {
            return new Exchange("EUREX");
        }

        @NotNull
        public final Exchange getCBOE() {
            return new Exchange("CBOE");
        }

        @NotNull
        public final Exchange getCBOT() {
            return new Exchange("CBOT");
        }

        @NotNull
        public final Exchange getCME() {
            return new Exchange("CME");
        }

        @NotNull
        public final Exchange getCOMEX() {
            return new Exchange("COMEX");
        }

        @NotNull
        public final Exchange getCEDX() {
            return new Exchange("CEDX");
        }

        @NotNull
        public final Exchange getICEEU() {
            return new Exchange("ICEEU");
        }

        @NotNull
        public final Exchange getNYBOT() {
            return new Exchange("NYBOT");
        }

        @NotNull
        public final Exchange getNYMEX() {
            return new Exchange("NYMEX");
        }

        @NotNull
        public final Exchange getMONEP() {
            return new Exchange("MONEP");
        }

        @NotNull
        public final Exchange getSMART() {
            return new Exchange("SMART");
        }

        @NotNull
        public final KSerializer<Exchange> serializer() {
            return ExchangeAsStringSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

