/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.bignum;

import com.xorrus.trading.common.BignumKt;
import com.xorrus.trading.common.XBigNumAsDoubleSerializer;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XClosedBigNumRange;
import korlibs.bignumber.BigInt;
import korlibs.bignumber.BigIntKt;
import korlibs.bignumber.BigNum;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=XBigNumAsDoubleSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u000f\b\u0087\b\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000fJ\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0016H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0016H\u0086\u0002J\t\u0010\u0018\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0019\u001a\u00020\u0000J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tH\u0086\u0004J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tJ\u0011\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0010\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\"\u001a\u00020\u0000J\u0010\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\"\u001a\u00020\u0000J\u0010\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\"\u001a\u00020\u0000J\b\u0010%\u001a\u00020\fH\u0016J\b\u0010&\u001a\u00020\tH\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010\u0013\u001a\u0004\u0018\u00010)H\u0096\u0002J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\tJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\tJ\u0006\u0010.\u001a\u00020\u0000J\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\tJ\u0006\u00101\u001a\u00020(J\u0006\u00102\u001a\u00020\u0000J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\u0013\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00068"}, d2={"Lcom/xorrus/trading/common/bignum/XBigNum;", "", "value", "Lkorlibs/bignumber/BigNum;", "<init>", "(Lkorlibs/bignumber/BigNum;)V", "int", "Lkorlibs/bignumber/BigInt;", "scale", "", "(Lkorlibs/bignumber/BigInt;I)V", "str", "", "(Ljava/lang/String;)V", "n", "(I)V", "getValue", "()Lkorlibs/bignumber/BigNum;", "plus", "other", "minus", "times", "", "div", "unaryMinus", "abs", "pow", "exponent", "precision", "compareTo", "rangeTo", "Lcom/xorrus/trading/common/bignum/XClosedBigNumRange;", "that", "round", "step", "ceil", "floor", "toString", "hashCode", "equals", "", "", "convertToScale", "otherScale", "increaseScale", "decreaseScale", "truncate", "fractionalPart", "toInt", "isGanzzahlig", "toMinScale", "getScale", "()I", "component1", "copy", "Companion", "common-trading-common"})
public final class XBigNum
implements Comparable<XBigNum> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigNum value;
    @NotNull
    private static final XBigNum MINUS_ONE = new XBigNum(new BigNum(BigIntKt.BigInt((int)-1), 0));
    @NotNull
    private static final XBigNum ZERO = new XBigNum(BigNum.Companion.getZERO());
    @NotNull
    private static final XBigNum ONE = new XBigNum(BigNum.Companion.getONE());
    @NotNull
    private static final XBigNum TWO = new XBigNum(BigNum.Companion.getTWO());

    public XBigNum(@NotNull BigNum value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final BigNum getValue() {
        return this.value;
    }

    public XBigNum(@NotNull BigInt bigInt, int scale) {
        Intrinsics.checkNotNullParameter((Object)bigInt, (String)"int");
        this(new BigNum(bigInt, scale));
    }

    public XBigNum(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(((Companion)XBigNum.Companion).parse((String)str).value);
    }

    public XBigNum(int n) {
        this(BigIntKt.BigInt((int)n), 0);
    }

    @NotNull
    public final XBigNum plus(@NotNull XBigNum other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new XBigNum(this.value.plus(other.value));
    }

    @NotNull
    public final XBigNum minus(@NotNull XBigNum other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new XBigNum(this.value.minus(other.value));
    }

    @NotNull
    public final XBigNum times(@NotNull XBigNum other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new XBigNum(this.value.times(other.value));
    }

    @NotNull
    public final XBigNum times(int other) {
        return this.times(XbignumKt.toXBigNum$default(other, 0, 1, null));
    }

    @NotNull
    public final XBigNum times(double other) {
        return this.times(XbignumKt.toXBigNum$default(other, null, 1, null));
    }

    @NotNull
    public final XBigNum div(@NotNull XBigNum other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new XBigNum(this.value.div(other.value, 20)).toMinScale();
    }

    @NotNull
    public final XBigNum div(int other) {
        return this.div(XbignumKt.toXBigNum$default(other, 0, 1, null));
    }

    @NotNull
    public final XBigNum div(double other) {
        return this.div(XbignumKt.toXBigNum$default(other, null, 1, null));
    }

    @NotNull
    public final XBigNum unaryMinus() {
        return ZERO.minus(this);
    }

    @NotNull
    public final XBigNum abs() {
        return this.compareTo(ZERO) > 0 ? this : this.unaryMinus();
    }

    @NotNull
    public final XBigNum pow(int exponent) {
        return this.pow(exponent, 32);
    }

    @NotNull
    public final XBigNum pow(int exponent, int precision) {
        return new XBigNum(this.value.pow(exponent, precision));
    }

    @Override
    public int compareTo(@NotNull XBigNum other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other.value);
    }

    @NotNull
    public final XClosedBigNumRange rangeTo(@NotNull XBigNum that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return new XClosedBigNumRange(this, that);
    }

    @NotNull
    public final XBigNum round(@NotNull XBigNum step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        XBigNum floored = this.floor(step);
        XBigNum distanceToFloor = this.minus(floored);
        return distanceToFloor.plus(distanceToFloor).compareTo(step) <= 0 ? floored : floored.plus(step);
    }

    public static /* synthetic */ XBigNum round$default(XBigNum xBigNum, XBigNum xBigNum2, int n, Object object) {
        if ((n & 1) != 0) {
            xBigNum2 = ONE;
        }
        return xBigNum.round(xBigNum2);
    }

    @NotNull
    public final XBigNum ceil(@NotNull XBigNum step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        XBigNum floored = this.floor(step);
        return Intrinsics.areEqual((Object)this, (Object)floored) ? this : floored.plus(step);
    }

    public static /* synthetic */ XBigNum ceil$default(XBigNum xBigNum, XBigNum xBigNum2, int n, Object object) {
        if ((n & 1) != 0) {
            xBigNum2 = ONE;
        }
        return xBigNum.ceil(xBigNum2);
    }

    @NotNull
    public final XBigNum floor(@NotNull XBigNum step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        return this.div(step).truncate().times(step);
    }

    public static /* synthetic */ XBigNum floor$default(XBigNum xBigNum, XBigNum xBigNum2, int n, Object object) {
        if ((n & 1) != 0) {
            xBigNum2 = ONE;
        }
        return xBigNum.floor(xBigNum2);
    }

    @NotNull
    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.toMinScale().value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof XBigNum) {
            return Intrinsics.areEqual((Object)this.value, (Object)((XBigNum)other).value);
        }
        if (other instanceof BigNum) {
            System.out.println((Object)"Warning: comparing XBigNum with BigNum");
            return Intrinsics.areEqual((Object)this.value, (Object)other);
        }
        return false;
    }

    @NotNull
    public final XBigNum convertToScale(int otherScale) {
        return new XBigNum(this.value.convertToScale(otherScale));
    }

    @NotNull
    public final XBigNum increaseScale(int step) {
        return this.convertToScale(this.value.getScale() + step);
    }

    @NotNull
    public final XBigNum decreaseScale(int step) {
        return this.convertToScale(this.value.getScale() - step);
    }

    @NotNull
    public final XBigNum truncate() {
        return this.convertToScale(0);
    }

    @NotNull
    public final XBigNum fractionalPart() {
        return this.minus(this.truncate());
    }

    public final int toInt() {
        return this.value.toBigInt().toInt();
    }

    public final boolean isGanzzahlig() {
        return Intrinsics.areEqual((Object)this.fractionalPart(), (Object)ZERO);
    }

    @NotNull
    public final XBigNum toMinScale() {
        BigNum x = this.value;
        while (x.getScale() > 0 && Intrinsics.areEqual((Object)x.getDecimalPart().rem(BignumKt.toBigInt("10")), (Object)BignumKt.toBigInt("0"))) {
            x = x.convertToScale(x.getScale() - 1);
        }
        return new XBigNum(x);
    }

    public final int getScale() {
        return this.value.getScale();
    }

    @NotNull
    public final BigNum component1() {
        return this.value;
    }

    @NotNull
    public final XBigNum copy(@NotNull BigNum value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new XBigNum(value);
    }

    public static /* synthetic */ XBigNum copy$default(XBigNum xBigNum, BigNum bigNum, int n, Object object) {
        if ((n & 1) != 0) {
            bigNum = xBigNum.value;
        }
        return xBigNum.copy(bigNum);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/xorrus/trading/common/bignum/XBigNum$Companion;", "", "<init>", "()V", "MINUS_ONE", "Lcom/xorrus/trading/common/bignum/XBigNum;", "getMINUS_ONE", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "ZERO", "getZERO", "ONE", "getONE", "TWO", "getTWO", "parse", "str", "", "serializer", "Lkotlinx/serialization/KSerializer;", "common-trading-common"})
    @SourceDebugExtension(value={"SMAP\nXBigNum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XBigNum.kt\ncom/xorrus/trading/common/bignum/XBigNum$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XBigNum getMINUS_ONE() {
            return MINUS_ONE;
        }

        @NotNull
        public final XBigNum getZERO() {
            return ZERO;
        }

        @NotNull
        public final XBigNum getONE() {
            return ONE;
        }

        @NotNull
        public final XBigNum getTWO() {
            return TWO;
        }

        private final XBigNum parse(String str) {
            char ch;
            char c;
            int k;
            int i;
            int n = str.length();
            int j = n - 1;
            for (i = 0; i <= j && CharsKt.isWhitespace((char)str.charAt(i)); ++i) {
            }
            while (j >= i && CharsKt.isWhitespace((char)str.charAt(j))) {
                --j;
            }
            if (!(i <= j)) {
                boolean $i$a$-require-XBigNum$Companion$parse$92 = false;
                String $i$a$-require-XBigNum$Companion$parse$92 = "Empty numeric literal";
                throw new IllegalArgumentException($i$a$-require-XBigNum$Companion$parse$92.toString());
            }
            boolean negative = false;
            char c0 = str.charAt(i);
            switch (c0) {
                case '+': 
                case '-': {
                    negative = c0 == '-';
                    if (++i <= j) break;
                    boolean $i$a$-require-XBigNum$Companion$parse$102 = false;
                    String $i$a$-require-XBigNum$Companion$parse$102 = "Invalid number: " + str;
                    throw new IllegalArgumentException($i$a$-require-XBigNum$Companion$parse$102.toString());
                }
            }
            StringBuilder digits = new StringBuilder(RangesKt.coerceAtLeast((int)(j - i + 1), (int)0));
            boolean seenDot = false;
            int fracLen = 0;
            boolean seenDigit = false;
            boolean nonZeroDigit = false;
            for (k = i; k <= j && (c = (ch = str.charAt(k))) != 'e' && c != 'E'; ++k) {
                if (c == '_') continue;
                if (c == '.') {
                    if (!(!seenDot)) {
                        boolean $i$a$-require-XBigNum$Companion$parse$112 = false;
                        String $i$a$-require-XBigNum$Companion$parse$112 = "Multiple decimal points: " + str;
                        throw new IllegalArgumentException($i$a$-require-XBigNum$Companion$parse$112.toString());
                    }
                    seenDot = true;
                    continue;
                }
                boolean bl = '0' <= c ? c < ':' : false;
                if (bl) {
                    digits.append(ch);
                    seenDigit = true;
                    if (ch != '0') {
                        nonZeroDigit = true;
                    }
                    if (!seenDot) continue;
                    ++fracLen;
                    continue;
                }
                throw new IllegalArgumentException("Invalid character '" + ch + "' in: " + str);
            }
            if (!seenDigit) {
                boolean $i$a$-require-XBigNum$Companion$parse$122 = false;
                String $i$a$-require-XBigNum$Companion$parse$122 = "Invalid number: " + str;
                throw new IllegalArgumentException($i$a$-require-XBigNum$Companion$parse$122.toString());
            }
            if (!(((CharSequence)digits).length() > 0)) {
                boolean $i$a$-require-XBigNum$Companion$parse$132 = false;
                String $i$a$-require-XBigNum$Companion$parse$132 = "Invalid digits in: " + str;
                throw new IllegalArgumentException($i$a$-require-XBigNum$Companion$parse$132.toString());
            }
            int exponent = 0;
            if (k <= j && (str.charAt(k) == 'e' || str.charAt(k) == 'E')) {
                if (!(++k <= j)) {
                    boolean $i$a$-require-XBigNum$Companion$parse$142 = false;
                    String $i$a$-require-XBigNum$Companion$parse$142 = "Invalid exponent in: " + str;
                    throw new IllegalArgumentException($i$a$-require-XBigNum$Companion$parse$142.toString());
                }
                boolean expNeg = false;
                char signCh = str.charAt(k);
                switch (signCh) {
                    case '+': 
                    case '-': {
                        expNeg = signCh == '-';
                        if (++k <= j) break;
                        boolean $i$a$-require-XBigNum$Companion$parse$152 = false;
                        String $i$a$-require-XBigNum$Companion$parse$152 = "Invalid exponent in: " + str;
                        throw new IllegalArgumentException($i$a$-require-XBigNum$Companion$parse$152.toString());
                    }
                }
                boolean seenExpDigit = false;
                while (k <= j) {
                    char ch2 = str.charAt(k);
                    if (ch2 != '_') {
                        boolean bl = '0' <= ch2 ? ch2 < ':' : false;
                        if (bl) {
                            seenExpDigit = true;
                            int d = ch2 - 48;
                            if (exponent > 0xCCCCCCC || exponent == 0xCCCCCCC && d > 7) {
                                throw new IllegalArgumentException("Exponent overflow: " + str);
                            }
                            exponent = exponent * 10 + d;
                        } else {
                            throw new IllegalArgumentException("Invalid exponent character '" + ch2 + "' in: " + str);
                        }
                    }
                    ++k;
                }
                if (!seenExpDigit) {
                    boolean bl = false;
                    String string = "Invalid exponent in: " + str;
                    throw new IllegalArgumentException(string.toString());
                }
                if (expNeg) {
                    exponent = -exponent;
                }
            }
            int scale = fracLen - exponent;
            String string = digits.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            BigInt intPart = BigIntKt.BigInt((String)string);
            if (negative && nonZeroDigit) {
                intPart = intPart.unaryMinus();
            }
            return new XBigNum(new BigNum(intPart, scale));
        }

        @NotNull
        public final KSerializer<XBigNum> serializer() {
            return XBigNumAsDoubleSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

