/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common;

import com.xorrus.trading.common.BlackscholeKt;
import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.common.contract.Right;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bJ\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/xorrus/trading/common/BlackScholes;", "", "zinssatz", "Lcom/xorrus/trading/common/bignum/XBigNum;", "underlyingPrice", "<init>", "(Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getZinssatz", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getUnderlyingPrice", "getPriceAtExpiration", "", "option", "Lcom/xorrus/trading/common/contract/Option;", "getPriceInFuture", "vola", "laufzeit", "optionPriceNow", "future", "Lkotlin/time/Instant;", "getIv", "optionPrice", "restlaufzeit", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nblackschole.kt\nKotlin\n*S Kotlin\n*F\n+ 1 blackschole.kt\ncom/xorrus/trading/common/BlackScholes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,426:1\n1#2:427\n*E\n"})
public final class BlackScholes {
    @NotNull
    private final XBigNum zinssatz;
    @NotNull
    private final XBigNum underlyingPrice;

    public BlackScholes(@NotNull XBigNum zinssatz, @NotNull XBigNum underlyingPrice) {
        Intrinsics.checkNotNullParameter((Object)zinssatz, (String)"zinssatz");
        Intrinsics.checkNotNullParameter((Object)underlyingPrice, (String)"underlyingPrice");
        this.zinssatz = zinssatz;
        this.underlyingPrice = underlyingPrice;
    }

    @NotNull
    public final XBigNum getZinssatz() {
        return this.zinssatz;
    }

    @NotNull
    public final XBigNum getUnderlyingPrice() {
        return this.underlyingPrice;
    }

    public final double getPriceAtExpiration(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return switch (WhenMappings.$EnumSwitchMapping$0[option.getRight().ordinal()]) {
            case 1 -> Math.max(XbignumKt.toDouble(this.underlyingPrice) - XbignumKt.toDouble(option.getStrike()), 0.0);
            case 2 -> Math.max(XbignumKt.toDouble(option.getStrike()) - XbignumKt.toDouble(this.underlyingPrice), 0.0);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final double getPriceInFuture(@NotNull Option option, double vola, double laufzeit) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return switch (WhenMappings.$EnumSwitchMapping$0[option.getRight().ordinal()]) {
            case 1 -> BlackscholeKt.preisCall(XbignumKt.toDouble(this.underlyingPrice), XbignumKt.toDouble(this.zinssatz), vola, laufzeit, XbignumKt.toDouble(option.getStrike()));
            case 2 -> BlackscholeKt.preisPut(XbignumKt.toDouble(this.underlyingPrice), XbignumKt.toDouble(this.zinssatz), vola, laufzeit, XbignumKt.toDouble(option.getStrike()));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final double getPriceInFuture(@NotNull Option option, double optionPriceNow, @NotNull Instant future) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)future, (String)"future");
        double restlaufzeit = BlackscholeKt.yearsBetween(DateKt.now(), future);
        if (!(restlaufzeit >= 0.0)) {
            boolean bl = false;
            String string = "Future in the past: " + future;
            throw new IllegalArgumentException(string.toString());
        }
        double vola = this.getIv(option, optionPriceNow);
        return this.getPriceInFuture(option, vola, restlaufzeit);
    }

    public final double getIv(@NotNull Option option, double optionPrice, double restlaufzeit) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return BlackscholeKt.vola(XbignumKt.toDouble(this.underlyingPrice), XbignumKt.toDouble(option.getStrike()), XbignumKt.toDouble(this.zinssatz), optionPrice, restlaufzeit, option.getRight());
    }

    public final double getIv(@NotNull Option option, double optionPrice) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        double restlaufzeit = BlackscholeKt.yearsBetween(DateKt.now(), option.getExpirationTimestamp());
        return BlackscholeKt.vola(XbignumKt.toDouble(this.underlyingPrice), XbignumKt.toDouble(option.getStrike()), XbignumKt.toDouble(this.zinssatz), optionPrice, restlaufzeit, option.getRight());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Right.values().length];
            try {
                nArray[Right.CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Right.PUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

