/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.classpath;

import io.avaje.classpath.scanner.internal.ScanLog;
import io.avaje.classpath.scanner.internal.UrlUtils;
import io.avaje.classpath.scanner.internal.scanner.classpath.ClassPathLocationScanner;
import java.io.File;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;

public class FileSystemClassPathLocationScanner
implements ClassPathLocationScanner {
    private static final System.Logger log = ScanLog.log;

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) {
        String filePath = UrlUtils.toFilePath(locationUrl);
        File folder = new File(filePath);
        if (!folder.isDirectory()) {
            return new TreeSet<String>();
        }
        Object classPathRootOnDisk = filePath.substring(0, filePath.length() - location.length());
        if (!((String)classPathRootOnDisk).endsWith(File.separator)) {
            classPathRootOnDisk = (String)classPathRootOnDisk + File.separator;
        }
        log.log(System.Logger.Level.TRACE, "scan starting at root in filesystem: {0}", classPathRootOnDisk);
        return this.findResourceNamesFromFileSystem((String)classPathRootOnDisk, location, folder);
    }

    Set<String> findResourceNamesFromFileSystem(String classPathRootOnDisk, String scanRootLocation, File folder) {
        log.log(System.Logger.Level.TRACE, "scan resources in path: {0} ({1})", folder.getPath(), scanRootLocation);
        TreeSet<String> resourceNames = new TreeSet<String>();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.canRead()) continue;
                String resourcePath = this.toResourceNameOnClasspath(classPathRootOnDisk, file);
                if (file.isDirectory()) {
                    if (this.ignorePath(resourcePath)) continue;
                    resourceNames.addAll(this.findResourceNamesFromFileSystem(classPathRootOnDisk, scanRootLocation, file));
                    continue;
                }
                resourceNames.add(resourcePath);
            }
        }
        return resourceNames;
    }

    private boolean ignorePath(String resourcePath) {
        return resourcePath.startsWith("io/avaje/classpath") || resourcePath.startsWith("io/ebean");
    }

    private String toResourceNameOnClasspath(String classPathRootOnDisk, File file) {
        String fileName = file.getAbsolutePath().replace("\\", "/");
        return fileName.substring(classPathRootOnDisk.length());
    }
}

