/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.ConfigurationLog;
import io.avaje.config.CoreEntry;
import io.avaje.config.CoreExpressionEval;
import io.avaje.config.InitialLoader;
import io.avaje.config.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;

final class InitialLoadContext {
    private final ConfigurationLog log;
    private final ResourceLoader resourceLoader;
    private final CoreEntry.CoreMap map = CoreEntry.newMap();
    private final Set<String> loadedResources = new LinkedHashSet<String>();
    private final List<File> loadedFiles = new ArrayList<File>();
    private final CoreExpressionEval exprEval;
    private final Set<String> loadCheck = new HashSet<String>();
    private int recursiveLoadCount;

    InitialLoadContext(ConfigurationLog log, ResourceLoader resourceLoader) {
        this.log = log;
        this.resourceLoader = resourceLoader;
        this.exprEval = new CoreExpressionEval(this.map);
    }

    Set<String> loadedFrom() {
        return this.loadedResources;
    }

    List<File> loadedFiles() {
        return this.loadedFiles;
    }

    String eval(String expression) {
        return this.exprEval.eval(expression);
    }

    void loadEnvironmentVars() {
        String podName = System.getenv("POD_NAME");
        this.initSystemProperty(podName, "app.instanceId");
        this.initSystemProperty(InitialLoadContext.podService(podName), "app.name");
        this.initSystemProperty(System.getenv("POD_NAMESPACE"), "app.environment");
        this.initSystemProperty(System.getenv("POD_VERSION"), "app.version");
        this.initSystemProperty(System.getenv("POD_IP"), "app.ipAddress");
        this.initSystemProperty(System.getenv("CONFIG_PROFILES"), "config.profiles");
        this.initSystemProperty(System.getenv("AVAJE_PROFILES"), "avaje.profiles");
    }

    private void initSystemProperty(String envValue, String key) {
        if (envValue != null && System.getProperty(key) == null) {
            this.map.put(key, envValue, "ENV");
        }
    }

    static String podService(String podName) {
        int p0;
        if (podName != null && podName.length() > 16 && (p0 = podName.lastIndexOf(45, podName.length() - 16)) > -1) {
            return podName.substring(0, p0);
        }
        return null;
    }

    @Nullable InputStream resource(String resourcePath, InitialLoader.Source source) {
        InputStream is = null;
        if (source == InitialLoader.Source.RESOURCE) {
            is = this.resourceStream(resourcePath);
            if (is != null) {
                this.loadedResources.add(source.key(resourcePath));
                this.loadCheck.add(resourcePath);
            }
        } else {
            File file = new File(resourcePath);
            if (file.exists()) {
                try {
                    is = new FileInputStream(file);
                    this.loadedResources.add(source.key(resourcePath));
                    this.loadCheck.add(resourcePath);
                    this.loadedFiles.add(file);
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return is;
    }

    private InputStream resourceStream(String resourcePath) {
        return this.resourceLoader.getResourceAsStream(resourcePath);
    }

    void put(String key, String val, String source) {
        if (val != null) {
            val = val.trim();
        }
        this.map.put(key, val, source);
    }

    CoreEntry.CoreMap entryMap() {
        this.log.log(System.Logger.Level.TRACE, "load from {0}", this.loadedResources);
        return this.map;
    }

    String indirectLocation() {
        String location = System.getProperty("load.properties");
        if (location != null) {
            return location;
        }
        CoreEntry indirectLocation = this.map.get("load.properties");
        if (indirectLocation == null) {
            indirectLocation = this.map.get("load.properties.override");
        }
        return indirectLocation == null ? null : indirectLocation.value();
    }

    String profiles() {
        String configProfile;
        CoreEntry configEntry = this.map.get("config.profiles");
        String string = configProfile = configEntry == null ? System.getProperty("config.profiles") : configEntry.value();
        if (configProfile != null) {
            return configProfile;
        }
        CoreEntry avajeProfile = this.map.get("avaje.profiles");
        return avajeProfile == null ? System.getProperty("avaje.profiles") : avajeProfile.value();
    }

    int size() {
        return this.loadedResources.size();
    }

    String getAppName() {
        CoreEntry appName = this.map.get("app.name");
        return appName != null ? appName.value() : System.getProperty("app.name");
    }

    boolean alreadyLoaded(String fileName) {
        return !this.loadCheck.add(fileName);
    }

    boolean allowRecursiveLoad() {
        if (this.recursiveLoadCount++ > 100) {
            throw new IllegalStateException("Recursive loading exceeded 100. Check your load.properties entries");
        }
        return true;
    }
}

