/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api;

import com.xorrus.trading.ib.tws.api.TwsMissingDelayedDataSubscriptionError;
import com.xorrus.trading.ib.tws.api.TwsMissingLiveDataSubscriptionError;
import com.xorrus.trading.ib.tws.api.TwsNotHistoricalMarketDataError;
import com.xorrus.trading.ib.tws.api.TwsPacingViolationError;
import com.xorrus.trading.ib.tws.api.TwsProcessingClientRequestError;
import com.xorrus.trading.ib.tws.api.TwsRequestError;
import com.xorrus.trading.ib.tws.api.TwsValidatingClientRequestError;
import com.xorrus.trading.ib.tws.api.response.ErrorMessageResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u0000 \u000e2\u00060\u0001j\u0002`\u0002:\u0001\u000eB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/xorrus/trading/ib/tws/api/TwsError;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "errorCode", "", "errorMessage", "", "<init>", "(ILjava/lang/String;)V", "getErrorCode", "()I", "getErrorMessage", "()Ljava/lang/String;", "toString", "Companion", "tws-api"})
public class TwsError
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int errorCode;
    @NotNull
    private final String errorMessage;

    public TwsError(int errorCode, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @NotNull
    public String toString() {
        return "TwsError(errorCode = " + this.errorCode + ", errorMessage = \"" + this.errorMessage + "\"";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/xorrus/trading/ib/tws/api/TwsError$Companion;", "", "<init>", "()V", "fromErrorMessageResponse", "Lcom/xorrus/trading/ib/tws/api/TwsError;", "msg", "Lcom/xorrus/trading/ib/tws/api/response/ErrorMessageResponse;", "throwTwsError", "", "tws-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final TwsError fromErrorMessageResponse(@NotNull ErrorMessageResponse msg) {
            TwsError twsError;
            int n;
            block12: {
                block11: {
                    Integer n2;
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    Integer n3 = n2 = msg.getErrorCode();
                    n = 162;
                    if (n3 != null && n3 == n) {
                        TwsRequestError twsRequestError;
                        if (StringsKt.contains$default((CharSequence)msg.getErrorMessage(), (CharSequence)"pacing violation", (boolean)false, (int)2, null)) {
                            Integer n4 = msg.getRequestId();
                            Intrinsics.checkNotNull((Object)n4);
                            twsRequestError = new TwsPacingViolationError(n4, msg.getErrorMessage());
                        } else {
                            Integer n5 = msg.getRequestId();
                            Intrinsics.checkNotNull((Object)n5);
                            twsRequestError = new TwsNotHistoricalMarketDataError(n5, msg.getErrorMessage());
                        }
                        twsError = twsRequestError;
                        return twsError;
                    }
                    Integer n6 = n2;
                    n = 321;
                    if (n6 != null && n6 == n) {
                        Integer n7 = msg.getRequestId();
                        Intrinsics.checkNotNull((Object)n7);
                        twsError = new TwsValidatingClientRequestError(n7, msg.getErrorMessage());
                        return twsError;
                    }
                    Integer n8 = n2;
                    n = 322;
                    if (n8 != null && n8 == n) {
                        Integer n9 = msg.getRequestId();
                        Intrinsics.checkNotNull((Object)n9);
                        twsError = new TwsProcessingClientRequestError(n9, msg.getErrorMessage());
                        return twsError;
                    }
                    Integer n10 = n2;
                    n = 10167;
                    if (n10 != null && n10 == n) {
                        Integer n11 = msg.getRequestId();
                        Intrinsics.checkNotNull((Object)n11);
                        twsError = new TwsMissingDelayedDataSubscriptionError(n11, msg.getErrorMessage());
                        return twsError;
                    }
                    Integer n12 = n2;
                    n = 354;
                    if (n12 != null && n12 == n) break block11;
                    Integer n13 = n2;
                    n = 10168;
                    if (n13 == null || n13 != n) break block12;
                }
                Integer n14 = msg.getRequestId();
                Intrinsics.checkNotNull((Object)n14);
                twsError = new TwsMissingLiveDataSubscriptionError(n14, msg.getErrorCode(), msg.getErrorMessage());
                return twsError;
            }
            if (msg.getRequestId() != null) {
                Integer n15 = msg.getRequestId();
                n = -1;
                if (n15 == null || n15 != n) {
                    int n16 = msg.getRequestId();
                    Integer n17 = msg.getErrorCode();
                    Intrinsics.checkNotNull((Object)n17);
                    twsError = new TwsRequestError(n16, n17, msg.getErrorMessage());
                    return twsError;
                }
            }
            Integer n18 = msg.getErrorCode();
            Intrinsics.checkNotNull((Object)n18);
            twsError = new TwsError(n18, msg.getErrorMessage());
            return twsError;
        }

        public final void throwTwsError(@NotNull ErrorMessageResponse msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            throw this.fromErrorMessageResponse(msg);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

