/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.contract.cache.ident;

import com.xorrus.trading.common.XBigNumAsDoubleSerializer;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.common.contract.Right;
import com.xorrus.trading.ib.tws.contract.cache.ident.ContractIdent;
import com.xorrus.trading.ib.tws.contract.cache.ident.FutureIdent;
import com.xorrus.trading.ib.tws.contract.cache.ident.OptionIdent$;
import com.xorrus.trading.ib.tws.contract.cache.ident.UnderlyingIdent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.serializers.LocalDateSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="OptionIdent")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 42\u00020\u0001:\u000234B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rBM\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\f\u0010\u0012J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J=\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001J%\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\b2R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00065"}, d2={"Lcom/xorrus/trading/ib/tws/contract/cache/ident/OptionIdent;", "Lcom/xorrus/trading/ib/tws/contract/cache/ident/ContractIdent;", "underlying", "Lcom/xorrus/trading/ib/tws/contract/cache/ident/UnderlyingIdent;", "tradingClass", "", "expiration", "Lkotlinx/datetime/LocalDate;", "strike", "Lcom/xorrus/trading/common/bignum/XBigNum;", "right", "Lcom/xorrus/trading/common/contract/Right;", "<init>", "(Lcom/xorrus/trading/ib/tws/contract/cache/ident/UnderlyingIdent;Ljava/lang/String;Lkotlinx/datetime/LocalDate;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/contract/Right;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/xorrus/trading/ib/tws/contract/cache/ident/UnderlyingIdent;Ljava/lang/String;Lkotlinx/datetime/LocalDate;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/contract/Right;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getUnderlying", "()Lcom/xorrus/trading/ib/tws/contract/cache/ident/UnderlyingIdent;", "getTradingClass", "()Ljava/lang/String;", "getExpiration", "()Lkotlinx/datetime/LocalDate;", "getStrike", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getRight", "()Lcom/xorrus/trading/common/contract/Right;", "createDomainObject", "Lcom/xorrus/trading/common/contract/Option;", "hashCode", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$tws_api", "$serializer", "Companion", "tws-api"})
@SourceDebugExtension(value={"SMAP\nOptionIdent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionIdent.kt\ncom/xorrus/trading/ib/tws/contract/cache/ident/OptionIdent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class OptionIdent
extends ContractIdent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnderlyingIdent underlying;
    @Nullable
    private final String tradingClass;
    @NotNull
    private final LocalDate expiration;
    @NotNull
    private final XBigNum strike;
    @NotNull
    private final Right right;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public OptionIdent(@NotNull UnderlyingIdent underlying, @Nullable String tradingClass, @NotNull LocalDate expiration, @NotNull XBigNum strike, @NotNull Right right) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
        Intrinsics.checkNotNullParameter((Object)strike, (String)"strike");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        super(null);
        this.underlying = underlying;
        this.tradingClass = tradingClass;
        this.expiration = expiration;
        this.strike = strike;
        this.right = right;
        if (this.underlying instanceof FutureIdent) {
            if (!(this.tradingClass == null)) {
                boolean $i$a$-require-OptionIdent$22 = false;
                String $i$a$-require-OptionIdent$22 = "Die Tradingklasse muss bei Future-Option null sein.";
                throw new IllegalArgumentException($i$a$-require-OptionIdent$22.toString());
            }
            v0 = Unit.INSTANCE;
        } else {
            v0 = this.tradingClass;
            if (v0 == null) {
                boolean bl = false;
                String string = "Die Tradingklasse muss bei Index-/Stockoptionen gesetzt sein.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @NotNull
    public final UnderlyingIdent getUnderlying() {
        return this.underlying;
    }

    @Nullable
    public final String getTradingClass() {
        return this.tradingClass;
    }

    @NotNull
    public final LocalDate getExpiration() {
        return this.expiration;
    }

    @NotNull
    public final XBigNum getStrike() {
        return this.strike;
    }

    @NotNull
    public final Right getRight() {
        return this.right;
    }

    @NotNull
    public Option createDomainObject() {
        return new Option(this.underlying.createDomainObject(), this.tradingClass, this.expiration, this.strike, this.right);
    }

    public int hashCode() {
        int result = this.underlying.hashCode();
        String string = this.tradingClass;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        result = 31 * result + this.expiration.hashCode();
        result = 31 * result + this.strike.hashCode();
        result = 31 * result + this.right.name().hashCode();
        return result;
    }

    @NotNull
    public final UnderlyingIdent component1() {
        return this.underlying;
    }

    @Nullable
    public final String component2() {
        return this.tradingClass;
    }

    @NotNull
    public final LocalDate component3() {
        return this.expiration;
    }

    @NotNull
    public final XBigNum component4() {
        return this.strike;
    }

    @NotNull
    public final Right component5() {
        return this.right;
    }

    @NotNull
    public final OptionIdent copy(@NotNull UnderlyingIdent underlying, @Nullable String tradingClass, @NotNull LocalDate expiration, @NotNull XBigNum strike, @NotNull Right right) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
        Intrinsics.checkNotNullParameter((Object)strike, (String)"strike");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new OptionIdent(underlying, tradingClass, expiration, strike, right);
    }

    public static /* synthetic */ OptionIdent copy$default(OptionIdent optionIdent, UnderlyingIdent underlyingIdent, String string, LocalDate localDate, XBigNum xBigNum, Right right, int n, Object object) {
        if ((n & 1) != 0) {
            underlyingIdent = optionIdent.underlying;
        }
        if ((n & 2) != 0) {
            string = optionIdent.tradingClass;
        }
        if ((n & 4) != 0) {
            localDate = optionIdent.expiration;
        }
        if ((n & 8) != 0) {
            xBigNum = optionIdent.strike;
        }
        if ((n & 0x10) != 0) {
            right = optionIdent.right;
        }
        return optionIdent.copy(underlyingIdent, string, localDate, xBigNum, right);
    }

    @NotNull
    public String toString() {
        return "OptionIdent(underlying=" + this.underlying + ", tradingClass=" + this.tradingClass + ", expiration=" + this.expiration + ", strike=" + this.strike + ", right=" + this.right + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OptionIdent)) {
            return false;
        }
        OptionIdent optionIdent = (OptionIdent)other;
        if (!Intrinsics.areEqual((Object)this.underlying, (Object)optionIdent.underlying)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tradingClass, (Object)optionIdent.tradingClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expiration, (Object)optionIdent.expiration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.strike, (Object)optionIdent.strike)) {
            return false;
        }
        return this.right == optionIdent.right;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$tws_api(OptionIdent self, CompositeEncoder output, SerialDescriptor serialDesc) {
        ContractIdent.write$Self(self, output, serialDesc);
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), (Object)self.underlying);
        output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.tradingClass);
        output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)LocalDateSerializer.INSTANCE, (Object)self.expiration);
        output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)XBigNumAsDoubleSerializer.INSTANCE, (Object)self.strike);
        output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)lazyArray[4].getValue(), (Object)self.right);
    }

    public /* synthetic */ OptionIdent(int seen0, UnderlyingIdent underlying, String tradingClass, LocalDate expiration, XBigNum strike, Right right, SerializationConstructorMarker serializationConstructorMarker) {
        if (31 != (0x1F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, serializationConstructorMarker);
        this.underlying = underlying;
        this.tradingClass = tradingClass;
        this.expiration = expiration;
        this.strike = strike;
        this.right = right;
        if (this.underlying instanceof FutureIdent) {
            if (!(this.tradingClass == null)) {
                boolean $i$a$-require-OptionIdent$22 = false;
                String $i$a$-require-OptionIdent$22 = "Die Tradingklasse muss bei Future-Option null sein.";
                throw new IllegalArgumentException($i$a$-require-OptionIdent$22.toString());
            }
            v0 = Unit.INSTANCE;
        } else {
            v0 = this.tradingClass;
            if (v0 == null) {
                boolean bl = false;
                String string = "Die Tradingklasse muss bei Index-/Stockoptionen gesetzt sein.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> UnderlyingIdent.Companion.serializer()), null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.xorrus.trading.common.contract.Right", (Enum[])((Enum[])Right.values())))};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/xorrus/trading/ib/tws/contract/cache/ident/OptionIdent$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/xorrus/trading/ib/tws/contract/cache/ident/OptionIdent;", "tws-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<OptionIdent> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

