/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api;

import com.xorrus.trading.ib.tws.api.UtilsKt;
import io.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0015J\b\u0010\u0018\u001a\u00020\u000fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/xorrus/trading/ib/tws/api/TwsStringPacket;", "", "prependSize", "", "<init>", "(Z)V", "getPrependSize", "()Z", "setPrependSize", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "append", "", "str", "", "nullTerminated", "flag", "n", "", "toByteArray", "", "appendRaw", "array", "toString", "tws-api"})
@SourceDebugExtension(value={"SMAP\nTwsStringPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwsStringPacket.kt\ncom/xorrus/trading/ib/tws/api/TwsStringPacket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class TwsStringPacket {
    private boolean prependSize;
    @NotNull
    private final StringBuilder builder;

    public TwsStringPacket(boolean prependSize) {
        this.prependSize = prependSize;
        this.builder = new StringBuilder();
    }

    public /* synthetic */ TwsStringPacket(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getPrependSize() {
        return this.prependSize;
    }

    public final void setPrependSize(boolean bl) {
        this.prependSize = bl;
    }

    public final void append(@NotNull String str, boolean nullTerminated) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.builder.append(str);
        if (nullTerminated) {
            this.builder.append('\u0000');
        }
    }

    public static /* synthetic */ void append$default(TwsStringPacket twsStringPacket, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        twsStringPacket.append(string, bl);
    }

    public final void append(boolean flag) {
        TwsStringPacket.append$default(this, flag ? "1" : "0", false, 2, null);
    }

    public final void append(int n) {
        TwsStringPacket.append$default(this, String.valueOf(n), false, 2, null);
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray;
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        byte[] content = StringsKt.toByteArray((String)string, (Charset)Charsets.ISO_8859_1);
        int size = content.length;
        int offset = 0;
        if (this.prependSize) {
            byte[] byArray2;
            byte[] $this$toByteArray_u24lambda_u240 = byArray2 = new byte[size + 4];
            boolean bl = false;
            ArraysKt.copyInto$default((byte[])UtilsKt.intToBigEndian(size), (byte[])$this$toByteArray_u24lambda_u240, (int)0, (int)0, (int)0, (int)14, null);
            offset += 4;
            byArray = byArray2;
        } else {
            byArray = new byte[size];
        }
        byte[] arr = byArray;
        ArraysKt.copyInto$default((byte[])content, (byte[])arr, (int)offset, (int)0, (int)0, (int)12, null);
        return arr;
    }

    public final void appendRaw(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        String str = UtilsKt.toIso8859String(array);
        this.builder.append(str);
        byte[] arr1 = StringsKt.toByteArray((String)str, (Charset)Charsets.ISO_8859_1);
        if (!Arrays.equals(arr1, array)) {
            boolean bl = false;
            String string = "arr1 = " + UtilsKt.toHexString(arr1) + ", arr2 = " + UtilsKt.toHexString(array);
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public TwsStringPacket() {
        this(false, 1, null);
    }
}

