/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.ib.tws.api.TwsLocalDateTimeFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.Month;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u0005*\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\u0006\u001a\u00020\u0005*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\u0006\u001a\u00020\u0005*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u0005*\u00020\r\u001a\n\u0010\u000f\u001a\u00020\r*\u00020\u0005\u001a\n\u0010\u0010\u001a\u00020\r*\u00020\u0005\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"SPACE_WITH_TZ", "Lkotlin/text/Regex;", "SPACE_NO_TZ", "fromTwsToInstant", "Lkotlin/time/Instant;", "", "toTwsString", "timeZone", "Lkotlinx/datetime/TimeZone;", "toLocalDateTime", "Lkotlinx/datetime/LocalDateTime;", "format", "Lcom/xorrus/trading/ib/tws/api/TwsLocalDateTimeFormat;", "Lkotlinx/datetime/LocalDate;", "toTwsMonthString", "fromTwsToLocalDate", "fromTwsToLocalDateMonth", "fromTwsToLocalTime", "Lkotlinx/datetime/LocalTime;", "tws-api"})
@SourceDebugExtension(value={"SMAP\ndate_time_utils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 date_time_utils.kt\ncom/xorrus/trading/ib/tws/api/Date_time_utilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class Date_time_utilsKt {
    @NotNull
    private static final Regex SPACE_WITH_TZ = new Regex("^(\\d{4})(\\d{2})(\\d{2})\\s+(\\d{2}):(\\d{2}):(\\d{2})\\s+([A-Za-z_/\\-+]+)$");
    @NotNull
    private static final Regex SPACE_NO_TZ = new Regex("^(\\d{4})(\\d{2})(\\d{2})\\s+(\\d{2}):(\\d{2}):(\\d{2})$");

    @NotNull
    public static final Instant fromTwsToInstant(@NotNull String $this$fromTwsToInstant) {
        Intrinsics.checkNotNullParameter((Object)$this$fromTwsToInstant, (String)"<this>");
        String s = ((Object)StringsKt.trim((CharSequence)$this$fromTwsToInstant)).toString();
        MatchResult matchResult = TwsLocalDateTimeFormat.WITH_DASH.getRegex().matchEntire((CharSequence)s);
        if (matchResult != null) {
            MatchResult m = matchResult;
            boolean bl = false;
            MatchResult.Destructured destructured = m.getDestructured();
            String y = (String)destructured.getMatch().getGroupValues().get(1);
            String mo = (String)destructured.getMatch().getGroupValues().get(2);
            String d = (String)destructured.getMatch().getGroupValues().get(3);
            String hh = (String)destructured.getMatch().getGroupValues().get(4);
            String mm = (String)destructured.getMatch().getGroupValues().get(5);
            String ss = (String)destructured.getMatch().getGroupValues().get(6);
            return TimeZoneKt.toInstant$default((LocalDateTime)new LocalDateTime(Integer.parseInt(y), Integer.parseInt(mo), Integer.parseInt(d), Integer.parseInt(hh), Integer.parseInt(mm), Integer.parseInt(ss), 0, 64, null), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null);
        }
        MatchResult matchResult2 = SPACE_WITH_TZ.matchEntire((CharSequence)s);
        if (matchResult2 != null) {
            MatchResult m = matchResult2;
            boolean bl = false;
            MatchResult.Destructured destructured = m.getDestructured();
            String y = (String)destructured.getMatch().getGroupValues().get(1);
            String mo = (String)destructured.getMatch().getGroupValues().get(2);
            String d = (String)destructured.getMatch().getGroupValues().get(3);
            String hh = (String)destructured.getMatch().getGroupValues().get(4);
            String mm = (String)destructured.getMatch().getGroupValues().get(5);
            String ss = (String)destructured.getMatch().getGroupValues().get(6);
            String tz = (String)destructured.getMatch().getGroupValues().get(7);
            LocalDateTime ldt = new LocalDateTime(Integer.parseInt(y), Integer.parseInt(mo), Integer.parseInt(d), Integer.parseInt(hh), Integer.parseInt(mm), Integer.parseInt(ss), 0, 64, null);
            return TimeZoneKt.toInstant$default((LocalDateTime)ldt, (TimeZone)TimeZone.Companion.of(tz), null, (int)2, null);
        }
        MatchResult matchResult3 = SPACE_NO_TZ.matchEntire((CharSequence)s);
        if (matchResult3 != null) {
            MatchResult m = matchResult3;
            boolean bl = false;
            MatchResult.Destructured destructured = m.getDestructured();
            String y = (String)destructured.getMatch().getGroupValues().get(1);
            String mo = (String)destructured.getMatch().getGroupValues().get(2);
            String d = (String)destructured.getMatch().getGroupValues().get(3);
            String hh = (String)destructured.getMatch().getGroupValues().get(4);
            String mm = (String)destructured.getMatch().getGroupValues().get(5);
            String ss = (String)destructured.getMatch().getGroupValues().get(6);
            LocalDateTime ldt = new LocalDateTime(Integer.parseInt(y), Integer.parseInt(mo), Integer.parseInt(d), Integer.parseInt(hh), Integer.parseInt(mm), Integer.parseInt(ss), 0, 64, null);
            return TimeZoneKt.toInstant$default((LocalDateTime)ldt, (TimeZone)TimeZone.Companion.currentSystemDefault(), null, (int)2, null);
        }
        throw new IllegalArgumentException("'" + $this$fromTwsToInstant + "' ist keine g\u00fcltige IB-Zeitangabe. Erwartet 'yyyyMMdd-HH:mm:ss' oder 'yyyyMMdd HH:mm:ss [TimeZone]'.");
    }

    @NotNull
    public static final String toTwsString(@NotNull Instant $this$toTwsString, @Nullable TimeZone timeZone) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toTwsString, (String)"<this>");
        StringBuilder $this$toTwsString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (timeZone != null) {
            $this$toTwsString_u24lambda_u240.append(Date_time_utilsKt.toTwsString(TimeZoneKt.toLocalDateTime((Instant)$this$toTwsString, (TimeZone)timeZone), TwsLocalDateTimeFormat.SINGLE_SPACE));
            $this$toTwsString_u24lambda_u240.append(' ');
            v0 = $this$toTwsString_u24lambda_u240.append(timeZone);
        } else {
            v0 = $this$toTwsString_u24lambda_u240.append(Date_time_utilsKt.toTwsString(TimeZoneKt.toLocalDateTime((Instant)$this$toTwsString, (TimeZone)((TimeZone)TimeZone.Companion.getUTC())), TwsLocalDateTimeFormat.WITH_DASH));
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String toTwsString$default(Instant instant, TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = null;
        }
        return Date_time_utilsKt.toTwsString(instant, timeZone);
    }

    @NotNull
    public static final LocalDateTime toLocalDateTime(@NotNull String $this$toLocalDateTime, @NotNull TwsLocalDateTimeFormat format) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        MatchResult result = format.getRegex().matchEntire((CharSequence)$this$toLocalDateTime);
        if (result == null) {
            boolean bl = false;
            String string = "'" + $this$toLocalDateTime + "' ist nicht im TwsDateTimeFormat " + format + ".";
            throw new IllegalArgumentException(string.toString());
        }
        MatchResult.Destructured destructured = result.getDestructured();
        String sYear = (String)destructured.getMatch().getGroupValues().get(1);
        String sMonth = (String)destructured.getMatch().getGroupValues().get(2);
        String sDay = (String)destructured.getMatch().getGroupValues().get(3);
        String sHour = (String)destructured.getMatch().getGroupValues().get(4);
        String sMinute = (String)destructured.getMatch().getGroupValues().get(5);
        String sSecond = (String)destructured.getMatch().getGroupValues().get(6);
        return new LocalDateTime(Integer.parseInt(sYear), Integer.parseInt(sMonth), Integer.parseInt(sDay), Integer.parseInt(sHour), Integer.parseInt(sMinute), Integer.parseInt(sSecond), 0, 64, null);
    }

    @NotNull
    public static final String toTwsString(@NotNull LocalDateTime $this$toTwsString, @NotNull TwsLocalDateTimeFormat format) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toTwsString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        StringBuilder $this$toTwsString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toTwsString_u24lambda_u241.append($this$toTwsString.getYear());
        if (format == TwsLocalDateTimeFormat.WITH_DOT_ZERO || format == TwsLocalDateTimeFormat.DEFAULT) {
            $this$toTwsString_u24lambda_u241.append('-');
        }
        $this$toTwsString_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf(MonthKt.getNumber((Month)$this$toTwsString.getMonth())), (int)2, (char)'0'));
        if (format == TwsLocalDateTimeFormat.WITH_DOT_ZERO || format == TwsLocalDateTimeFormat.DEFAULT) {
            $this$toTwsString_u24lambda_u241.append('-');
        }
        $this$toTwsString_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf($this$toTwsString.getDay()), (int)2, (char)'0'));
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Object object = $this$toTwsString_u24lambda_u241.append(' ');
                break;
            }
            case 4: {
                Object object = $this$toTwsString_u24lambda_u241.append("  ");
                break;
            }
            case 5: {
                Object object = Unit.INSTANCE;
                break;
            }
            case 6: {
                Object object = $this$toTwsString_u24lambda_u241.append("-");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$toTwsString_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf($this$toTwsString.getHour()), (int)2, (char)'0')).append(':');
        $this$toTwsString_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf($this$toTwsString.getMinute()), (int)2, (char)'0')).append(':');
        $this$toTwsString_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf($this$toTwsString.getSecond()), (int)2, (char)'0'));
        if (format == TwsLocalDateTimeFormat.WITH_DOT_ZERO) {
            $this$toTwsString_u24lambda_u241.append(".0");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static final String toTwsString(@NotNull LocalDate $this$toTwsString) {
        Intrinsics.checkNotNullParameter((Object)$this$toTwsString, (String)"<this>");
        return DateKt.toString$default((LocalDate)$this$toTwsString, (String)"yyyyMMdd", null, (int)2, null);
    }

    @NotNull
    public static final String toTwsMonthString(@NotNull LocalDate $this$toTwsMonthString) {
        Intrinsics.checkNotNullParameter((Object)$this$toTwsMonthString, (String)"<this>");
        return DateKt.toString$default((LocalDate)$this$toTwsMonthString, (String)"yyyyMM", null, (int)2, null);
    }

    @NotNull
    public static final LocalDate fromTwsToLocalDate(@NotNull String $this$fromTwsToLocalDate) {
        Intrinsics.checkNotNullParameter((Object)$this$fromTwsToLocalDate, (String)"<this>");
        if (!($this$fromTwsToLocalDate.length() == 8)) {
            boolean $i$a$-require-Date_time_utilsKt$fromTwsToLocalDate$22 = false;
            String $i$a$-require-Date_time_utilsKt$fromTwsToLocalDate$22 = "'" + $this$fromTwsToLocalDate + "' ist kein Datum im Format YYYYMMDD.";
            throw new IllegalArgumentException($i$a$-require-Date_time_utilsKt$fromTwsToLocalDate$22.toString());
        }
        int year = Integer.parseInt(StringsKt.substring((String)$this$fromTwsToLocalDate, (IntRange)new IntRange(0, 3)));
        int monthNumber = Integer.parseInt(StringsKt.substring((String)$this$fromTwsToLocalDate, (IntRange)new IntRange(4, 5)));
        int dayOfMonth = Integer.parseInt(StringsKt.substring((String)$this$fromTwsToLocalDate, (IntRange)new IntRange(6, 7)));
        return new LocalDate(year, monthNumber, dayOfMonth);
    }

    @NotNull
    public static final LocalDate fromTwsToLocalDateMonth(@NotNull String $this$fromTwsToLocalDateMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$fromTwsToLocalDateMonth, (String)"<this>");
        if (!($this$fromTwsToLocalDateMonth.length() == 6)) {
            boolean $i$a$-require-Date_time_utilsKt$fromTwsToLocalDateMonth$22 = false;
            String $i$a$-require-Date_time_utilsKt$fromTwsToLocalDateMonth$22 = "'" + $this$fromTwsToLocalDateMonth + "' ist kein Datum im Format YYYYMM.";
            throw new IllegalArgumentException($i$a$-require-Date_time_utilsKt$fromTwsToLocalDateMonth$22.toString());
        }
        int year = Integer.parseInt(StringsKt.substring((String)$this$fromTwsToLocalDateMonth, (IntRange)new IntRange(0, 3)));
        int monthNumber = Integer.parseInt(StringsKt.substring((String)$this$fromTwsToLocalDateMonth, (IntRange)new IntRange(4, 5)));
        return new LocalDate(year, monthNumber, 1);
    }

    @NotNull
    public static final LocalTime fromTwsToLocalTime(@NotNull String $this$fromTwsToLocalTime) {
        Intrinsics.checkNotNullParameter((Object)$this$fromTwsToLocalTime, (String)"<this>");
        if (!($this$fromTwsToLocalTime.length() == 4)) {
            boolean $i$a$-require-Date_time_utilsKt$fromTwsToLocalTime$22 = false;
            String $i$a$-require-Date_time_utilsKt$fromTwsToLocalTime$22 = "'" + $this$fromTwsToLocalTime + "' ist keine Uhrzeit im Format hhmm.";
            throw new IllegalArgumentException($i$a$-require-Date_time_utilsKt$fromTwsToLocalTime$22.toString());
        }
        String string = $this$fromTwsToLocalTime.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int hour = Integer.parseInt(string);
        String string2 = $this$fromTwsToLocalTime.substring(2, 4);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int minute = Integer.parseInt(string2);
        return new LocalTime(hour, minute, 0, 0, 12, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TwsLocalDateTimeFormat.values().length];
            try {
                nArray[TwsLocalDateTimeFormat.WITH_DOT_ZERO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwsLocalDateTimeFormat.DEFAULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwsLocalDateTimeFormat.SINGLE_SPACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwsLocalDateTimeFormat.DOUBLE_SPACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwsLocalDateTimeFormat.WITHOUT_SPACE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwsLocalDateTimeFormat.WITH_DASH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

