/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.ib.flex.state;

import com.xorrus.common.kotlin.stax.CompoundHandler;
import com.xorrus.common.kotlin.stax.CurrentAttrHandler;
import com.xorrus.common.kotlin.stax.OptionalHandler;
import com.xorrus.common.kotlin.stax.SingleHandler;
import com.xorrus.common.kotlin.stax.StaksBuilderKt;
import com.xorrus.common.kotlin.stax.StartDocumentHandler;
import com.xorrus.common.kotlin.stax.StaxBuilder;
import com.xorrus.common.kotlin.stax.TagTextHandler;
import com.xorrus.trading.lot.ib.flex.state.FlexStatusResponse;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/xorrus/trading/lot/ib/flex/state/StatusXmlParser;", "", "<init>", "()V", "parse", "Lcom/xorrus/trading/lot/ib/flex/state/FlexStatusResponse;", "inputStream", "Ljava/io/InputStream;", "laboftrades-ib"})
public final class StatusXmlParser {
    @NotNull
    public static final StatusXmlParser INSTANCE = new StatusXmlParser();

    private StatusXmlParser() {
    }

    @NotNull
    public final FlexStatusResponse parse(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return (FlexStatusResponse)StaksBuilderKt.staks(inputStream, true, StatusXmlParser::parse$lambda$0);
    }

    private static final Function0 parse$lambda$0(StaxBuilder $this$staks) {
        Intrinsics.checkNotNullParameter((Object)$this$staks, (String)"$this$staks");
        StartDocumentHandler startDocumentHandler = StaksBuilderKt.startDocument($this$staks, StatusXmlParser::parse$lambda$0$0);
        return () -> StatusXmlParser.parse$lambda$0$1(startDocumentHandler);
    }

    private static final Function0 parse$lambda$0$0(CompoundHandler $this$startDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$startDocument, (String)"$this$startDocument");
        SingleHandler flexStatementResponse = StaksBuilderKt.single($this$startDocument, "FlexStatementResponse", StatusXmlParser::parse$lambda$0$0$0);
        return () -> StatusXmlParser.parse$lambda$0$0$1(flexStatementResponse);
    }

    private static final Function0 parse$lambda$0$0$0(CompoundHandler $this$single) {
        Intrinsics.checkNotNullParameter((Object)$this$single, (String)"$this$single");
        CurrentAttrHandler timestamp = StaksBuilderKt.attribute($this$single, "timestamp");
        TagTextHandler status = StaksBuilderKt.tagText($this$single, "Status");
        OptionalHandler referenceCode = $this$single.optional(StaksBuilderKt.tagText($this$single, "ReferenceCode"));
        OptionalHandler url = $this$single.optional(StaksBuilderKt.tagText($this$single, "Url"));
        OptionalHandler errorCode = $this$single.optional(StaksBuilderKt.tagText($this$single, "ErrorCode"));
        OptionalHandler errorMessage = $this$single.optional(StaksBuilderKt.tagText($this$single, "ErrorMessage"));
        return () -> StatusXmlParser.parse$lambda$0$0$0$0(timestamp, status, referenceCode, url, errorCode, errorMessage);
    }

    private static final FlexStatusResponse parse$lambda$0$0$0$0(CurrentAttrHandler $timestamp, TagTextHandler $status, OptionalHandler $referenceCode, OptionalHandler $url, OptionalHandler $errorCode, OptionalHandler $errorMessage) {
        return new FlexStatusResponse((String)$timestamp.invoke(), (String)$status.invoke(), (String)$referenceCode.invoke(), (String)$url.invoke(), (String)$errorCode.invoke(), (String)$errorMessage.invoke());
    }

    private static final FlexStatusResponse parse$lambda$0$0$1(SingleHandler $flexStatementResponse) {
        return (FlexStatusResponse)$flexStatementResponse.invoke();
    }

    private static final FlexStatusResponse parse$lambda$0$1(StartDocumentHandler $startDocumentHandler) {
        return (FlexStatusResponse)$startDocumentHandler.invoke();
    }
}

