/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.strategy;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.TimezoneKt;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.ContractManager;
import com.xorrus.trading.common.contract.OHLCV;
import com.xorrus.trading.common.contract.Price;
import com.xorrus.trading.common.contract.Stock;
import com.xorrus.trading.common.contract.Underlying;
import com.xorrus.trading.ib.tws.api.TwsMissingLiveDataSubscriptionError;
import com.xorrus.trading.lot.business.strategy.ZeroDTEOpeningPut20Strategy;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.datetime.DayOfWeek;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b2\u0018\u00002\u00020\u0001B\u00c9\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00121\u0010\u0010\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00121\u0010\u0018\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00121\u0010\u001a\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00121\u0010\u001b\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u0012\u001c\u0010\u001c\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000e\u0010H\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010IJ(\u0010J\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00122\b\u0010L\u001a\u0004\u0018\u00010\u00052\u0006\u0010M\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010NR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010-\"\u0004\b1\u0010/R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00103\"\u0004\b7\u00105R>\u0010\u0010\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00a2\u0006\n\n\u0002\u0010:\u001a\u0004\b8\u00109R>\u0010\u0018\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00a2\u0006\n\n\u0002\u0010:\u001a\u0004\b;\u00109R>\u0010\u001a\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00a2\u0006\n\n\u0002\u0010:\u001a\u0004\b<\u00109R>\u0010\u001b\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00a2\u0006\n\n\u0002\u0010:\u001a\u0004\b=\u00109R)\u0010\u001c\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d\u00a2\u0006\n\n\u0002\u0010@\u001a\u0004\b>\u0010?R\u0014\u0010A\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010-R\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010-\u00a8\u0006O"}, d2={"Lcom/xorrus/trading/lot/business/strategy/ZeroDTEOpeningPut20Strategy;", "", "underlying", "Lcom/xorrus/trading/common/contract/Underlying;", "tradingClass", "", "validDays", "", "Lkotlinx/datetime/DayOfWeek;", "validTimeNY", "Lkotlin/ranges/ClosedRange;", "Lkotlinx/datetime/LocalTime;", "ibTimeNY", "maxGapDown", "", "maxGapUp", "stepFct", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "value", "Lkotlin/coroutines/Continuation;", "", "successFct", "", "errorFct", "descriptionFct", "finishFct", "Lkotlin/Function1;", "<init>", "(Lcom/xorrus/trading/common/contract/Underlying;Ljava/lang/String;Ljava/util/List;Lkotlin/ranges/ClosedRange;Lkotlin/ranges/ClosedRange;DDLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "getUnderlying", "()Lcom/xorrus/trading/common/contract/Underlying;", "setUnderlying", "(Lcom/xorrus/trading/common/contract/Underlying;)V", "getTradingClass", "()Ljava/lang/String;", "setTradingClass", "(Ljava/lang/String;)V", "getValidDays", "()Ljava/util/List;", "setValidDays", "(Ljava/util/List;)V", "getValidTimeNY", "()Lkotlin/ranges/ClosedRange;", "setValidTimeNY", "(Lkotlin/ranges/ClosedRange;)V", "getIbTimeNY", "setIbTimeNY", "getMaxGapDown", "()D", "setMaxGapDown", "(D)V", "getMaxGapUp", "setMaxGapUp", "getStepFct", "()Lkotlin/jvm/functions/Function2;", "Lkotlin/jvm/functions/Function2;", "getSuccessFct", "getErrorFct", "getDescriptionFct", "getFinishFct", "()Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function1;", "steps", "getSteps", "()I", "validTimeLocal", "getValidTimeLocal", "ibTimeLocal", "getIbTimeLocal", "checkPreConditions", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "placeOrder", "size", "accountId", "transmit", "(ILjava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "laboftrades-business"})
public final class ZeroDTEOpeningPut20Strategy {
    @NotNull
    private Underlying underlying;
    @NotNull
    private String tradingClass;
    @NotNull
    private List<? extends DayOfWeek> validDays;
    @NotNull
    private ClosedRange<LocalTime> validTimeNY;
    @NotNull
    private ClosedRange<LocalTime> ibTimeNY;
    private double maxGapDown;
    private double maxGapUp;
    @NotNull
    private final Function2<Integer, Continuation<? super Unit>, Object> stepFct;
    @NotNull
    private final Function2<Boolean, Continuation<? super Unit>, Object> successFct;
    @NotNull
    private final Function2<Integer, Continuation<? super Unit>, Object> errorFct;
    @NotNull
    private final Function2<String, Continuation<? super Unit>, Object> descriptionFct;
    @NotNull
    private final Function1<Continuation<? super Unit>, Object> finishFct;
    private final int steps;

    public ZeroDTEOpeningPut20Strategy(@NotNull Underlying underlying, @NotNull String tradingClass, @NotNull List<? extends DayOfWeek> validDays, @NotNull ClosedRange<LocalTime> validTimeNY, @NotNull ClosedRange<LocalTime> ibTimeNY, double maxGapDown, double maxGapUp, @NotNull Function2<? super Integer, ? super Continuation<? super Unit>, ? extends Object> stepFct, @NotNull Function2<? super Boolean, ? super Continuation<? super Unit>, ? extends Object> successFct, @NotNull Function2<? super Integer, ? super Continuation<? super Unit>, ? extends Object> errorFct, @NotNull Function2<? super String, ? super Continuation<? super Unit>, ? extends Object> descriptionFct, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> finishFct) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)tradingClass, (String)"tradingClass");
        Intrinsics.checkNotNullParameter(validDays, (String)"validDays");
        Intrinsics.checkNotNullParameter(validTimeNY, (String)"validTimeNY");
        Intrinsics.checkNotNullParameter(ibTimeNY, (String)"ibTimeNY");
        Intrinsics.checkNotNullParameter(stepFct, (String)"stepFct");
        Intrinsics.checkNotNullParameter(successFct, (String)"successFct");
        Intrinsics.checkNotNullParameter(errorFct, (String)"errorFct");
        Intrinsics.checkNotNullParameter(descriptionFct, (String)"descriptionFct");
        Intrinsics.checkNotNullParameter(finishFct, (String)"finishFct");
        this.underlying = underlying;
        this.tradingClass = tradingClass;
        this.validDays = validDays;
        this.validTimeNY = validTimeNY;
        this.ibTimeNY = ibTimeNY;
        this.maxGapDown = maxGapDown;
        this.maxGapUp = maxGapUp;
        this.stepFct = stepFct;
        this.successFct = successFct;
        this.errorFct = errorFct;
        this.descriptionFct = descriptionFct;
        this.finishFct = finishFct;
        this.steps = 3;
    }

    public /* synthetic */ ZeroDTEOpeningPut20Strategy(Underlying underlying, String string, List list, ClosedRange closedRange, ClosedRange closedRange2, double d, double d2, Function2 function2, Function2 function22, Function2 function23, Function2 function24, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            underlying = (Underlying)Stock.Companion.getSPY();
        }
        if ((n & 2) != 0) {
            string = "SPY";
        }
        if ((n & 4) != 0) {
            Object[] objectArray = new DayOfWeek[]{DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.FRIDAY};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        if ((n & 8) != 0) {
            closedRange = RangesKt.rangeTo((Comparable)((Comparable)new LocalTime(10, 0, 0, 0, 12, null)), (Comparable)((Comparable)new LocalTime(10, 15, 0, 0, 12, null)));
        }
        if ((n & 0x10) != 0) {
            closedRange2 = RangesKt.rangeTo((Comparable)((Comparable)new LocalTime(9, 30, 0, 0, 12, null)), (Comparable)((Comparable)new LocalTime(10, 0, 0, 0, 12, null)));
        }
        if ((n & 0x20) != 0) {
            d = 0.02;
        }
        if ((n & 0x40) != 0) {
            d2 = 0.015;
        }
        this(underlying, string, list, (ClosedRange<LocalTime>)closedRange, (ClosedRange<LocalTime>)closedRange2, d, d2, (Function2<? super Integer, ? super Continuation<? super Unit>, ? extends Object>)function2, (Function2<? super Boolean, ? super Continuation<? super Unit>, ? extends Object>)function22, (Function2<? super Integer, ? super Continuation<? super Unit>, ? extends Object>)function23, (Function2<? super String, ? super Continuation<? super Unit>, ? extends Object>)function24, (Function1<? super Continuation<? super Unit>, ? extends Object>)function1);
    }

    @NotNull
    public final Underlying getUnderlying() {
        return this.underlying;
    }

    public final void setUnderlying(@NotNull Underlying underlying) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"<set-?>");
        this.underlying = underlying;
    }

    @NotNull
    public final String getTradingClass() {
        return this.tradingClass;
    }

    public final void setTradingClass(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.tradingClass = string;
    }

    @NotNull
    public final List<DayOfWeek> getValidDays() {
        return this.validDays;
    }

    public final void setValidDays(@NotNull List<? extends DayOfWeek> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.validDays = list;
    }

    @NotNull
    public final ClosedRange<LocalTime> getValidTimeNY() {
        return this.validTimeNY;
    }

    public final void setValidTimeNY(@NotNull ClosedRange<LocalTime> closedRange) {
        Intrinsics.checkNotNullParameter(closedRange, (String)"<set-?>");
        this.validTimeNY = closedRange;
    }

    @NotNull
    public final ClosedRange<LocalTime> getIbTimeNY() {
        return this.ibTimeNY;
    }

    public final void setIbTimeNY(@NotNull ClosedRange<LocalTime> closedRange) {
        Intrinsics.checkNotNullParameter(closedRange, (String)"<set-?>");
        this.ibTimeNY = closedRange;
    }

    public final double getMaxGapDown() {
        return this.maxGapDown;
    }

    public final void setMaxGapDown(double d) {
        this.maxGapDown = d;
    }

    public final double getMaxGapUp() {
        return this.maxGapUp;
    }

    public final void setMaxGapUp(double d) {
        this.maxGapUp = d;
    }

    @NotNull
    public final Function2<Integer, Continuation<? super Unit>, Object> getStepFct() {
        return this.stepFct;
    }

    @NotNull
    public final Function2<Boolean, Continuation<? super Unit>, Object> getSuccessFct() {
        return this.successFct;
    }

    @NotNull
    public final Function2<Integer, Continuation<? super Unit>, Object> getErrorFct() {
        return this.errorFct;
    }

    @NotNull
    public final Function2<String, Continuation<? super Unit>, Object> getDescriptionFct() {
        return this.descriptionFct;
    }

    @NotNull
    public final Function1<Continuation<? super Unit>, Object> getFinishFct() {
        return this.finishFct;
    }

    public final int getSteps() {
        return this.steps;
    }

    @NotNull
    public final ClosedRange<LocalTime> getValidTimeLocal() {
        return DateKt.switchTimeZone$default(this.validTimeNY, (TimeZone)TimezoneKt.getNewYorkTimezone(), null, (int)2, null);
    }

    @NotNull
    public final ClosedRange<LocalTime> getIbTimeLocal() {
        return DateKt.switchTimeZone$default(this.ibTimeNY, (TimeZone)TimezoneKt.getNewYorkTimezone(), null, (int)2, null);
    }

    @Nullable
    public final Object checkPreConditions(@NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            final /* synthetic */ ZeroDTEOpeningPut20Strategy this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                block130: {
                    block129: {
                        block128: {
                            block127: {
                                block126: {
                                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = this.this$0.getDescriptionFct().invoke((Object)"", (Object)this);
                                            ** if (v0 != var11_2) goto lbl11
lbl10:
                                            // 1 sources

                                            return var11_2;
lbl11:
                                            // 1 sources

                                            ** GOTO lbl17
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            this.label = 2;
                                            v1 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)-1), (Object)this);
                                            ** if (v1 != var11_2) goto lbl21
lbl20:
                                            // 1 sources

                                            return var11_2;
lbl21:
                                            // 1 sources

                                            ** GOTO lbl27
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl27:
                                            // 2 sources

                                            this.label = 3;
                                            v2 = this.this$0.getStepFct().invoke((Object)Boxing.boxInt((int)0), (Object)this);
                                            ** if (v2 != var11_2) goto lbl31
lbl30:
                                            // 1 sources

                                            return var11_2;
lbl31:
                                            // 1 sources

                                            ** GOTO lbl37
                                        }
                                        case 3: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl37:
                                            // 2 sources

                                            this.label = 4;
                                            v3 = this.this$0.getSuccessFct().invoke((Object)Boxing.boxBoolean((boolean)false), (Object)this);
                                            ** if (v3 != var11_2) goto lbl41
lbl40:
                                            // 1 sources

                                            return var11_2;
lbl41:
                                            // 1 sources

                                            ** GOTO lbl48
                                        }
                                        case 4: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v3 = $result;
lbl48:
                                            // 3 sources

                                            this.label = 5;
                                            v4 = Contract.getPrice$default((Contract)((Contract)this.this$0.getUnderlying()), null, (Continuation)((Continuation)this), (int)1, null);
                                            ** if (v4 != var11_2) goto lbl53
lbl52:
                                            // 1 sources

                                            return var11_2;
lbl53:
                                            // 1 sources

                                            ** GOTO lbl60
                                        }
                                        case 5: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v4 = $result;
lbl60:
                                            // 2 sources

                                            var3_3 = (Price)v4;
                                            break;
                                            {
                                                catch (TwsMissingLiveDataSubscriptionError <unused var>) {
                                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)<unused var>);
                                                    this.label = 6;
                                                    v5 = this.this$0.getDescriptionFct().invoke((Object)("Keine Marktdaten f\u00fcr " + this.this$0.getUnderlying().getSymbol()), (Object)this);
                                                    if (v5 == var11_2) {
                                                        return var11_2;
                                                    }
                                                    ** GOTO lbl75
                                                }
                                            }
                                        }
                                        case 6: {
                                            <unused var> = (TwsMissingLiveDataSubscriptionError)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v5 = $result;
lbl75:
                                            // 2 sources

                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)<unused var>);
                                            this.label = 7;
                                            v6 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)0), (Object)this);
                                            ** if (v6 != var11_2) goto lbl80
lbl79:
                                            // 1 sources

                                            return var11_2;
lbl80:
                                            // 1 sources

                                            ** GOTO lbl87
                                        }
                                        case 7: {
                                            <unused var> = (TwsMissingLiveDataSubscriptionError)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v6 = $result;
lbl87:
                                            // 2 sources

                                            var5_18 = Unit.INSTANCE;
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)<unused var>);
                                            this.L$1 = var5_18;
                                            this.label = 8;
                                            v7 = this.this$0.getFinishFct().invoke((Object)this);
                                            if (v7 == var11_2) {
                                                return var11_2;
                                            }
                                            ** GOTO lbl100
                                        }
                                        case 8: {
                                            var5_18 = (Unit)this.L$1;
                                            <unused var> = (TwsMissingLiveDataSubscriptionError)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v7 = $result;
lbl100:
                                            // 2 sources

                                            return var5_18;
                                        }
                                    }
                                    v8 = underlyingPrice = var3_3;
                                    if ((v8 != null ? v8.getPrice() : null) != null) break block126;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                    this.label = 9;
                                    v9 = this.this$0.getDescriptionFct().invoke((Object)("Kein Spotpreis f\u00fcr " + this.this$0.getUnderlying().getSymbol() + " gefunden"), (Object)this);
                                    ** if (v9 != var11_2) goto lbl109
lbl108:
                                    // 1 sources

                                    return var11_2;
lbl109:
                                    // 1 sources

                                    ** GOTO lbl116
                                    {
                                        case 9: {
                                            underlyingPrice = (Price)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v9 = $result;
lbl116:
                                            // 2 sources

                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                            this.label = 10;
                                            v10 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)0), (Object)this);
                                            ** if (v10 != var11_2) goto lbl121
lbl120:
                                            // 1 sources

                                            return var11_2;
lbl121:
                                            // 1 sources

                                            ** GOTO lbl128
                                        }
                                        case 10: {
                                            underlyingPrice = (Price)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v10 = $result;
lbl128:
                                            // 2 sources

                                            var3_3 = Unit.INSTANCE;
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                            this.L$1 = var3_3;
                                            this.label = 11;
                                            v11 = this.this$0.getFinishFct().invoke((Object)this);
                                            if (v11 == var11_2) {
                                                return var11_2;
                                            }
                                            ** GOTO lbl141
                                        }
                                        case 11: {
                                            var3_3 = (Unit)this.L$1;
                                            underlyingPrice = (Price)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v11 = $result;
lbl141:
                                            // 2 sources

                                            return var3_3;
                                        }
                                    }
                                }
                                if (this.this$0.getValidDays().contains(DateKt.today((TimeZone)TimezoneKt.getNewYorkTimezone()).getDayOfWeek())) break block127;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                this.label = 12;
                                v12 = this.this$0.getDescriptionFct().invoke((Object)"Kein g\u00fcltiger Wochentag", (Object)this);
                                ** if (v12 != var11_2) goto lbl150
lbl149:
                                // 1 sources

                                return var11_2;
lbl150:
                                // 1 sources

                                ** GOTO lbl157
                                {
                                    case 12: {
                                        underlyingPrice = (Price)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v12 = $result;
lbl157:
                                        // 2 sources

                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                        this.label = 13;
                                        v13 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)1), (Object)this);
                                        ** if (v13 != var11_2) goto lbl162
lbl161:
                                        // 1 sources

                                        return var11_2;
lbl162:
                                        // 1 sources

                                        ** GOTO lbl169
                                    }
                                    case 13: {
                                        underlyingPrice = (Price)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v13 = $result;
lbl169:
                                        // 2 sources

                                        var3_3 = Unit.INSTANCE;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                        this.L$1 = var3_3;
                                        this.label = 14;
                                        v14 = this.this$0.getFinishFct().invoke((Object)this);
                                        if (v14 == var11_2) {
                                            return var11_2;
                                        }
                                        ** GOTO lbl182
                                    }
                                    case 14: {
                                        var3_3 = (Unit)this.L$1;
                                        underlyingPrice = (Price)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v14 = $result;
lbl182:
                                        // 2 sources

                                        return var3_3;
                                    }
                                }
                            }
                            if (this.this$0.getValidTimeNY().contains((Comparable)DateKt.now((TimeZone)TimezoneKt.getNewYorkTimezone()).getTime())) break block128;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                            this.label = 15;
                            v15 = this.this$0.getDescriptionFct().invoke((Object)("Kein g\u00fcltiges Zeitfenster " + TimezoneKt.getNewYorkTimezone() + " " + this.this$0.getValidTimeNY() + " (" + TimeZone.Companion.currentSystemDefault() + ": " + this.this$0.getValidTimeLocal() + ")"), (Object)this);
                            ** if (v15 != var11_2) goto lbl191
lbl190:
                            // 1 sources

                            return var11_2;
lbl191:
                            // 1 sources

                            ** GOTO lbl198
                            {
                                case 15: {
                                    underlyingPrice = (Price)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v15 = $result;
lbl198:
                                    // 2 sources

                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                    this.label = 16;
                                    v16 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)1), (Object)this);
                                    ** if (v16 != var11_2) goto lbl203
lbl202:
                                    // 1 sources

                                    return var11_2;
lbl203:
                                    // 1 sources

                                    ** GOTO lbl210
                                }
                                case 16: {
                                    underlyingPrice = (Price)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v16 = $result;
lbl210:
                                    // 2 sources

                                    var3_3 = Unit.INSTANCE;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                    this.L$1 = var3_3;
                                    this.label = 17;
                                    v17 = this.this$0.getFinishFct().invoke((Object)this);
                                    if (v17 == var11_2) {
                                        return var11_2;
                                    }
                                    ** GOTO lbl223
                                }
                                case 17: {
                                    var3_3 = (Unit)this.L$1;
                                    underlyingPrice = (Price)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v17 = $result;
lbl223:
                                    // 2 sources

                                    return var3_3;
                                }
                            }
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                        this.label = 18;
                        v18 = this.this$0.getStepFct().invoke((Object)Boxing.boxInt((int)1), (Object)this);
                        ** if (v18 != var11_2) goto lbl231
lbl230:
                        // 1 sources

                        return var11_2;
lbl231:
                        // 1 sources

                        ** GOTO lbl240
                        {
                            case 18: {
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v18 = $result;
lbl240:
                                // 2 sources

                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                this.label = 19;
                                v19 = ContractManager.INSTANCE.getOHLCCandles-gwCluXo((Contract)this.this$0.getUnderlying(), DateKt.now().minus-LRDsOJo(DurationKt.toDuration((int)4, (DurationUnit)DurationUnit.DAYS)), DateKt.now(), DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.MINUTES), true, (Continuation)this);
                                ** if (v19 != var11_2) goto lbl245
lbl244:
                                // 1 sources

                                return var11_2;
lbl245:
                                // 1 sources

                                ** GOTO lbl252
                            }
                            case 19: {
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v19 = $result;
lbl252:
                                // 2 sources

                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                this.label = 20;
                                v20 = FlowKt.toList$default((Flow)((Flow)v19), null, (Continuation)((Continuation)this), (int)1, null);
                                ** if (v20 != var11_2) goto lbl257
lbl256:
                                // 1 sources

                                return var11_2;
lbl257:
                                // 1 sources

                                ** GOTO lbl264
                            }
                            case 20: {
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v20 = $result;
lbl264:
                                // 2 sources

                                candles30min4days = (List)v20;
                                $this$firstOrNull$iv = candles30min4days;
                                $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    it = (OHLCV)element$iv;
                                    $i$a$-firstOrNull-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$candle9_30_10_00$1 = false;
                                    if (!Intrinsics.areEqual((Object)it.getStart(), (Object)TimeZoneKt.toInstant$default((LocalDateTime)LocalDateKt.atTime$default((LocalDate)DateKt.today((TimeZone)TimezoneKt.getNewYorkTimezone()), (int)9, (int)30, (int)0, (int)0, (int)12, null), (TimeZone)TimezoneKt.getNewYorkTimezone(), null, (int)2, null))) continue;
                                    v21 = element$iv;
                                    ** GOTO lbl274
                                }
                                v21 = null;
lbl274:
                                // 2 sources

                                if (candle9_30_10_00 != null) {
                                    it = candle9_30_10_00 = (OHLCV)v21;
                                    $i$a$-let-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$lastCandleBefore$1 = false;
                                    v22 = checkPreConditions.2.invokeSuspend$previousOf(candles30min4days, it);
                                } else {
                                    v22 = lastCandleBefore = null;
                                }
                                if (candle9_30_10_00 != null && lastCandleBefore != null) break;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                                this.label = 21;
                                v23 = this.this$0.getDescriptionFct().invoke((Object)"Keine historischen Daten verf\u00fcgbar", (Object)this);
                                ** if (v23 != var11_2) goto lbl289
lbl288:
                                // 1 sources

                                return var11_2;
lbl289:
                                // 1 sources

                                ** GOTO lbl299
                            }
                            case 21: {
                                lastCandleBefore = (OHLCV)this.L$3;
                                candle9_30_10_00 = (Object[])this.L$2;
                                candles30min4days = (List)this.L$1;
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v23 = $result;
lbl299:
                                // 2 sources

                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                                this.label = 22;
                                v24 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)2), (Object)this);
                                ** if (v24 != var11_2) goto lbl307
lbl306:
                                // 1 sources

                                return var11_2;
lbl307:
                                // 1 sources

                                ** GOTO lbl317
                            }
                            case 22: {
                                lastCandleBefore = (OHLCV)this.L$3;
                                candle9_30_10_00 = (OHLCV)this.L$2;
                                candles30min4days = (List)this.L$1;
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v24 = $result;
lbl317:
                                // 2 sources

                                var6_36 = Unit.INSTANCE;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                                this.L$4 = var6_36;
                                this.label = 23;
                                v25 = this.this$0.getFinishFct().invoke((Object)this);
                                if (v25 == var11_2) {
                                    return var11_2;
                                }
                                ** GOTO lbl336
                            }
                            case 23: {
                                var6_36 = (Unit)this.L$4;
                                lastCandleBefore = (OHLCV)this.L$3;
                                candle9_30_10_00 = (OHLCV)this.L$2;
                                candles30min4days = (List)this.L$1;
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v25 = $result;
lbl336:
                                // 2 sources

                                return var6_36;
                            }
                        }
                        try {
                            if (lastCandleBefore.getClose() == null || candle9_30_10_00.getOpen() == null) ** GOTO lbl-1000
                            v26 = lastCandleBefore.getClose();
                            Intrinsics.checkNotNull((Object)v26);
                            v27 = XbignumKt.toDouble((XBigNum)v26);
                            v28 = candle9_30_10_00.getOpen();
                            Intrinsics.checkNotNull((Object)v28);
                            v29 = v27 - XbignumKt.toDouble((XBigNum)v28);
                            v30 = lastCandleBefore.getClose();
                            Intrinsics.checkNotNull((Object)v30);
                            if (v29 / XbignumKt.toDouble((XBigNum)v30) <= this.this$0.getMaxGapDown()) {
                                v31 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v31 = false;
                            }
                            if (v31) break block129;
                            v32 = this.this$0.getDescriptionFct();
                            var6_37 /* !! */  = "%.1f";
                            it = new Object[]{Boxing.boxDouble((double)(this.this$0.getMaxGapDown() * (double)100))};
                            v33 = String.format((String)var6_37 /* !! */ , Arrays.copyOf(it, it.length));
                            Intrinsics.checkNotNullExpressionValue((Object)v33, (String)"format(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                            this.label = 24;
                            v34 = v32.invoke((Object)("Vortages Gap down > " + v33 + "%"), (Object)this);
                            ** if (v34 != var11_2) goto lbl375
                        }
                        catch (Throwable var2_33) {
                            this.L$0 = var2_33;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.L$3 = null;
                            this.label = 37;
                            v35 = this.this$0.getFinishFct().invoke((Object)this);
                            if (v35 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl643
                        }
lbl374:
                        // 1 sources

                        return var11_2;
lbl375:
                        // 1 sources

                        ** GOTO lbl385
                        {
                            case 24: {
                                lastCandleBefore = (OHLCV)this.L$3;
                                candle9_30_10_00 = (OHLCV)this.L$2;
                                candles30min4days = (List)this.L$1;
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v34 = $result;
lbl385:
                                // 2 sources

                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                                this.label = 25;
                                v36 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)2), (Object)this);
                                ** if (v36 != var11_2) goto lbl393
lbl392:
                                // 1 sources

                                return var11_2;
lbl393:
                                // 1 sources

                                ** GOTO lbl403
                            }
                            case 25: {
                                lastCandleBefore = (OHLCV)this.L$3;
                                candle9_30_10_00 = (OHLCV)this.L$2;
                                candles30min4days = (List)this.L$1;
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v36 = $result;
lbl403:
                                // 2 sources

                                var6_37 /* !! */  = Unit.INSTANCE;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                                this.L$4 = var6_37 /* !! */ ;
                                this.label = 26;
                                v37 = this.this$0.getFinishFct().invoke((Object)this);
                                if (v37 == var11_2) {
                                    return var11_2;
                                }
                                ** GOTO lbl422
                            }
                            case 26: {
                                var6_37 /* !! */  = (Unit)this.L$4;
                                lastCandleBefore = (OHLCV)this.L$3;
                                candle9_30_10_00 = (OHLCV)this.L$2;
                                candles30min4days = (List)this.L$1;
                                underlyingPrice = (Price)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v37 = $result;
lbl422:
                                // 2 sources

                                return var6_37 /* !! */ ;
                            }
                        }
                    }
                    if (lastCandleBefore.getClose() == null || candle9_30_10_00.getOpen() == null) ** GOTO lbl-1000
                    v38 = candle9_30_10_00.getOpen();
                    Intrinsics.checkNotNull((Object)v38);
                    v39 = XbignumKt.toDouble((XBigNum)v38);
                    v40 = lastCandleBefore.getClose();
                    Intrinsics.checkNotNull((Object)v40);
                    v41 = v39 - XbignumKt.toDouble((XBigNum)v40);
                    v42 = lastCandleBefore.getClose();
                    Intrinsics.checkNotNull((Object)v42);
                    if (v41 / XbignumKt.toDouble((XBigNum)v42) <= this.this$0.getMaxGapUp()) {
                        v43 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v43 = false;
                    }
                    if (v43) break block130;
                    v44 = this.this$0.getDescriptionFct();
                    var6_38 /* !! */  = "%.1f";
                    it = new Object[]{Boxing.boxDouble((double)(this.this$0.getMaxGapUp() * (double)100))};
                    v45 = String.format((String)var6_38 /* !! */ , Arrays.copyOf(it, it.length));
                    Intrinsics.checkNotNullExpressionValue((Object)v45, (String)"format(...)");
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                    this.label = 27;
                    v46 = v44.invoke((Object)("Vortages Gap up > " + v45 + "%"), (Object)this);
                    ** if (v46 != var11_2) goto lbl452
lbl451:
                    // 1 sources

                    return var11_2;
lbl452:
                    // 1 sources

                    ** GOTO lbl462
                    {
                        case 27: {
                            lastCandleBefore = (OHLCV)this.L$3;
                            candle9_30_10_00 = (OHLCV)this.L$2;
                            candles30min4days = (List)this.L$1;
                            underlyingPrice = (Price)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v46 = $result;
lbl462:
                            // 2 sources

                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                            this.label = 28;
                            v47 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)2), (Object)this);
                            ** if (v47 != var11_2) goto lbl470
lbl469:
                            // 1 sources

                            return var11_2;
lbl470:
                            // 1 sources

                            ** GOTO lbl480
                        }
                        case 28: {
                            lastCandleBefore = (OHLCV)this.L$3;
                            candle9_30_10_00 = (OHLCV)this.L$2;
                            candles30min4days = (List)this.L$1;
                            underlyingPrice = (Price)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v47 = $result;
lbl480:
                            // 2 sources

                            var6_38 /* !! */  = Unit.INSTANCE;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                            this.L$4 = var6_38 /* !! */ ;
                            this.label = 29;
                            v48 = this.this$0.getFinishFct().invoke((Object)this);
                            if (v48 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl499
                        }
                        case 29: {
                            var6_38 /* !! */  = (Unit)this.L$4;
                            lastCandleBefore = (OHLCV)this.L$3;
                            candle9_30_10_00 = (OHLCV)this.L$2;
                            candles30min4days = (List)this.L$1;
                            underlyingPrice = (Price)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v48 = $result;
lbl499:
                            // 2 sources

                            return var6_38 /* !! */ ;
                        }
                    }
                }
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                this.L$2 = candle9_30_10_00;
                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                this.label = 30;
                v49 = this.this$0.getStepFct().invoke((Object)Boxing.boxInt((int)2), (Object)this);
                ** if (v49 != var11_2) goto lbl510
lbl509:
                // 1 sources

                return var11_2;
lbl510:
                // 1 sources

                ** GOTO lbl520
                {
                    case 30: {
                        lastCandleBefore = (OHLCV)this.L$3;
                        candle9_30_10_00 = (OHLCV)this.L$2;
                        candles30min4days = (List)this.L$1;
                        underlyingPrice = (Price)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v49 = $result;
lbl520:
                        // 2 sources

                        it = candle9_30_10_00;
                        $i$a$-let-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$1 = false;
                        if (it.getClose() == null || it.getOpen() == null) ** GOTO lbl-1000
                        v50 = it.getClose();
                        Intrinsics.checkNotNull((Object)v50);
                        v51 = it.getOpen();
                        Intrinsics.checkNotNull((Object)v51);
                        if (v50.compareTo(v51) > 0) {
                            v52 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v52 = false;
                        }
                        if (v52) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                        this.label = 31;
                        v53 = this.this$0.getDescriptionFct().invoke((Object)("Initial Balance " + TimezoneKt.getNewYorkTimezone() + " " + this.this$0.getIbTimeNY().getStart() + "-" + this.this$0.getIbTimeNY().getEndInclusive() + " (" + TimeZone.Companion.currentSystemDefault() + ": " + this.this$0.getIbTimeNY().getStart() + "-" + this.this$0.getIbTimeNY().getEndInclusive() + ") nicht positiv"), (Object)this);
                        ** if (v53 != var11_2) goto lbl541
lbl540:
                        // 1 sources

                        return var11_2;
lbl541:
                        // 1 sources

                        ** GOTO lbl551
                    }
                    case 31: {
                        lastCandleBefore = (OHLCV)this.L$3;
                        candle9_30_10_00 = (OHLCV)this.L$2;
                        candles30min4days = (List)this.L$1;
                        underlyingPrice = (Price)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v53 = $result;
lbl551:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                        this.label = 32;
                        v54 = this.this$0.getErrorFct().invoke((Object)Boxing.boxInt((int)3), (Object)this);
                        ** if (v54 != var11_2) goto lbl559
lbl558:
                        // 1 sources

                        return var11_2;
lbl559:
                        // 1 sources

                        ** GOTO lbl569
                    }
                    case 32: {
                        lastCandleBefore = (OHLCV)this.L$3;
                        candle9_30_10_00 = (OHLCV)this.L$2;
                        candles30min4days = (List)this.L$1;
                        underlyingPrice = (Price)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v54 = $result;
lbl569:
                        // 2 sources

                        var6_39 = Unit.INSTANCE;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                        this.L$4 = var6_39;
                        this.label = 33;
                        v55 = this.this$0.getFinishFct().invoke((Object)this);
                        if (v55 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl588
                    }
                    case 33: {
                        var6_39 = (Unit)this.L$4;
                        lastCandleBefore = (OHLCV)this.L$3;
                        candle9_30_10_00 = (OHLCV)this.L$2;
                        candles30min4days = (List)this.L$1;
                        underlyingPrice = (Price)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v55 = $result;
lbl588:
                        // 2 sources

                        return var6_39;
                    }
                }
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                this.label = 34;
                v56 = this.this$0.getStepFct().invoke((Object)Boxing.boxInt((int)3), (Object)this);
                ** if (v56 != var11_2) goto lbl598
lbl597:
                // 1 sources

                return var11_2;
lbl598:
                // 1 sources

                ** GOTO lbl608
                {
                    case 34: {
                        lastCandleBefore = (OHLCV)this.L$3;
                        candle9_30_10_00 = (OHLCV)this.L$2;
                        candles30min4days = (List)this.L$1;
                        underlyingPrice = (Price)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v56 = $result;
lbl608:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)underlyingPrice);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)candles30min4days);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)candle9_30_10_00);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)lastCandleBefore);
                        this.label = 35;
                        v57 = this.this$0.getDescriptionFct().invoke((Object)"PreCheck erfolgreich. Trade kann er\u00f6ffnet werden.", (Object)this);
                        ** if (v57 != var11_2) goto lbl616
lbl615:
                        // 1 sources

                        return var11_2;
lbl616:
                        // 1 sources

                        ** GOTO lbl626
                    }
                    case 35: {
                        lastCandleBefore = (OHLCV)this.L$3;
                        candle9_30_10_00 = (OHLCV)this.L$2;
                        candles30min4days = (List)this.L$1;
                        underlyingPrice = (Price)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v57 = $result;
lbl626:
                        // 2 sources

                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.label = 36;
                        v58 = this.this$0.getFinishFct().invoke((Object)this);
                        if (v58 == var11_2) {
                            return var11_2;
                        }
                        break;
                    }
                    case 36: {
                        ResultKt.throwOnFailure((Object)$result);
                        v58 = $result;
                        break;
                    }
                    case 37: {
                        var2_34 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v35 = $result;
lbl643:
                        // 2 sources

                        throw var2_34;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final <T> T invokeSuspend$previousOf(List<? extends T> $this$invokeSuspend_u24previousOf, T element) {
                return (T)CollectionsKt.getOrNull($this$invokeSuspend_u24previousOf, (int)($this$invokeSuspend_u24previousOf.indexOf(element) - 1));
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object placeOrder(int size, @Nullable String accountId, boolean transmit, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, size, accountId, transmit, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            Object L$10;
            Object L$11;
            Object L$12;
            Object L$13;
            double D$0;
            double D$1;
            int I$0;
            int label;
            final /* synthetic */ ZeroDTEOpeningPut20Strategy this$0;
            final /* synthetic */ int $size;
            final /* synthetic */ String $accountId;
            final /* synthetic */ boolean $transmit;
            {
                this.this$0 = $receiver;
                this.$size = $size;
                this.$accountId = $accountId;
                this.$transmit = $transmit;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

