/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot.renderer;

import com.xorrus.trading.lot.app.plot.ChartTheme;
import com.xorrus.trading.lot.app.plot.PnLDiagramState;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayout;
import com.xorrus.trading.lot.app.plot.renderer.PnLRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/xorrus/trading/lot/app/plot/renderer/SpotLineRenderer;", "Lcom/xorrus/trading/lot/app/plot/renderer/PnLRenderer;", "<init>", "()V", "render", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "Lcom/xorrus/trading/lot/app/plot/SkiaCanvas;", "state", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "laboftrades-app"})
public final class SpotLineRenderer
implements PnLRenderer {
    @Override
    public void render(@NotNull Canvas canvas, @NotNull PnLDiagramState state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Double d = state.getData().getUnderlyingPrice();
        if (d == null) {
            return;
        }
        d.doubleValue();
        DiagramLayout layout = state.getLayout();
        ChartTheme theme = state.getTheme();
        float plotLeft = layout.getOriginX();
        float plotTop = 0.0f;
        float plotRight = state.getWidth();
        float plotBottom = layout.getOriginY();
        double range = ((Number)((Object)state.getXRange().getEndInclusive())).doubleValue() - ((Number)((Object)state.getXRange().getStart())).doubleValue();
        float ratio = (float)((state.getData().getUnderlyingPrice() - ((Number)((Object)state.getXRange().getStart())).doubleValue()) / range);
        float x = plotLeft + ratio * (plotRight - plotLeft);
        canvas.drawLine(x, plotTop, x, plotBottom, theme.getSpotLinePaint());
    }
}

