/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot;

import com.xorrus.trading.lot.app.plot.SkiaNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Color;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.Typeface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012H\u0016JT\u0010&\u001a\u00020 2\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002JL\u0010/\u001a\u00020 2\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010'\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u000bH\u0002J,\u00103\u001a\u00020 2\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002J \u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u000bH\u0002J\u0018\u00108\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005H\u0002R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/xorrus/trading/lot/app/plot/BinomialDistributionChartNode;", "Lcom/xorrus/trading/lot/app/plot/SkiaNode;", "<init>", "()V", "value", "", "trials", "getTrials", "()I", "setTrials", "(I)V", "", "probability", "getProbability", "()D", "setProbability", "(D)V", "padding", "", "topPadding", "bottomPadding", "barColor", "meanColor", "sigma1Color", "sigma2Color", "axisColor", "textColor", "backgroundColor", "labelFont", "Lorg/jetbrains/skia/Font;", "smallFont", "draw", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "Lcom/xorrus/trading/lot/app/plot/SkiaCanvas;", "width", "height", "drawSigmaLines", "chartLeft", "chartTop", "chartBottom", "chartWidth", "displayMin", "displayRange", "mean", "stdDev", "drawAxes", "chartRight", "displayMax", "maxProb", "drawLegend", "binomialPMF", "k", "n", "p", "logBinomialCoefficient", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nBinomialDistributionChartNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinomialDistributionChartNode.kt\ncom/xorrus/trading/lot/app/plot/BinomialDistributionChartNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n1#2:325\n1878#3,3:326\n*S KotlinDebug\n*F\n+ 1 BinomialDistributionChartNode.kt\ncom/xorrus/trading/lot/app/plot/BinomialDistributionChartNode\n*L\n104#1:326,3\n*E\n"})
public final class BinomialDistributionChartNode
extends SkiaNode {
    private int trials = 100;
    private double probability = 0.5;
    private final float padding;
    private final float topPadding;
    private final float bottomPadding;
    private final int barColor = Color.INSTANCE.makeRGB(70, 130, 180);
    private final int meanColor = Color.INSTANCE.makeRGB(100, 255, 100);
    private final int sigma1Color = Color.INSTANCE.makeRGB(255, 165, 0);
    private final int sigma2Color = Color.INSTANCE.makeRGB(255, 69, 0);
    private final int axisColor = Color.INSTANCE.makeRGB(200, 200, 200);
    private final int textColor = Color.INSTANCE.makeRGB(220, 220, 220);
    private final int backgroundColor = Color.INSTANCE.makeRGB(30, 30, 30);
    @NotNull
    private final Font labelFont;
    @NotNull
    private final Font smallFont;

    public BinomialDistributionChartNode() {
        this.padding = 60.0f;
        this.topPadding = 30.0f;
        this.bottomPadding = 50.0f;
        BinomialDistributionChartNode binomialDistributionChartNode = this;
        BinomialDistributionChartNode binomialDistributionChartNode2 = this;
        boolean bl = false;
        Typeface typeface = FontMgr.Companion.getDefault().matchFamilyStyle("Helvetica Neue", FontStyle.Companion.getNORMAL());
        if (typeface == null && (typeface = FontMgr.Companion.getDefault().matchFamilyStyle("Arial", FontStyle.Companion.getNORMAL())) == null) {
            typeface = FontMgr.Companion.getDefault().matchFamilyStyle(null, FontStyle.Companion.getNORMAL());
        }
        Typeface typeface2 = typeface;
        binomialDistributionChartNode2.labelFont = new Font(typeface2, 11.0f);
        BinomialDistributionChartNode $this$labelFont_u24lambda_u240 = this;
        binomialDistributionChartNode2 = this;
        boolean bl2 = false;
        Typeface typeface3 = FontMgr.Companion.getDefault().matchFamilyStyle("Helvetica Neue", FontStyle.Companion.getNORMAL());
        if (typeface3 == null && (typeface3 = FontMgr.Companion.getDefault().matchFamilyStyle("Arial", FontStyle.Companion.getNORMAL())) == null) {
            typeface3 = FontMgr.Companion.getDefault().matchFamilyStyle(null, FontStyle.Companion.getNORMAL());
        }
        typeface2 = typeface3;
        binomialDistributionChartNode2.smallFont = new Font(typeface2, 9.0f);
    }

    public final int getTrials() {
        return this.trials;
    }

    public final void setTrials(int value) {
        this.trials = RangesKt.coerceAtLeast((int)value, (int)1);
        this.repaint();
    }

    public final double getProbability() {
        return this.probability;
    }

    public final void setProbability(double value) {
        this.probability = RangesKt.coerceIn((double)value, (double)0.001, (double)0.999);
        this.repaint();
    }

    @Override
    public void draw(@NotNull Canvas canvas, float width, float height) {
        Pair it;
        Double d;
        Iterator iterator;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Paint $this$draw_u24lambda_u240 = paint = new Paint();
        boolean bl = false;
        $this$draw_u24lambda_u240.setColor(this.backgroundColor);
        Paint bgPaint = paint;
        canvas.drawRect(new Rect(0.0f, 0.0f, width, height), bgPaint);
        float chartLeft = this.padding;
        float chartRight = width - this.padding / (float)2;
        float chartTop = this.topPadding;
        float chartBottom = height - this.bottomPadding;
        float chartWidth = chartRight - chartLeft;
        float chartHeight = chartBottom - chartTop;
        if (chartWidth <= 0.0f || chartHeight <= 0.0f) {
            return;
        }
        double mean = (double)this.trials * this.probability;
        double stdDev = Math.sqrt((double)this.trials * this.probability * (1.0 - this.probability));
        int displayMin = Math.max(0, (int)(mean - (double)4 * stdDev));
        int displayMax = Math.min(this.trials, (int)(mean + (double)4 * stdDev));
        int displayRange = displayMax - displayMin + 1;
        List probabilities = new ArrayList();
        int k = displayMin;
        if (k <= displayMax) {
            while (true) {
                double prob = this.binomialPMF(k, this.trials, this.probability);
                probabilities.add(TuplesKt.to((Object)k, (Object)prob));
                if (k == displayMax) break;
                ++k;
            }
        }
        if (!(iterator = ((Iterable)probabilities).iterator()).hasNext()) {
            d = null;
        } else {
            it = (Pair)iterator.next();
            boolean bl2 = false;
            double d2 = ((Number)it.getSecond()).doubleValue();
            while (iterator.hasNext()) {
                Pair it2 = (Pair)iterator.next();
                $i$a$-maxOfOrNull-BinomialDistributionChartNode$draw$maxProb$1 = false;
                double d3 = ((Number)it2.getSecond()).doubleValue();
                d2 = Math.max(d2, d3);
            }
            d = d2;
        }
        double maxProb = d != null ? d : 1.0;
        float barWidth = chartWidth / (float)displayRange;
        float actualBarWidth = RangesKt.coerceAtMost((float)(barWidth * 0.8f), (float)30.0f);
        Pair $this$draw_u24lambda_u242 = it = new Paint();
        boolean bl3 = false;
        $this$draw_u24lambda_u242.setColor(this.barColor);
        $this$draw_u24lambda_u242.setAntiAlias(true);
        Pair barPaint = it;
        Iterable $this$forEachIndexed$iv = probabilities;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int i = n;
            boolean bl4 = false;
            int k2 = ((Number)pair.component1()).intValue();
            double prob = ((Number)pair.component2()).doubleValue();
            float barHeight = (float)(prob / maxProb * (double)chartHeight);
            float barCenterX = chartLeft + ((float)i + 0.5f) * barWidth;
            float barLeft = barCenterX - actualBarWidth / (float)2;
            float barTop = chartBottom - barHeight;
            canvas.drawRect(new Rect(barLeft, barTop, barLeft + actualBarWidth, chartBottom), (Paint)barPaint);
        }
        this.drawSigmaLines(canvas, chartLeft, chartTop, chartBottom, chartWidth, displayMin, displayRange, mean, stdDev);
        this.drawAxes(canvas, chartLeft, chartRight, chartTop, chartBottom, displayMin, displayMax, maxProb);
        this.drawLegend(canvas, width, mean, stdDev);
    }

    private final void drawSigmaLines(Canvas canvas, float chartLeft, float chartTop, float chartBottom, float chartWidth, int displayMin, int displayRange, double mean, double stdDev) {
        Paint paint;
        Paint paint2;
        Paint $this$drawSigmaLines_u24lambda_u240 = paint2 = new Paint();
        boolean bl = false;
        $this$drawSigmaLines_u24lambda_u240.setColor(this.textColor);
        $this$drawSigmaLines_u24lambda_u240.setAntiAlias(true);
        Paint labelPaint = paint2;
        float xMean = BinomialDistributionChartNode.drawSigmaLines$kToScreen(displayMin, displayRange, chartLeft, chartWidth, mean);
        Paint $this$drawSigmaLines_u24lambda_u241 = bl = new Paint();
        boolean bl2 = false;
        $this$drawSigmaLines_u24lambda_u241.setColor(this.meanColor);
        $this$drawSigmaLines_u24lambda_u241.setStrokeWidth(2.0f);
        $this$drawSigmaLines_u24lambda_u241.setAntiAlias(true);
        Paint meanPaint = bl;
        canvas.drawLine(xMean, chartTop, xMean, chartBottom, meanPaint);
        Paint $this$drawSigmaLines_u24lambda_u242 = $this$drawSigmaLines_u24lambda_u241 = new Paint();
        boolean bl3 = false;
        $this$drawSigmaLines_u24lambda_u242.setColor(this.sigma1Color);
        $this$drawSigmaLines_u24lambda_u242.setStrokeWidth(2.0f);
        $this$drawSigmaLines_u24lambda_u242.setAntiAlias(true);
        Paint sigma1Paint = $this$drawSigmaLines_u24lambda_u241;
        float x1SigmaLeft = BinomialDistributionChartNode.drawSigmaLines$kToScreen(displayMin, displayRange, chartLeft, chartWidth, mean - stdDev);
        float x1SigmaRight = BinomialDistributionChartNode.drawSigmaLines$kToScreen(displayMin, displayRange, chartLeft, chartWidth, mean + stdDev);
        if (mean - stdDev >= (double)displayMin) {
            canvas.drawLine(x1SigmaLeft, chartTop, x1SigmaLeft, chartBottom, sigma1Paint);
        }
        if (mean + stdDev <= (double)(displayMin + displayRange)) {
            canvas.drawLine(x1SigmaRight, chartTop, x1SigmaRight, chartBottom, sigma1Paint);
        }
        Paint $this$drawSigmaLines_u24lambda_u243 = paint = new Paint();
        boolean bl4 = false;
        $this$drawSigmaLines_u24lambda_u243.setColor(this.sigma2Color);
        $this$drawSigmaLines_u24lambda_u243.setStrokeWidth(2.0f);
        $this$drawSigmaLines_u24lambda_u243.setAntiAlias(true);
        Paint sigma2Paint = paint;
        float x2SigmaLeft = BinomialDistributionChartNode.drawSigmaLines$kToScreen(displayMin, displayRange, chartLeft, chartWidth, mean - (double)2 * stdDev);
        float x2SigmaRight = BinomialDistributionChartNode.drawSigmaLines$kToScreen(displayMin, displayRange, chartLeft, chartWidth, mean + (double)2 * stdDev);
        if (mean - (double)2 * stdDev >= (double)displayMin) {
            canvas.drawLine(x2SigmaLeft, chartTop, x2SigmaLeft, chartBottom, sigma2Paint);
        }
        if (mean + (double)2 * stdDev <= (double)(displayMin + displayRange)) {
            canvas.drawLine(x2SigmaRight, chartTop, x2SigmaRight, chartBottom, sigma2Paint);
        }
        float labelY = chartBottom + 12.0f;
        canvas.drawString("\u03bc", xMean - 4.0f, labelY, this.smallFont, labelPaint);
    }

    private final void drawAxes(Canvas canvas, float chartLeft, float chartRight, float chartTop, float chartBottom, int displayMin, int displayMax, double maxProb) {
        int tickStep;
        Paint paint;
        Paint $this$drawAxes_u24lambda_u240 = paint = new Paint();
        boolean bl = false;
        $this$drawAxes_u24lambda_u240.setColor(this.axisColor);
        $this$drawAxes_u24lambda_u240.setStrokeWidth(1.0f);
        $this$drawAxes_u24lambda_u240.setAntiAlias(true);
        Paint axisPaint = paint;
        Paint $this$drawAxes_u24lambda_u241 = $this$drawAxes_u24lambda_u240 = new Paint();
        boolean bl2 = false;
        $this$drawAxes_u24lambda_u241.setColor(this.textColor);
        $this$drawAxes_u24lambda_u241.setAntiAlias(true);
        Paint labelPaint = $this$drawAxes_u24lambda_u240;
        canvas.drawLine(chartLeft, chartBottom, chartRight, chartBottom, axisPaint);
        canvas.drawLine(chartLeft, chartTop, chartLeft, chartBottom, axisPaint);
        float chartWidth = chartRight - chartLeft;
        int displayRange = displayMax - displayMin + 1;
        int n = displayRange <= 20 ? 1 : (displayRange <= 50 ? 5 : (displayRange <= 100 ? 10 : (tickStep = displayRange <= 200 ? 20 : 50)));
        if (tickStep <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + tickStep + ".");
        }
        int k = displayMin;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)displayMin, (int)displayMax, (int)tickStep);
        if (k <= n2) {
            while (true) {
                float relativePos = ((float)(k - displayMin) + 0.5f) / (float)displayRange;
                float x = chartLeft + relativePos * chartWidth;
                canvas.drawLine(x, chartBottom, x, chartBottom + 5.0f, axisPaint);
                String valueStr = String.valueOf(k);
                Rect textBounds = this.smallFont.measureText(valueStr, labelPaint);
                canvas.drawString(valueStr, x - textBounds.getWidth() / (float)2, chartBottom + 20.0f, this.smallFont, labelPaint);
                if (k == n2) break;
                k += tickStep;
            }
        }
        int yTickCount = 4;
        int i = 0;
        while (true) {
            String valueStr;
            float y = chartBottom - (float)i * (chartBottom - chartTop) / (float)yTickCount;
            double prob = (double)i * maxProb / (double)yTickCount;
            canvas.drawLine(chartLeft - 5.0f, y, chartLeft, y, axisPaint);
            String string = "%.1f%%";
            Object[] objectArray = new Object[]{prob * (double)100};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
            Rect textBounds = this.smallFont.measureText(valueStr, labelPaint);
            canvas.drawString(valueStr, chartLeft - textBounds.getWidth() - 8.0f, y + 4.0f, this.smallFont, labelPaint);
            if (i == yTickCount) break;
            ++i;
        }
        canvas.drawString("Anzahl Erfolge (k)", chartLeft + chartWidth / (float)2 - 40.0f, chartBottom + 38.0f, this.labelFont, labelPaint);
    }

    private final void drawLegend(Canvas canvas, float width, double mean, double stdDev) {
        Paint paint;
        Paint paint2;
        Paint $this$drawLegend_u24lambda_u240 = paint2 = new Paint();
        boolean bl = false;
        $this$drawLegend_u24lambda_u240.setColor(this.textColor);
        $this$drawLegend_u24lambda_u240.setAntiAlias(true);
        Paint legendPaint = paint2;
        float y = 15.0f;
        float x = 10.0f;
        String string = "\u03bc = %.2f, \u03c3 = %.2f";
        Object[] objectArray = new Object[]{mean, stdDev};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String statsText = string2;
        canvas.drawString(statsText, x, y, this.labelFont, legendPaint);
        String $this$drawLegend_u24lambda_u241 = string = new Paint();
        boolean bl2 = false;
        $this$drawLegend_u24lambda_u241.setColor(this.meanColor);
        String meanPaint = string;
        canvas.drawRect(new Rect(x += 150.0f, y - 8.0f, x + 12.0f, y), (Paint)meanPaint);
        canvas.drawString("\u03bc", x += 16.0f, y, this.labelFont, legendPaint);
        String $this$drawLegend_u24lambda_u242 = $this$drawLegend_u24lambda_u241 = new Paint();
        boolean bl3 = false;
        $this$drawLegend_u24lambda_u242.setColor(this.sigma1Color);
        String sigma1Paint = $this$drawLegend_u24lambda_u241;
        canvas.drawRect(new Rect(x += 30.0f, y - 8.0f, x + 12.0f, y), (Paint)sigma1Paint);
        canvas.drawString("\u00b11\u03c3 (68.3%)", x += 16.0f, y, this.labelFont, legendPaint);
        Paint $this$drawLegend_u24lambda_u243 = paint = new Paint();
        boolean bl4 = false;
        $this$drawLegend_u24lambda_u243.setColor(this.sigma2Color);
        Paint sigma2Paint = paint;
        canvas.drawRect(new Rect(x += 80.0f, y - 8.0f, x + 12.0f, y), sigma2Paint);
        canvas.drawString("\u00b12\u03c3 (95.4%)", x += 16.0f, y, this.labelFont, legendPaint);
    }

    private final double binomialPMF(int k, int n, double p) {
        if (k < 0 || k > n) {
            return 0.0;
        }
        double logCoeff = this.logBinomialCoefficient(n, k);
        double logProb = logCoeff + (double)k * Math.log(p) + (double)(n - k) * Math.log(1.0 - p);
        return Math.exp(logProb);
    }

    private final double logBinomialCoefficient(int n, int k) {
        if (k == 0 || k == n) {
            return 0.0;
        }
        if (k == 1 || k == n - 1) {
            return Math.log(n);
        }
        double result = 0.0;
        for (int i = 0; i < k; ++i) {
            result += Math.log(n - i) - Math.log(i + 1);
        }
        return result;
    }

    private static final float drawSigmaLines$kToScreen(int $displayMin, int $displayRange, float $chartLeft, float $chartWidth, double k) {
        double relativePos = (k - (double)$displayMin + 0.5) / (double)$displayRange;
        return $chartLeft + (float)(relativePos * (double)$chartWidth);
    }
}

