/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot.renderer;

import com.xorrus.trading.lot.app.plot.ChartTheme;
import com.xorrus.trading.lot.app.plot.PnLDiagramState;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayout;
import com.xorrus.trading.lot.app.plot.layout.XAxisLayout;
import com.xorrus.trading.lot.app.plot.renderer.PnLRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/xorrus/trading/lot/app/plot/renderer/XAxisRenderer;", "Lcom/xorrus/trading/lot/app/plot/renderer/PnLRenderer;", "<init>", "()V", "render", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "Lcom/xorrus/trading/lot/app/plot/SkiaCanvas;", "state", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nXAxisRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XAxisRenderer.kt\ncom/xorrus/trading/lot/app/plot/renderer/XAxisRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1869#2,2:54\n*S KotlinDebug\n*F\n+ 1 XAxisRenderer.kt\ncom/xorrus/trading/lot/app/plot/renderer/XAxisRenderer\n*L\n38#1:54,2\n*E\n"})
public final class XAxisRenderer
implements PnLRenderer {
    @Override
    public void render(@NotNull Canvas canvas, @NotNull PnLDiagramState state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ChartTheme theme = state.getTheme();
        DiagramLayout layout = state.getLayout();
        XAxisLayout xLayout = layout.getXAxis();
        float axisY = layout.getOriginY();
        float axisLeft = layout.getOriginX();
        float axisRight = state.getWidth();
        canvas.drawLine(axisLeft, axisY, axisRight, axisY, theme.getAxisPaint());
        Font font = theme.getAxisLabelFont();
        FontMetrics metrics = font.getMetrics();
        float plotWidth = state.getWidth() - axisLeft;
        float tickLength = theme.getTickLength();
        ClosedRange<Double> xRange = state.getXRange();
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)xLayout.getTicks(), (Iterable)xLayout.getLabels());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            double value = ((Number)pair.component1()).doubleValue();
            String label = (String)pair.component2();
            float x = XAxisRenderer.render$mapValueToX(xRange, axisLeft, plotWidth, value);
            canvas.drawLine(x, axisY, x, axisY + tickLength, theme.getAxisPaint());
            float textWidth = font.measureText(label, theme.getAxisLabelPaint()).getWidth();
            float labelX = x - textWidth / 2.0f;
            float baselineY = state.getHeight() - theme.getAxisLabelPadding() - metrics.getDescent();
            canvas.drawString(label, labelX, baselineY, font, theme.getAxisLabelPaint());
        }
    }

    private static final float render$mapValueToX(ClosedRange<Double> xRange, float axisLeft, float plotWidth, double value) {
        float ratio = (float)((value - ((Number)((Object)xRange.getStart())).doubleValue()) / (((Number)((Object)xRange.getEndInclusive())).doubleValue() - ((Number)((Object)xRange.getStart())).doubleValue()));
        return axisLeft + ratio * plotWidth;
    }
}

