/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot.renderer;

import com.xorrus.trading.lot.app.plot.ChartTheme;
import com.xorrus.trading.lot.app.plot.CursorInfo;
import com.xorrus.trading.lot.app.plot.PnLDiagramState;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayout;
import com.xorrus.trading.lot.app.plot.renderer.PnLRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Rect;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0010\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002J\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/xorrus/trading/lot/app/plot/renderer/CrosshairRenderer;", "Lcom/xorrus/trading/lot/app/plot/renderer/PnLRenderer;", "<init>", "()V", "render", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "Lcom/xorrus/trading/lot/app/plot/SkiaCanvas;", "state", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "drawXAxisLabel", "centerX", "", "label", "", "drawYAxisLabel", "centerY", "formatValue", "value", "", "ticks", "", "inferStep", "(Ljava/util/List;)Ljava/lang/Double;", "decimalsForStep", "", "step", "(Ljava/lang/Double;)I", "laboftrades-app"})
public final class CrosshairRenderer
implements PnLRenderer {
    @Override
    public void render(@NotNull Canvas canvas, @NotNull PnLDiagramState state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        CursorInfo cursorInfo = state.getCursor();
        if (cursorInfo == null) {
            return;
        }
        CursorInfo cursor = cursorInfo;
        ChartTheme theme = state.getTheme();
        DiagramLayout layout = state.getLayout();
        float plotLeft = layout.getOriginX();
        float plotRight = state.getWidth();
        float plotTop = 0.0f;
        float plotBottom = layout.getOriginY();
        Paint paint = theme.getCrosshairPaint();
        canvas.drawLine(cursor.getPixelX(), plotTop, cursor.getPixelX(), plotBottom, paint);
        canvas.drawLine(plotLeft, cursor.getPixelY(), plotRight, cursor.getPixelY(), paint);
        String xLabel = this.formatValue(cursor.getDataX(), layout.getXAxis().getTicks());
        String yLabel = this.formatValue(cursor.getDataY(), layout.getYAxis().getTicks());
        this.drawXAxisLabel(canvas, state, cursor.getPixelX(), xLabel);
        this.drawYAxisLabel(canvas, state, cursor.getPixelY(), yLabel);
    }

    private final void drawXAxisLabel(Canvas canvas, PnLDiagramState state, float centerX, String label) {
        ChartTheme theme = state.getTheme();
        Font font = theme.getAxisLabelFont();
        FontMetrics metrics = font.getMetrics();
        float padding = theme.getCrosshairLabelPadding();
        Paint textPaint = theme.getAxisLabelPaint();
        Paint bgPaint = theme.getCrosshairLabelBackgroundPaint();
        float textWidth = font.measureText(label, textPaint).getWidth();
        float labelWidth = textWidth + 2.0f * padding;
        float plotLeft = state.getLayout().getOriginX();
        float plotRight = state.getWidth();
        float rectLeft = centerX - labelWidth / 2.0f;
        float rectRight = (rectLeft = RangesKt.coerceIn((float)rectLeft, (float)plotLeft, (float)(plotRight - labelWidth))) + labelWidth;
        if (rectRight <= rectLeft) {
            return;
        }
        float baselineY = state.getHeight() - theme.getAxisLabelPadding() - metrics.getDescent();
        float textTop = baselineY + metrics.getAscent();
        float rectTop = textTop - padding;
        float rectBottom = baselineY + metrics.getDescent() + padding;
        if (rectBottom > state.getHeight()) {
            float delta = rectBottom - state.getHeight();
            rectTop -= delta;
            rectBottom -= delta;
        }
        canvas.drawRect(new Rect(rectLeft, rectTop, rectRight, rectBottom), bgPaint);
        float textX = rectLeft + padding;
        canvas.drawString(label, textX, baselineY, font, textPaint);
    }

    private final void drawYAxisLabel(Canvas canvas, PnLDiagramState state, float centerY, String label) {
        ChartTheme theme = state.getTheme();
        Font font = theme.getAxisLabelFont();
        FontMetrics metrics = font.getMetrics();
        float padding = theme.getCrosshairLabelPadding();
        Paint textPaint = theme.getAxisLabelPaint();
        Paint bgPaint = theme.getCrosshairLabelBackgroundPaint();
        float textWidth = font.measureText(label, textPaint).getWidth();
        float labelWidth = textWidth + 2.0f * padding;
        float labelHeight = metrics.getDescent() - metrics.getAscent() + 2.0f * padding;
        float rectRight = state.getLayout().getOriginX() - theme.getTickLength() - theme.getAxisLabelPadding();
        float rectLeft = rectRight - labelWidth;
        if (rectLeft < 0.0f) {
            rectLeft = 0.0f;
        }
        if (rectRight <= rectLeft) {
            return;
        }
        float rectTop = centerY - labelHeight / 2.0f;
        rectTop = RangesKt.coerceIn((float)rectTop, (float)0.0f, (float)(state.getHeight() - labelHeight));
        float rectBottom = rectTop + labelHeight;
        float textX = rectLeft + padding;
        float textTop = rectTop + padding;
        float baselineY = textTop - metrics.getAscent();
        canvas.drawRect(new Rect(rectLeft, rectTop, rectRight, rectBottom), bgPaint);
        canvas.drawString(label, textX, baselineY, font, textPaint);
    }

    private final String formatValue(double value, List<Double> ticks) {
        double sanitized = Math.abs(value) < 5.0E-10 ? 0.0 : value;
        Double step = this.inferStep(ticks);
        int decimals = this.decimalsForStep(step);
        Locale locale = Locale.US;
        String string = "%." + decimals + "f";
        Object[] objectArray = new Object[]{sanitized};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final Double inferStep(List<Double> ticks) {
        if (ticks.size() < 2) {
            return null;
        }
        double minStep = Double.MAX_VALUE;
        int n = ticks.size() - 1;
        for (int i = 0; i < n; ++i) {
            double diff = Math.abs(((Number)ticks.get(i + 1)).doubleValue() - ((Number)ticks.get(i)).doubleValue());
            if (!(diff > 0.0) || !(diff < minStep)) continue;
            minStep = diff;
        }
        return minStep == Double.MAX_VALUE ? null : Double.valueOf(minStep);
    }

    private final int decimalsForStep(Double step) {
        int decimals;
        Double d = step;
        if (d == null) {
            return 2;
        }
        double value = d;
        if (!(Math.abs(value) <= Double.MAX_VALUE) || value == 0.0) {
            return 2;
        }
        double scaled = value;
        for (decimals = 0; decimals < 6 && Math.abs(scaled - (double)MathKt.roundToLong((double)scaled)) > 1.0E-9; ++decimals) {
            scaled *= 10.0;
        }
        return decimals;
    }
}

