/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot;

import com.xorrus.trading.lot.app.plot.ChartTheme;
import com.xorrus.trading.lot.app.plot.CursorPixels;
import com.xorrus.trading.lot.app.plot.PnLCalculator;
import com.xorrus.trading.lot.app.plot.PnLDiagramData;
import com.xorrus.trading.lot.app.plot.PnLDiagramState;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ&\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bJ\u001e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u001e\u0010*\u001a\u00020\"2\u0006\u0010(\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bJ\u0006\u0010,\u001a\u00020\"J\u0006\u0010-\u001a\u00020\"J\u0016\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bJ\u0006\u00101\u001a\u00020\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/xorrus/trading/lot/app/plot/PnLViewModel;", "", "data", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;", "theme", "Lcom/xorrus/trading/lot/app/plot/ChartTheme;", "xRange", "Lkotlin/ranges/ClosedRange;", "", "yRange", "<init>", "(Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;Lcom/xorrus/trading/lot/app/plot/ChartTheme;Lkotlin/ranges/ClosedRange;Lkotlin/ranges/ClosedRange;)V", "getData", "()Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;", "setData", "(Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;)V", "getTheme", "()Lcom/xorrus/trading/lot/app/plot/ChartTheme;", "setTheme", "(Lcom/xorrus/trading/lot/app/plot/ChartTheme;)V", "getXRange", "()Lkotlin/ranges/ClosedRange;", "setXRange", "(Lkotlin/ranges/ClosedRange;)V", "getYRange", "setYRange", "cursorPixels", "Lcom/xorrus/trading/lot/app/plot/CursorPixels;", "createState", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "width", "", "height", "pan", "", "dxPixels", "dyPixels", "totalWidth", "totalHeight", "zoomX", "factor", "mouseX", "zoomY", "mouseY", "resetX", "resetY", "updateCursor", "x", "y", "clearCursor", "laboftrades-app"})
public final class PnLViewModel {
    @NotNull
    private PnLDiagramData data;
    @NotNull
    private ChartTheme theme;
    @Nullable
    private ClosedRange<Double> xRange;
    @Nullable
    private ClosedRange<Double> yRange;
    @Nullable
    private CursorPixels cursorPixels;

    public PnLViewModel(@NotNull PnLDiagramData data, @NotNull ChartTheme theme, @Nullable ClosedRange<Double> xRange, @Nullable ClosedRange<Double> yRange) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.data = data;
        this.theme = theme;
        this.xRange = xRange;
        this.yRange = yRange;
    }

    public /* synthetic */ PnLViewModel(PnLDiagramData pnLDiagramData, ChartTheme chartTheme, ClosedRange closedRange, ClosedRange closedRange2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chartTheme = new ChartTheme(0, null, null, null, 0.0f, 0.0f, 0.0f, null, null, null, null, 0.0f, 4095, null);
        }
        if ((n & 4) != 0) {
            closedRange = null;
        }
        if ((n & 8) != 0) {
            closedRange2 = null;
        }
        this(pnLDiagramData, chartTheme, (ClosedRange<Double>)closedRange, (ClosedRange<Double>)closedRange2);
    }

    @NotNull
    public final PnLDiagramData getData() {
        return this.data;
    }

    public final void setData(@NotNull PnLDiagramData pnLDiagramData) {
        Intrinsics.checkNotNullParameter((Object)pnLDiagramData, (String)"<set-?>");
        this.data = pnLDiagramData;
    }

    @NotNull
    public final ChartTheme getTheme() {
        return this.theme;
    }

    public final void setTheme(@NotNull ChartTheme chartTheme) {
        Intrinsics.checkNotNullParameter((Object)chartTheme, (String)"<set-?>");
        this.theme = chartTheme;
    }

    @Nullable
    public final ClosedRange<Double> getXRange() {
        return this.xRange;
    }

    public final void setXRange(@Nullable ClosedRange<Double> closedRange) {
        this.xRange = closedRange;
    }

    @Nullable
    public final ClosedRange<Double> getYRange() {
        return this.yRange;
    }

    public final void setYRange(@Nullable ClosedRange<Double> closedRange) {
        this.yRange = closedRange;
    }

    @NotNull
    public final PnLDiagramState createState(float width, float height) {
        PnLDiagramData pnLDiagramData = this.data;
        ChartTheme chartTheme = this.theme;
        ClosedRange<Double> closedRange = this.xRange;
        ClosedRange<Double> closedRange2 = this.yRange;
        CursorPixels cursorPixels = this.cursorPixels;
        return new PnLDiagramState(pnLDiagramData, closedRange, closedRange2, chartTheme, width, height, cursorPixels);
    }

    public final void pan(double dxPixels, double dyPixels, double totalWidth, double totalHeight) {
        ClosedRange<Double> closedRange;
        ClosedRange<Double> currentXRange;
        ClosedRange<Double> closedRange2 = this.xRange;
        if (closedRange2 == null) {
            closedRange2 = currentXRange = PnLCalculator.INSTANCE.computeAutoXRange(this.data);
        }
        if ((closedRange = this.yRange) == null) {
            closedRange = PnLCalculator.INSTANCE.estimatePnLRange(this.data, currentXRange);
        }
        ClosedRange<Double> currentYRange = closedRange;
        double xSpan = ((Number)((Object)currentXRange.getEndInclusive())).doubleValue() - ((Number)((Object)currentXRange.getStart())).doubleValue();
        double ySpan = ((Number)((Object)currentYRange.getEndInclusive())).doubleValue() - ((Number)((Object)currentYRange.getStart())).doubleValue();
        double dxValue = dxPixels / totalWidth * xSpan;
        double dyValue = dyPixels / totalHeight * ySpan;
        this.xRange = (ClosedRange)RangesKt.rangeTo((double)(((Number)((Object)currentXRange.getStart())).doubleValue() - dxValue), (double)(((Number)((Object)currentXRange.getEndInclusive())).doubleValue() - dxValue));
        this.yRange = (ClosedRange)RangesKt.rangeTo((double)(((Number)((Object)currentYRange.getStart())).doubleValue() + dyValue), (double)(((Number)((Object)currentYRange.getEndInclusive())).doubleValue() + dyValue));
    }

    public final void zoomX(double factor, double mouseX, double width) {
        ClosedRange<Double> closedRange = this.xRange;
        if (closedRange == null) {
            closedRange = PnLCalculator.INSTANCE.computeAutoXRange(this.data);
        }
        ClosedRange<Double> currentXRange = closedRange;
        double relativeMousePos = RangesKt.coerceIn((double)(mouseX / width), (double)0.0, (double)1.0);
        double mouseDataX = ((Number)((Object)currentXRange.getStart())).doubleValue() + relativeMousePos * (((Number)((Object)currentXRange.getEndInclusive())).doubleValue() - ((Number)((Object)currentXRange.getStart())).doubleValue());
        double span = (((Number)((Object)currentXRange.getEndInclusive())).doubleValue() - ((Number)((Object)currentXRange.getStart())).doubleValue()) / factor;
        double newStart = mouseDataX - relativeMousePos * span;
        double newEnd = mouseDataX + (1.0 - relativeMousePos) * span;
        this.xRange = (ClosedRange)RangesKt.rangeTo((double)newStart, (double)newEnd);
    }

    public final void zoomY(double factor, double mouseY, double height) {
        ClosedRange<Double> closedRange;
        ClosedRange<Double> currentXRange;
        ClosedRange<Double> closedRange2 = this.xRange;
        if (closedRange2 == null) {
            closedRange2 = currentXRange = PnLCalculator.INSTANCE.computeAutoXRange(this.data);
        }
        if ((closedRange = this.yRange) == null) {
            closedRange = PnLCalculator.INSTANCE.estimatePnLRange(this.data, currentXRange);
        }
        ClosedRange<Double> currentYRange = closedRange;
        double relativeMousePos = RangesKt.coerceIn((double)(mouseY / height), (double)0.0, (double)1.0);
        double mouseDataY = ((Number)((Object)currentYRange.getEndInclusive())).doubleValue() - relativeMousePos * (((Number)((Object)currentYRange.getEndInclusive())).doubleValue() - ((Number)((Object)currentYRange.getStart())).doubleValue());
        double span = (((Number)((Object)currentYRange.getEndInclusive())).doubleValue() - ((Number)((Object)currentYRange.getStart())).doubleValue()) / factor;
        double newEnd = mouseDataY + relativeMousePos * span;
        double newStart = mouseDataY - (1.0 - relativeMousePos) * span;
        this.yRange = (ClosedRange)RangesKt.rangeTo((double)newStart, (double)newEnd);
    }

    public final void resetX() {
        this.xRange = null;
    }

    public final void resetY() {
        this.yRange = null;
    }

    public final void updateCursor(double x, double y) {
        this.cursorPixels = new CursorPixels(x, y);
    }

    public final void clearCursor() {
        this.cursorPixels = null;
    }
}

