/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot.interaction;

import com.xorrus.trading.lot.app.plot.PnLDiagramState;
import com.xorrus.trading.lot.app.plot.interaction.CursorExitEvent;
import com.xorrus.trading.lot.app.plot.interaction.CursorMoveEvent;
import com.xorrus.trading.lot.app.plot.interaction.InteractionEvent;
import com.xorrus.trading.lot.app.plot.interaction.PanEvent;
import com.xorrus.trading.lot.app.plot.interaction.ResetZoomXEvent;
import com.xorrus.trading.lot.app.plot.interaction.ResetZoomYEvent;
import com.xorrus.trading.lot.app.plot.interaction.ZoomXEvent;
import com.xorrus.trading.lot.app.plot.interaction.ZoomYEvent;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayout;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001\u001aB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/xorrus/trading/lot/app/plot/interaction/DiagramMouseController;", "", "node", "Ljavafx/scene/Node;", "getState", "Lkotlin/Function0;", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "onEvent", "Lkotlin/Function1;", "Lcom/xorrus/trading/lot/app/plot/interaction/InteractionEvent;", "", "<init>", "(Ljavafx/scene/Node;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "mode", "Lcom/xorrus/trading/lot/app/plot/interaction/DiagramMouseController$Mode;", "dragStartX", "", "Ljava/lang/Double;", "dragStartY", "hitZoneTolerance", "lastCursorZone", "detectModeAt", "x", "y", "computeZoomFactor", "deltaPixels", "Mode", "laboftrades-app"})
public final class DiagramMouseController {
    @NotNull
    private final Node node;
    @NotNull
    private final Function0<PnLDiagramState> getState;
    @NotNull
    private final Function1<InteractionEvent, Unit> onEvent;
    @NotNull
    private Mode mode;
    @Nullable
    private Double dragStartX;
    @Nullable
    private Double dragStartY;
    private final double hitZoneTolerance;
    @NotNull
    private Mode lastCursorZone;

    public DiagramMouseController(@NotNull Node node, @NotNull Function0<PnLDiagramState> getState, @NotNull Function1<? super InteractionEvent, Unit> onEvent) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(getState, (String)"getState");
        Intrinsics.checkNotNullParameter(onEvent, (String)"onEvent");
        this.node = node;
        this.getState = getState;
        this.onEvent = onEvent;
        this.mode = Mode.NONE;
        this.hitZoneTolerance = 8.0;
        this.lastCursorZone = Mode.NONE;
        this.node.setOnMouseMoved(new EventHandler(){

            public final void handle(MouseEvent e) {
                Mode newZone;
                PnLDiagramState state = (PnLDiagramState)getState.invoke();
                DiagramLayout layout = state.getLayout();
                double x = e.getX();
                double y = e.getY();
                boolean zoomYZone = x < (double)layout.getOriginX() + hitZoneTolerance;
                boolean zoomXZone = y > (double)layout.getOriginY() - hitZoneTolerance;
                Mode mode = zoomYZone ? Mode.ZOOM_Y : (newZone = zoomXZone ? Mode.ZOOM_X : Mode.PAN);
                if (newZone != lastCursorZone) {
                    lastCursorZone = newZone;
                    Node node = node;
                    node.setCursor(switch (WhenMappings.$EnumSwitchMapping$0[newZone.ordinal()]) {
                        case 1 -> Cursor.V_RESIZE;
                        case 2 -> Cursor.H_RESIZE;
                        case 3 -> Cursor.MOVE;
                        default -> Cursor.DEFAULT;
                    });
                }
                onEvent.invoke((Object)new CursorMoveEvent(x, y));
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Mode.values().length];
                    try {
                        nArray[Mode.ZOOM_Y.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Mode.ZOOM_X.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Mode.PAN.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        this.node.setOnMousePressed(new EventHandler(){

            public final void handle(MouseEvent e) {
                if (e.getButton() == MouseButton.PRIMARY) {
                    dragStartX = e.getX();
                    dragStartY = e.getY();
                    mode = this.detectModeAt(e.getX(), e.getY());
                }
            }
        });
        this.node.setOnMouseReleased(new EventHandler(){

            public final void handle(MouseEvent e) {
                if (e.getButton() == MouseButton.PRIMARY) {
                    dragStartX = null;
                    dragStartY = null;
                    mode = Mode.NONE;
                }
            }
        });
        this.node.setOnMouseDragged(new EventHandler(){

            public final void handle(MouseEvent e) {
                if (e.getButton() == MouseButton.PRIMARY) {
                    Double startX = dragStartX;
                    Double startY = dragStartY;
                    if (startX != null && startY != null) {
                        double dx = e.getX() - startX;
                        double dy = e.getY() - startY;
                        dragStartX = e.getX();
                        dragStartY = e.getY();
                        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                            case 1: {
                                onEvent.invoke((Object)new PanEvent(dx, dy, node.getBoundsInLocal().getWidth(), node.getBoundsInLocal().getHeight()));
                                break;
                            }
                            case 2: {
                                onEvent.invoke((Object)new ZoomXEvent(this.computeZoomFactor(dx), e.getX(), node.getBoundsInLocal().getWidth()));
                                break;
                            }
                            case 3: {
                                onEvent.invoke((Object)new ZoomYEvent(this.computeZoomFactor(-dy), e.getY(), node.getBoundsInLocal().getHeight()));
                            }
                        }
                    }
                }
                onEvent.invoke((Object)new CursorMoveEvent(e.getX(), e.getY()));
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Mode.values().length];
                    try {
                        nArray[Mode.PAN.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Mode.ZOOM_X.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Mode.ZOOM_Y.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        this.node.setOnMouseClicked(new EventHandler(){

            public final void handle(MouseEvent e) {
                if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2) {
                    Mode zone = this.detectModeAt(e.getX(), e.getY());
                    switch (WhenMappings.$EnumSwitchMapping$0[zone.ordinal()]) {
                        case 1: {
                            onEvent.invoke((Object)ResetZoomXEvent.INSTANCE);
                            break;
                        }
                        case 2: {
                            onEvent.invoke((Object)ResetZoomYEvent.INSTANCE);
                        }
                    }
                }
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Mode.values().length];
                    try {
                        nArray[Mode.ZOOM_X.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Mode.ZOOM_Y.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        this.node.setOnMouseExited(new EventHandler(){

            public final void handle(MouseEvent it) {
                lastCursorZone = Mode.NONE;
                node.setCursor(Cursor.DEFAULT);
                onEvent.invoke((Object)CursorExitEvent.INSTANCE);
            }
        });
    }

    private final Mode detectModeAt(double x, double y) {
        PnLDiagramState state = (PnLDiagramState)this.getState.invoke();
        DiagramLayout layout = state.getLayout();
        boolean zoomYZone = x < (double)layout.getOriginX() + this.hitZoneTolerance;
        boolean zoomXZone = y > (double)layout.getOriginY() - this.hitZoneTolerance;
        return zoomYZone ? Mode.ZOOM_Y : (zoomXZone ? Mode.ZOOM_X : Mode.PAN);
    }

    private final double computeZoomFactor(double deltaPixels) {
        double sensitivity = 0.005;
        double factor = 1.0 + deltaPixels * sensitivity;
        return RangesKt.coerceIn((double)factor, (double)0.2, (double)5.0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/xorrus/trading/lot/app/plot/interaction/DiagramMouseController$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "PAN", "ZOOM_X", "ZOOM_Y", "laboftrades-app"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NONE = new Mode();
        public static final /* enum */ Mode PAN = new Mode();
        public static final /* enum */ Mode ZOOM_X = new Mode();
        public static final /* enum */ Mode ZOOM_Y = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.NONE, Mode.PAN, Mode.ZOOM_X, Mode.ZOOM_Y};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

