/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot.layout;

import com.xorrus.trading.lot.app.plot.ChartTheme;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayout;
import com.xorrus.trading.lot.app.plot.layout.XAxisLayout;
import com.xorrus.trading.lot.app.plot.layout.YAxisLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Paint;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002JD\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\u0012\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J8\u0010\u0015\u001a\u00020\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\fH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/xorrus/trading/lot/app/plot/layout/DiagramLayoutCalculator;", "", "<init>", "()V", "computeXAxisOffsetFromBottom", "", "theme", "Lcom/xorrus/trading/lot/app/plot/ChartTheme;", "computeFullLayout", "Lcom/xorrus/trading/lot/app/plot/layout/DiagramLayout;", "xRange", "Lkotlin/ranges/ClosedRange;", "", "yRange", "currency", "", "height", "width", "computeXAxisLayout", "Lcom/xorrus/trading/lot/app/plot/layout/XAxisLayout;", "plotWidth", "computeYAxisLayout", "Lcom/xorrus/trading/lot/app/plot/layout/YAxisLayout;", "xAxisOffsetFromBottom", "niceTickStep", "range", "targetTicks", "", "decimalPlacesForStep", "step", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nDiagramLayoutCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagramLayoutCalculator.kt\ncom/xorrus/trading/lot/app/plot/layout/DiagramLayoutCalculator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1#2:227\n1563#3:228\n1634#3,3:229\n1563#3:232\n1634#3,3:233\n774#3:236\n865#3,2:237\n*S KotlinDebug\n*F\n+ 1 DiagramLayoutCalculator.kt\ncom/xorrus/trading/lot/app/plot/layout/DiagramLayoutCalculator\n*L\n100#1:228\n100#1:229,3\n156#1:232\n156#1:233,3\n161#1:236\n161#1:237,2\n*E\n"})
public final class DiagramLayoutCalculator {
    @NotNull
    public static final DiagramLayoutCalculator INSTANCE = new DiagramLayoutCalculator();

    private DiagramLayoutCalculator() {
    }

    private final float computeXAxisOffsetFromBottom(ChartTheme theme) {
        FontMetrics metrics = theme.getAxisLabelFont().getMetrics();
        float textHeight = metrics.getDescent() - metrics.getAscent();
        return textHeight + (float)2 * theme.getAxisLabelPadding() + theme.getTickLength();
    }

    @NotNull
    public final DiagramLayout computeFullLayout(@NotNull ClosedRange<Double> xRange, @NotNull ClosedRange<Double> yRange, @Nullable String currency, float height, float width, @NotNull ChartTheme theme) {
        Intrinsics.checkNotNullParameter(xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter(yRange, (String)"yRange");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        float xAxisOffsetFromBottom = this.computeXAxisOffsetFromBottom(theme);
        YAxisLayout yAxisLayout = this.computeYAxisLayout(yRange, height, theme, xAxisOffsetFromBottom, currency);
        float yAxisOffsetFromLeft = yAxisLayout.getOffsetLeft();
        XAxisLayout xAxisLayout = this.computeXAxisLayout(xRange, width - yAxisOffsetFromLeft, theme);
        float originX = yAxisOffsetFromLeft;
        float originY = height - xAxisOffsetFromBottom;
        return new DiagramLayout(xAxisLayout, yAxisLayout, originX, originY);
    }

    /*
     * WARNING - void declaration
     */
    private final XAxisLayout computeXAxisLayout(ClosedRange<Double> xRange, float plotWidth, ChartTheme theme) {
        Font font = theme.getAxisLabelFont();
        Paint paint = theme.getAxisPaint();
        double range = ((Number)((Object)xRange.getEndInclusive())).doubleValue() - ((Number)((Object)xRange.getStart())).doubleValue();
        FontMetrics it = font.getMetrics();
        boolean bl = false;
        float textHeight = it.getDescent() - it.getAscent();
        float offsetBottom = textHeight + (float)2 * theme.getAxisLabelPadding() + theme.getTickLength();
        int iMin = (int)Math.floor(((Number)((Object)xRange.getStart())).doubleValue());
        int iMax = (int)Math.ceil(((Number)((Object)xRange.getEndInclusive())).doubleValue());
        Object[] objectArray = new String[]{String.valueOf(iMin), String.valueOf(iMax), "0"};
        List candidates = CollectionsKt.listOf((Object[])objectArray);
        Iterator iterator = ((Iterable)candidates).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String it232 = (String)iterator.next();
        boolean bl2 = false;
        float it232 = font.measureText(it232, paint).getWidth();
        while (iterator.hasNext()) {
            String it332 = (String)iterator.next();
            boolean $i$a$-maxOf-DiagramLayoutCalculator$computeXAxisLayout$maxLabelW$2 = false;
            float it332 = font.measureText(it332, paint).getWidth();
            it232 = Math.max(it232, it332);
        }
        float maxLabelW = it232;
        float spacing = RangesKt.coerceAtLeast((float)RangesKt.coerceAtLeast((float)maxLabelW, (float)font.measureText("0", paint).getWidth()), (float)(theme.getAxisLabelPadding() * (float)2));
        float available = RangesKt.coerceAtLeast((float)plotWidth, (float)1.0f);
        for (int ticksTarget = RangesKt.coerceAtLeast((int)((int)Math.floor((available + spacing) / (maxLabelW + spacing))), (int)2); ticksTarget >= 2; --ticksTarget) {
            int n;
            float[] $this$mapTo$iv$iv232;
            Collection<String> collection;
            double step = this.niceTickStep(range, ticksTarget - 1);
            double first = Math.ceil(((Number)((Object)xRange.getStart())).doubleValue() / step) * step;
            int tickCount = (int)Math.floor((((Number)((Object)xRange.getEndInclusive())).doubleValue() - first) / step) + 1;
            ArrayList<Double> arrayList = new ArrayList<Double>(tickCount);
            int n2 = 0;
            while (n2 < tickCount) {
                void i;
                int n3;
                int n4 = n3 = n2++;
                collection = arrayList;
                boolean bl3 = false;
                ((ArrayList)collection).add((String)((Object)Double.valueOf(first + (double)i * step)));
            }
            List ticks = arrayList;
            int decimals = this.decimalPlacesForStep(step);
            String fmt = "%." + decimals + "f";
            Iterable $this$map$iv = ticks;
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv232) {
                void it3;
                double d = ((Number)t).doubleValue();
                collection = destination$iv$iv22;
                boolean bl4 = false;
                Object[] objectArray2 = new Object[]{(double)it3};
                String string = String.format(fmt, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                collection.add(string);
            }
            List labels = (List)destination$iv$iv22;
            $i$f$map = 0;
            $this$mapTo$iv$iv232 = new float[tickCount];
            while ($i$f$map < tickCount) {
                int destination$iv$iv22 = $i$f$map++;
                $this$mapTo$iv$iv232[destination$iv$iv22] = DiagramLayoutCalculator.computeXAxisLayout$mapValueToX(xRange, range, plotWidth, ((Number)ticks.get(destination$iv$iv22)).doubleValue());
            }
            float[] centers = $this$mapTo$iv$iv232;
            int $this$mapTo$iv$iv232 = 0;
            destination$iv$iv22 = new float[tickCount];
            while ($this$mapTo$iv$iv232 < tickCount) {
                n = $this$mapTo$iv$iv232++;
                destination$iv$iv22[n] = font.measureText((String)labels.get(n), paint).getWidth();
            }
            Object widths = destination$iv$iv22;
            boolean fits = true;
            n = tickCount - 1;
            for (int i = 0; i < n; ++i) {
                reference var31_50 = widths[i] / 2.0f + widths[i + 1] / 2.0f + spacing;
                if (!(centers[i + 1] - centers[i] < var31_50)) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            return new XAxisLayout(ticks, labels, offsetBottom);
        }
        Object[] $i$a$-maxOf-DiagramLayoutCalculator$computeXAxisLayout$maxLabelW$2 = new Double[]{xRange.getStart(), xRange.getEndInclusive()};
        List ticks = CollectionsKt.listOf((Object[])$i$a$-maxOf-DiagramLayoutCalculator$computeXAxisLayout$maxLabelW$2);
        Object[] objectArray3 = new String[2];
        String string = "%.0f";
        Object[] objectArray4 = new Object[]{ticks.get(0)};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray4, objectArray4.length)), (String)"format(...)");
        string = "%.0f";
        objectArray4 = new Object[]{ticks.get(1)};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray4, objectArray4.length)), (String)"format(...)");
        List labels = CollectionsKt.listOf((Object[])objectArray3);
        return new XAxisLayout(ticks, labels, offsetBottom);
    }

    /*
     * WARNING - void declaration
     */
    private final YAxisLayout computeYAxisLayout(ClosedRange<Double> yRange, float height, ChartTheme theme, float xAxisOffsetFromBottom, String currency) {
        Float f;
        Iterator iterator;
        void $this$mapTo$iv$iv;
        Collection<String> collection;
        Font it = theme.getAxisLabelFont();
        boolean bl = false;
        float textHeight = it.getMetrics().getDescent() - it.getMetrics().getAscent();
        float availableHeight = RangesKt.coerceAtLeast((float)(height - xAxisOffsetFromBottom), (float)0.0f);
        int maxTicks = RangesKt.coerceAtLeast((int)((int)Math.floor(availableHeight / (textHeight * theme.getMinLabelSpacingFactor()))), (int)2);
        double step = this.niceTickStep(((Number)((Object)yRange.getEndInclusive())).doubleValue() - ((Number)((Object)yRange.getStart())).doubleValue(), maxTicks);
        double first = Math.ceil(((Number)((Object)yRange.getStart())).doubleValue() / step) * step;
        int tickCount = (int)Math.floor((((Number)((Object)yRange.getEndInclusive())).doubleValue() - first) / step) + 1;
        ArrayList<Double> arrayList = new ArrayList<Double>(tickCount);
        int n = 0;
        while (n < tickCount) {
            void i;
            int n2;
            int n3 = n2 = n++;
            collection = arrayList;
            boolean bl2 = false;
            ((ArrayList)collection).add((String)((Object)Double.valueOf(first + (double)i * step)));
        }
        List ticks = arrayList;
        int decimals = this.decimalPlacesForStep(step);
        String formatString = "%." + decimals + "f";
        Iterable $this$map$iv = ticks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl3 = false;
            Object[] objectArray = new Object[]{(double)it2};
            String string = String.format(formatString, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            collection.add(string);
        }
        List labels = (List)destination$iv$iv;
        if (currency != null && labels.size() >= 2) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)CollectionsKt.getIndices((Collection)ticks);
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it3 = ((Number)element$iv$iv).intValue();
                boolean bl4 = false;
                if (!(((Number)ticks.get(it3)).doubleValue() > 0.0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List positiveIndices = (List)destination$iv$iv2;
            if (positiveIndices.size() >= 2) {
                List list;
                int secondLastPositiveIndex = ((Number)positiveIndices.get(positiveIndices.size() - 2)).intValue();
                List $this$computeYAxisLayout_u24lambda_u244 = list = CollectionsKt.toMutableList((Collection)labels);
                boolean bl5 = false;
                $this$computeYAxisLayout_u24lambda_u244.set(secondLastPositiveIndex, currency);
                labels = list;
            }
        }
        if (!(iterator = ((Iterable)labels).iterator()).hasNext()) {
            f = null;
        } else {
            String it4 = (String)iterator.next();
            boolean bl6 = false;
            float f2 = theme.getAxisLabelFont().measureText(it4, theme.getAxisPaint()).getWidth();
            while (iterator.hasNext()) {
                String it5 = (String)iterator.next();
                $i$a$-maxOfOrNull-DiagramLayoutCalculator$computeYAxisLayout$maxWidth$1 = false;
                float f3 = theme.getAxisLabelFont().measureText(it5, theme.getAxisPaint()).getWidth();
                f2 = Math.max(f2, f3);
            }
            f = Float.valueOf(f2);
        }
        float maxWidth = f != null ? f.floatValue() : 0.0f;
        float offsetLeft = (float)2 * theme.getAxisLabelPadding() + maxWidth + theme.getTickLength();
        return new YAxisLayout(ticks, labels, offsetLeft);
    }

    private final double niceTickStep(double range, int targetTicks) {
        double rawStep = range / (double)targetTicks;
        double magnitude = Math.pow(10.0, Math.floor(Math.log10(rawStep)));
        double residual = rawStep / magnitude;
        double niceResidual = residual < 1.5 ? 1.0 : (residual < 3.0 ? 2.0 : (residual < 7.0 ? 5.0 : 10.0));
        return niceResidual * magnitude;
    }

    private final int decimalPlacesForStep(double step) {
        if (step <= 0.0 || Double.isNaN(step) || Double.isInfinite(step)) {
            return 0;
        }
        int log = -((int)Math.floor(Math.log10(step)));
        return RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)log, (int)0), (int)6);
    }

    private static final float computeXAxisLayout$mapValueToX(ClosedRange<Double> $xRange, double range, float $plotWidth, double value) {
        float ratio = (float)((value - ((Number)((Object)$xRange.getStart())).doubleValue()) / range);
        return ratio * $plotWidth;
    }
}

