/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app;

import com.xorrus.trading.common.LoggingKt;
import com.xorrus.trading.lot.app.config.DefaultConfiguration;
import com.xorrus.trading.lot.app.config.GlobalSettings;
import com.xorrus.trading.lot.app.connection.ConnectionManager;
import com.xorrus.trading.lot.app.license.LicenseManager;
import com.xorrus.trading.lot.app.utils.RunAtLeastKt;
import com.xorrus.trading.lot.app.utils.SentryKt;
import com.xorrus.trading.lot.app.utils.SystemKt;
import com.xorrus.trading.lot.app.view.MainPaneKt;
import com.xorrus.trading.lot.app.view.common.LicenseDialogKt;
import javafx.application.Application;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/xorrus/trading/lot/app/App;", "Ljavafx/application/Application;", "<init>", "()V", "init", "", "start", "primaryStage", "Ljavafx/stage/Stage;", "stop", "Companion", "laboftrades-app"})
public final class App
extends Application {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public void init() {
        super.init();
        logger.info("Lab of Trades " + DefaultConfiguration.INSTANCE.getVersion() + " wird gestartet.");
        LoggingKt.configureLogging((String)"debug");
        SentryKt.sentryInit();
        RunAtLeastKt.runAtLeast-VtjQ1oo(DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), App::init$lambda$0);
    }

    public void start(@NotNull Stage primaryStage) {
        Intrinsics.checkNotNullParameter((Object)primaryStage, (String)"primaryStage");
        if (GlobalSettings.INSTANCE.getLicenseAcceptedProperty().getValue() == null) {
            LicenseDialogKt.showLicenseDialog(primaryStage);
            return;
        }
        MainPaneKt.showMainPane(primaryStage);
        logger.info("Lab of Trades erfolgreich started.");
    }

    public void stop() {
        SentryKt.sentryDispose();
        ConnectionManager.INSTANCE.disconnect();
    }

    private static final ConnectionManager init$lambda$0() {
        SystemKt.configureSystemSpecific();
        LicenseManager.INSTANCE.getLicenseKeyProperty().setValue((Object)GlobalSettings.INSTANCE.getLicenseKeyProperty().getValue());
        return ConnectionManager.INSTANCE;
    }

    static {
        Logger logger = LoggerFactory.getLogger(App.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        App.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/xorrus/trading/lot/app/App$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "laboftrades-app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

