/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared;

import java.util.HashMap;
import java.util.Map;
import org.ehcache.CachePersistenceException;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.shared.AbstractPartition;
import org.ehcache.impl.internal.store.shared.SharedStorage;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.OptionalServiceDependencies;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;

@ServiceDependencies(value={Store.ElementalProvider.class})
@OptionalServiceDependencies(value={"org.ehcache.core.spi.service.StatisticsService"})
public class SharedStorageProvider
implements MaintainableService {
    private final ResourcePools resourcePools;
    private final Map<ResourceType<?>, SharedStorage> storage = new HashMap();

    public SharedStorageProvider(ResourcePools resourcePools) {
        this.resourcePools = resourcePools;
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        for (ResourceType<?> resourceType : this.resourcePools.getResourceTypeSet()) {
            Object pool = this.resourcePools.getPoolForResource(resourceType);
            SharedStorage sharedStorage = new SharedStorage((ResourcePool)pool);
            sharedStorage.start(serviceProvider);
            this.storage.put(resourceType, sharedStorage);
        }
    }

    @Override
    public void startForMaintenance(ServiceProvider<? super MaintainableService> serviceProvider, MaintainableService.MaintenanceScope maintenanceScope) {
        for (ResourceType<?> resourceType : this.resourcePools.getResourceTypeSet()) {
            Object pool = this.resourcePools.getPoolForResource(resourceType);
            if (!pool.isPersistent()) continue;
            SharedStorage sharedStorage = new SharedStorage((ResourcePool)pool);
            sharedStorage.start(serviceProvider);
            this.storage.put(resourceType, sharedStorage);
        }
    }

    @Override
    public void stop() {
        this.storage.values().forEach(SharedStorage::stop);
        this.storage.clear();
    }

    public <T, U, K, V> U partition(String alias, ResourceType<?> resourceType, Store.Configuration<K, V> storeConfig, SharedStorage.PartitionFactory<T, U> partitionFactory) {
        return this.storage.get(resourceType).createPartition(alias, storeConfig, partitionFactory);
    }

    public boolean supports(Class<?> storageType, ResourceType<?> resourceType) {
        SharedStorage sharedStorage = this.storage.get(resourceType);
        return sharedStorage != null && sharedStorage.supports(storageType);
    }

    public void destroyPartition(ResourceType<?> resourceType, String alias) {
        this.storage.get(resourceType).destroyPartition(alias);
    }

    public void destroyPartition(String name) {
        this.storage.values().forEach(type -> type.destroyPartition(name));
    }

    public void releasePartition(AbstractPartition<?> partition) {
        this.storage.get(partition.type()).releasePartition(partition);
    }

    public StateRepository stateRepository(ResourceType<?> resourceType, String name) throws CachePersistenceException {
        return this.storage.get(resourceType).stateRepository(name);
    }
}

