/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.Chunk;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class AbstractChunk
implements Chunk {
    @Override
    public ByteBuffer[] getBuffers(long length) {
        ByteBuffer[] list = this.getBuffers();
        ArrayList<ByteBuffer> copy = new ArrayList<ByteBuffer>();
        long count = 0L;
        if (length == 0L) {
            return new ByteBuffer[0];
        }
        for (ByteBuffer buffer : list) {
            if (!buffer.hasRemaining()) continue;
            if ((long)buffer.remaining() >= length - count) {
                int restore = buffer.limit();
                buffer.limit(buffer.position() + (int)(length - count));
                copy.add(buffer.slice());
                buffer.position(buffer.limit()).limit(restore);
                count = length;
            } else {
                copy.add(buffer.duplicate());
                count += (long)buffer.remaining();
                buffer.position(buffer.limit());
            }
            if (count == length) break;
        }
        return copy.toArray(new ByteBuffer[copy.size()]);
    }

    @Override
    public Chunk getChunk(long length) {
        final ByteBuffer[] list = this.getBuffers(length);
        return new AbstractChunk(){

            @Override
            public ByteBuffer[] getBuffers() {
                return list;
            }
        };
    }

    private BufferReference scanTo(long position) {
        ByteBuffer[] list = this.getBuffers();
        long seek = 0L;
        for (ByteBuffer buffer : list) {
            if (seek + (long)buffer.limit() > position) {
                return new BufferReference(buffer, (int)(position - seek));
            }
            seek += (long)buffer.limit();
        }
        throw new IndexOutOfBoundsException("scanTo: position=" + position + " buffers.length=" + list.length);
    }

    private ByteBuffer findEndForPut(int size) {
        return this.getBuffers()[this.findEndForPut(size, 0)];
    }

    private int findEndForPut(int size, int from) {
        ByteBuffer[] list = this.getBuffers();
        while (from < list.length) {
            if (!list[from].isReadOnly() && list[from].hasRemaining()) {
                if (list[from].remaining() < size) {
                    list[from].limit(list[from].position());
                } else {
                    return from;
                }
            }
            ++from;
        }
        throw new IndexOutOfBoundsException("findEndForPut: size=" + size + " from=" + from + " buffers.length=" + list.length);
    }

    private ByteBuffer findEndForGet(int size) {
        return this.getBuffers()[this.findEndForGet(size, 0)];
    }

    private int findEndForGet(int size, int from) {
        ByteBuffer[] list = this.getBuffers();
        while (from < list.length) {
            if (list[from].hasRemaining()) {
                if (list[from].remaining() < size) {
                    throw new BufferUnderflowException();
                }
                return from;
            }
            ++from;
        }
        throw new IndexOutOfBoundsException("findEndForGet: size=" + size + " from=" + from + " buffers.length=" + list.length);
    }

    @Override
    public byte get(long pos) {
        return this.scanTo(pos).get();
    }

    @Override
    public short getShort(long pos) {
        return this.scanTo(pos).getShort();
    }

    @Override
    public int getInt(long pos) {
        return this.scanTo(pos).getInt();
    }

    @Override
    public long getLong(long pos) {
        return this.scanTo(pos).getLong();
    }

    @Override
    public byte get() {
        return this.findEndForGet(1).get();
    }

    @Override
    public short getShort() {
        return this.findEndForGet(2).getShort();
    }

    @Override
    public int getInt() {
        return this.findEndForGet(4).getInt();
    }

    @Override
    public long getLong() {
        return this.findEndForGet(8).getLong();
    }

    @Override
    public byte peek() {
        ByteBuffer target = this.findEndForGet(1);
        return target.get(target.position());
    }

    @Override
    public short peekShort() {
        ByteBuffer target = this.findEndForGet(2);
        return target.getShort(target.position());
    }

    @Override
    public int peekInt() {
        ByteBuffer target = this.findEndForGet(4);
        return target.getInt(target.position());
    }

    @Override
    public long peekLong() {
        ByteBuffer target = this.findEndForGet(8);
        return target.getLong(target.position());
    }

    @Override
    public void put(byte v) {
        this.findEndForPut(1).put(v);
    }

    @Override
    public void putShort(short v) {
        this.findEndForPut(2).putShort(v);
    }

    @Override
    public void putInt(int v) {
        this.findEndForPut(4).putInt(v);
    }

    @Override
    public void putLong(long v) {
        this.findEndForPut(8).putLong(v);
    }

    @Override
    public int get(byte[] buf) {
        int pos;
        int sw;
        int count;
        ByteBuffer target;
        int from = 0;
        for (count = 0; count < buf.length && this.hasRemaining(); count += target.get(buf, count, (sw = buf.length - count) > target.remaining() ? target.remaining() : sw).position() - pos) {
            from = this.findEndForGet(1, from);
            target = this.getBuffers()[from];
            pos = target.position();
        }
        return count;
    }

    @Override
    public int put(byte[] buf) {
        int pos;
        int sw;
        int count;
        ByteBuffer target;
        int from = 0;
        for (count = 0; count < buf.length; count += target.put(buf, count, (sw = buf.length - count) > target.remaining() ? target.remaining() : sw).position() - pos) {
            from = this.findEndForPut(1, from);
            target = this.getBuffers()[from];
            pos = target.position();
        }
        return count;
    }

    @Override
    public void skip(long jump) {
        ByteBuffer target;
        if (jump == 0L) {
            return;
        }
        int from = 0;
        for (long count = 0L; count < jump; count += (long)target.remaining()) {
            from = this.findEndForGet(2, from);
            target = this.getBuffers()[from];
            if (jump - count > (long)target.remaining()) {
                target.position(target.limit());
                continue;
            }
            target.position(target.position() + (int)(jump - count));
            return;
        }
        throw new IndexOutOfBoundsException("skip: jump=" + jump + " buffers.length=" + this.getBuffers().length);
    }

    @Override
    public void flip() {
        ByteBuffer[] list;
        for (ByteBuffer buf : list = this.getBuffers()) {
            buf.flip();
        }
    }

    @Override
    public void clear() {
        ByteBuffer[] list;
        for (ByteBuffer buf : list = this.getBuffers()) {
            buf.clear();
        }
    }

    @Override
    public long length() {
        long len = 0L;
        for (ByteBuffer buf : this.getBuffers()) {
            len += (long)buf.limit();
        }
        return len;
    }

    @Override
    public void limit(long v) {
        long len = 0L;
        for (ByteBuffer buf : this.getBuffers()) {
            if ((len += (long)buf.limit()) <= v) continue;
            buf.limit(buf.limit() - (int)(len - v));
            return;
        }
    }

    @Override
    public long remaining() {
        long len = 0L;
        for (ByteBuffer buf : this.getBuffers()) {
            len += (long)buf.remaining();
        }
        return len;
    }

    @Override
    public long position() {
        long position = 0L;
        for (ByteBuffer buf : this.getBuffers()) {
            position += (long)buf.position();
            if (buf.hasRemaining()) break;
        }
        return position;
    }

    @Override
    public boolean hasRemaining() {
        for (ByteBuffer buf : this.getBuffers()) {
            if (!buf.hasRemaining()) continue;
            return true;
        }
        return false;
    }

    private static class BufferReference {
        private final ByteBuffer current;
        private final int position;

        BufferReference(ByteBuffer buf, int pos) {
            this.current = buf;
            this.position = pos;
        }

        public byte get() {
            return this.current.get(this.position);
        }

        public short getShort() {
            return this.current.getShort(this.position);
        }

        public int getInt() {
            return this.current.getInt(this.position);
        }

        public long getLong() {
            return this.current.getLong(this.position);
        }
    }
}

