/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract.indicator;

import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.indicator.ExtremaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/xorrus/trading/common/contract/indicator/Extrema;", "", "contract", "Lcom/xorrus/trading/common/contract/Contract;", "extremaTimestamp", "Lkotlin/time/Instant;", "extremaPrice", "Lcom/xorrus/trading/common/bignum/XBigNum;", "type", "Lcom/xorrus/trading/common/contract/indicator/ExtremaType;", "<init>", "(Lcom/xorrus/trading/common/contract/Contract;Lkotlin/time/Instant;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/contract/indicator/ExtremaType;)V", "getContract", "()Lcom/xorrus/trading/common/contract/Contract;", "getExtremaTimestamp", "()Lkotlin/time/Instant;", "getExtremaPrice", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getType", "()Lcom/xorrus/trading/common/contract/indicator/ExtremaType;", "toCsv", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "common-trading-common"})
public final class Extrema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Contract contract;
    @NotNull
    private final Instant extremaTimestamp;
    @NotNull
    private final XBigNum extremaPrice;
    @NotNull
    private final ExtremaType type;
    @NotNull
    public static final String VERSION = "1";

    public Extrema(@NotNull Contract contract, @NotNull Instant extremaTimestamp, @NotNull XBigNum extremaPrice, @NotNull ExtremaType type) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)extremaTimestamp, (String)"extremaTimestamp");
        Intrinsics.checkNotNullParameter((Object)extremaPrice, (String)"extremaPrice");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.contract = contract;
        this.extremaTimestamp = extremaTimestamp;
        this.extremaPrice = extremaPrice;
        this.type = type;
    }

    @NotNull
    public final Contract getContract() {
        return this.contract;
    }

    @NotNull
    public final Instant getExtremaTimestamp() {
        return this.extremaTimestamp;
    }

    @NotNull
    public final XBigNum getExtremaPrice() {
        return this.extremaPrice;
    }

    @NotNull
    public final ExtremaType getType() {
        return this.type;
    }

    @NotNull
    public final String toCsv() {
        StringBuilder stringBuilder;
        StringBuilder $this$toCsv_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toCsv_u24lambda_u240.append(VERSION);
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.contract.getSymbol());
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.extremaTimestamp);
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append(this.extremaPrice);
        $this$toCsv_u24lambda_u240.append(";");
        $this$toCsv_u24lambda_u240.append((Object)this.type);
        return stringBuilder.toString();
    }

    @NotNull
    public final Contract component1() {
        return this.contract;
    }

    @NotNull
    public final Instant component2() {
        return this.extremaTimestamp;
    }

    @NotNull
    public final XBigNum component3() {
        return this.extremaPrice;
    }

    @NotNull
    public final ExtremaType component4() {
        return this.type;
    }

    @NotNull
    public final Extrema copy(@NotNull Contract contract, @NotNull Instant extremaTimestamp, @NotNull XBigNum extremaPrice, @NotNull ExtremaType type) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)extremaTimestamp, (String)"extremaTimestamp");
        Intrinsics.checkNotNullParameter((Object)extremaPrice, (String)"extremaPrice");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new Extrema(contract, extremaTimestamp, extremaPrice, type);
    }

    public static /* synthetic */ Extrema copy$default(Extrema extrema, Contract contract, Instant instant, XBigNum xBigNum, ExtremaType extremaType, int n, Object object) {
        if ((n & 1) != 0) {
            contract = extrema.contract;
        }
        if ((n & 2) != 0) {
            instant = extrema.extremaTimestamp;
        }
        if ((n & 4) != 0) {
            xBigNum = extrema.extremaPrice;
        }
        if ((n & 8) != 0) {
            extremaType = extrema.type;
        }
        return extrema.copy(contract, instant, xBigNum, extremaType);
    }

    @NotNull
    public String toString() {
        return "Extrema(contract=" + this.contract + ", extremaTimestamp=" + this.extremaTimestamp + ", extremaPrice=" + this.extremaPrice + ", type=" + this.type + ")";
    }

    public int hashCode() {
        int result = this.contract.hashCode();
        result = result * 31 + this.extremaTimestamp.hashCode();
        result = result * 31 + this.extremaPrice.hashCode();
        result = result * 31 + this.type.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Extrema)) {
            return false;
        }
        Extrema extrema = (Extrema)other;
        if (!Intrinsics.areEqual((Object)this.contract, (Object)extrema.contract)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extremaTimestamp, (Object)extrema.extremaTimestamp)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extremaPrice, (Object)extrema.extremaPrice)) {
            return false;
        }
        return this.type == extrema.type;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/xorrus/trading/common/contract/indicator/Extrema$Companion;", "", "<init>", "()V", "VERSION", "", "fromCsv", "Lcom/xorrus/trading/common/contract/indicator/Extrema;", "cells", "", "idx", "", "setIdx", "Lkotlin/Function1;", "", "csv", "common-trading-common"})
    @SourceDebugExtension(value={"SMAP\nExtrema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extrema.kt\ncom/xorrus/trading/common/contract/indicator/Extrema$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1#2:50\n774#3:51\n865#3,2:52\n1563#3:54\n1634#3,3:55\n*S KotlinDebug\n*F\n+ 1 Extrema.kt\ncom/xorrus/trading/common/contract/indicator/Extrema$Companion\n*L\n44#1:51\n44#1:52,2\n45#1:54\n45#1:55,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Extrema fromCsv(@NotNull List<String> cells, int idx, @NotNull Function1<? super Integer, Unit> setIdx) {
            void it;
            Intrinsics.checkNotNullParameter(cells, (String)"cells");
            Intrinsics.checkNotNullParameter(setIdx, (String)"setIdx");
            int i = idx;
            boolean bl = Intrinsics.areEqual((Object)cells.get(i++), (Object)Extrema.VERSION);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int n = i++;
            int n2 = i++;
            int n3 = i++;
            String string = cells.get(i++);
            XBigNum xBigNum = XbignumKt.toXBigNum(cells.get(n3));
            Instant instant = Instant.Companion.parse((CharSequence)cells.get(n2));
            Contract contract = Contract.Companion.fromSymbol(cells.get(n));
            boolean bl2 = false;
            ExtremaType extremaType = ExtremaType.valueOf((String)it);
            ExtremaType extremaType2 = extremaType;
            XBigNum xBigNum2 = xBigNum;
            Instant instant2 = instant;
            Contract contract2 = contract;
            Extrema result = new Extrema(contract2, instant2, xBigNum2, extremaType2);
            setIdx.invoke((Object)i);
            return result;
        }

        public static /* synthetic */ Extrema fromCsv$default(Companion companion, List list, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                function1 = Companion::fromCsv$lambda$0;
            }
            return companion.fromCsv(list, n, (Function1<? super Integer, Unit>)function1);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Extrema> fromCsv(@NotNull String csv) {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)csv, (String)"csv");
            String[] stringArray = new String[]{"\n"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)csv, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{";"};
                collection.add(com.xorrus.trading.common.contract.indicator.Extrema$Companion.fromCsv$default(Companion, StringsKt.split$default((CharSequence)((CharSequence)line), (String[])stringArray2, (boolean)false, (int)0, (int)6, null), 0, null, 6, null));
            }
            return (List)destination$iv$iv;
        }

        private static final Unit fromCsv$lambda$0(int it) {
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

