/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract.chain;

import com.xorrus.trading.common.BlackscholeKt;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Right;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b,\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001e\u001a\u0004\b \u0010!R\u001d\u0010#\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001e\u001a\u0004\b$\u0010\u001cR\u001d\u0010&\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u001e\u001a\u0004\b'\u0010\u001cR\u001b\u0010)\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001e\u001a\u0004\b*\u0010+R\u001b\u0010-\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u001e\u001a\u0004\b.\u0010!R\u001d\u00100\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u001e\u001a\u0004\b1\u0010\u001cR\u001d\u00103\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u001e\u001a\u0004\b4\u0010\u001cR\u001d\u00106\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u001e\u001a\u0004\b7\u0010\u001c\u00a8\u00069"}, d2={"Lcom/xorrus/trading/common/contract/chain/OptionPriceWithGreeks;", "", "timestamp", "Lkotlin/time/Instant;", "price", "Lcom/xorrus/trading/common/bignum/XBigNum;", "underlyingPrice", "Lkotlin/Function0;", "strike", "right", "Lcom/xorrus/trading/common/contract/Right;", "zins", "Trest", "", "<init>", "(Lkotlin/time/Instant;Lcom/xorrus/trading/common/bignum/XBigNum;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getTimestamp", "()Lkotlin/time/Instant;", "getPrice", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getUnderlyingPrice", "()Lkotlin/jvm/functions/Function0;", "getStrike", "getRight", "getZins", "getTrest", "_underlyingPrice", "get_underlyingPrice", "()Ljava/lang/Double;", "_underlyingPrice$delegate", "Lkotlin/Lazy;", "_strike", "get_strike", "()D", "_strike$delegate", "_zins", "get_zins", "_zins$delegate", "_price", "get_price", "_price$delegate", "_right", "get_right", "()Lcom/xorrus/trading/common/contract/Right;", "_right$delegate", "_Trest", "get_Trest", "_Trest$delegate", "vola", "getVola", "vola$delegate", "delta", "getDelta", "delta$delegate", "theta", "getTheta", "theta$delegate", "common-trading-common"})
public final class OptionPriceWithGreeks {
    @NotNull
    private final Instant timestamp;
    @Nullable
    private final XBigNum price;
    @NotNull
    private final Function0<XBigNum> underlyingPrice;
    @NotNull
    private final Function0<XBigNum> strike;
    @NotNull
    private final Function0<Right> right;
    @NotNull
    private final Function0<XBigNum> zins;
    @NotNull
    private final Function0<Double> Trest;
    @NotNull
    private final Lazy _underlyingPrice$delegate;
    @NotNull
    private final Lazy _strike$delegate;
    @NotNull
    private final Lazy _zins$delegate;
    @NotNull
    private final Lazy _price$delegate;
    @NotNull
    private final Lazy _right$delegate;
    @NotNull
    private final Lazy _Trest$delegate;
    @NotNull
    private final Lazy vola$delegate;
    @NotNull
    private final Lazy delta$delegate;
    @NotNull
    private final Lazy theta$delegate;

    public OptionPriceWithGreeks(@NotNull Instant timestamp, @Nullable XBigNum price, @NotNull Function0<XBigNum> underlyingPrice, @NotNull Function0<XBigNum> strike, @NotNull Function0<? extends Right> right, @NotNull Function0<XBigNum> zins, @NotNull Function0<Double> Trest) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter(underlyingPrice, (String)"underlyingPrice");
        Intrinsics.checkNotNullParameter(strike, (String)"strike");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        Intrinsics.checkNotNullParameter(zins, (String)"zins");
        Intrinsics.checkNotNullParameter(Trest, (String)"Trest");
        this.timestamp = timestamp;
        this.price = price;
        this.underlyingPrice = underlyingPrice;
        this.strike = strike;
        this.right = right;
        this.zins = zins;
        this.Trest = Trest;
        this._underlyingPrice$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks._underlyingPrice_delegate$lambda$0(this));
        this._strike$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks._strike_delegate$lambda$0(this));
        this._zins$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks._zins_delegate$lambda$0(this));
        this._price$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks._price_delegate$lambda$0(this));
        this._right$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks._right_delegate$lambda$0(this));
        this._Trest$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks._Trest_delegate$lambda$0(this));
        this.vola$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks.vola_delegate$lambda$0(this));
        this.delta$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks.delta_delegate$lambda$0(this));
        this.theta$delegate = LazyKt.lazy(() -> OptionPriceWithGreeks.theta_delegate$lambda$0(this));
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final XBigNum getPrice() {
        return this.price;
    }

    @NotNull
    public final Function0<XBigNum> getUnderlyingPrice() {
        return this.underlyingPrice;
    }

    @NotNull
    public final Function0<XBigNum> getStrike() {
        return this.strike;
    }

    @NotNull
    public final Function0<Right> getRight() {
        return this.right;
    }

    @NotNull
    public final Function0<XBigNum> getZins() {
        return this.zins;
    }

    @NotNull
    public final Function0<Double> getTrest() {
        return this.Trest;
    }

    @Nullable
    public final Double get_underlyingPrice() {
        Lazy lazy = this._underlyingPrice$delegate;
        return (Double)lazy.getValue();
    }

    public final double get_strike() {
        Lazy lazy = this._strike$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @Nullable
    public final Double get_zins() {
        Lazy lazy = this._zins$delegate;
        return (Double)lazy.getValue();
    }

    @Nullable
    public final Double get_price() {
        Lazy lazy = this._price$delegate;
        return (Double)lazy.getValue();
    }

    @NotNull
    public final Right get_right() {
        Lazy lazy = this._right$delegate;
        return (Right)((Object)lazy.getValue());
    }

    public final double get_Trest() {
        Lazy lazy = this._Trest$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @Nullable
    public final Double getVola() {
        Lazy lazy = this.vola$delegate;
        return (Double)lazy.getValue();
    }

    @Nullable
    public final Double getDelta() {
        Lazy lazy = this.delta$delegate;
        return (Double)lazy.getValue();
    }

    @Nullable
    public final Double getTheta() {
        Lazy lazy = this.theta$delegate;
        return (Double)lazy.getValue();
    }

    private static final Double _underlyingPrice_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        XBigNum xBigNum = (XBigNum)this$0.underlyingPrice.invoke();
        return xBigNum != null ? Double.valueOf(XbignumKt.toDouble(xBigNum)) : null;
    }

    private static final double _strike_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        return XbignumKt.toDouble((XBigNum)this$0.strike.invoke());
    }

    private static final Double _zins_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        XBigNum xBigNum = (XBigNum)this$0.zins.invoke();
        return xBigNum != null ? Double.valueOf(XbignumKt.toDouble(xBigNum)) : null;
    }

    private static final Double _price_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        XBigNum xBigNum = this$0.price;
        return xBigNum != null ? Double.valueOf(XbignumKt.toDouble(xBigNum)) : null;
    }

    private static final Right _right_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        return (Right)((Object)this$0.right.invoke());
    }

    private static final double _Trest_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        return ((Number)this$0.Trest.invoke()).doubleValue();
    }

    private static final Double vola_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        if (this$0.get_underlyingPrice() == null || this$0.get_zins() == null || this$0.get_price() == null) {
            return null;
        }
        Double d = this$0.get_underlyingPrice();
        Intrinsics.checkNotNull((Object)d);
        double d2 = d;
        double d3 = this$0.get_strike();
        Double d4 = this$0.get_zins();
        Intrinsics.checkNotNull((Object)d4);
        double d5 = d4;
        Double d6 = this$0.get_price();
        Intrinsics.checkNotNull((Object)d6);
        return BlackscholeKt.vola(d2, d3, d5, d6, this$0.get_Trest(), this$0.get_right());
    }

    private static final Double delta_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        if (this$0.get_underlyingPrice() == null || this$0.get_zins() == null || this$0.get_price() == null || this$0.getVola() == null) {
            return null;
        }
        Double d = this$0.get_underlyingPrice();
        Intrinsics.checkNotNull((Object)d);
        double d2 = d;
        double d3 = this$0.get_strike();
        Double d4 = this$0.get_zins();
        Intrinsics.checkNotNull((Object)d4);
        double d5 = d4;
        Double d6 = this$0.getVola();
        Intrinsics.checkNotNull((Object)d6);
        return BlackscholeKt.delta(d2, d3, d5, d6, this$0.get_Trest(), this$0.get_right());
    }

    private static final Double theta_delegate$lambda$0(OptionPriceWithGreeks this$0) {
        if (this$0.get_underlyingPrice() == null || this$0.get_zins() == null || this$0.get_price() == null || this$0.getVola() == null) {
            return null;
        }
        Double d = this$0.get_underlyingPrice();
        Intrinsics.checkNotNull((Object)d);
        double d2 = d;
        double d3 = this$0.get_strike();
        Double d4 = this$0.get_zins();
        Intrinsics.checkNotNull((Object)d4);
        double d5 = d4;
        Double d6 = this$0.getVola();
        Intrinsics.checkNotNull((Object)d6);
        return BlackscholeKt.theta(d2, d3, d5, d6, this$0.get_Trest(), this$0.get_right());
    }
}

