/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract.chain;

import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.common.contract.OptionChainDef;
import com.xorrus.trading.common.contract.Right;
import com.xorrus.trading.common.contract.Underlying;
import com.xorrus.trading.common.contract.chain.Strike;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J#\u0010\u001c\u001a\u0002H\u001d\"\f\b\u0001\u0010\u001d*\u0006\u0012\u0002\b\u00030\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00150\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#\u00c0\u0006\u0003"}, d2={"Lcom/xorrus/trading/common/contract/chain/OptionChain;", "T", "", "underlying", "Lcom/xorrus/trading/common/contract/Underlying;", "getUnderlying", "()Lcom/xorrus/trading/common/contract/Underlying;", "tradingClass", "", "getTradingClass", "()Ljava/lang/String;", "expiration", "Lkotlinx/datetime/LocalDate;", "getExpiration", "()Lkotlinx/datetime/LocalDate;", "timestamp", "Lkotlin/time/Instant;", "getTimestamp", "()Lkotlin/time/Instant;", "strikes", "", "Lcom/xorrus/trading/common/contract/chain/Strike;", "getStrikes", "()Ljava/util/List;", "def", "Lcom/xorrus/trading/common/contract/OptionChainDef;", "getDef", "()Lcom/xorrus/trading/common/contract/OptionChainDef;", "copy", "S", "(Lkotlin/time/Instant;)Lcom/xorrus/trading/common/contract/chain/OptionChain;", "getStrikeValue", "option", "Lcom/xorrus/trading/common/contract/Option;", "(Lcom/xorrus/trading/common/contract/Option;)Ljava/lang/Object;", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nOptionChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionChain.kt\ncom/xorrus/trading/common/contract/chain/OptionChain\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public interface OptionChain<T> {
    @NotNull
    public Underlying getUnderlying();

    @NotNull
    public String getTradingClass();

    @NotNull
    public LocalDate getExpiration();

    @NotNull
    public Instant getTimestamp();

    @NotNull
    public List<Strike<T>> getStrikes();

    @NotNull
    default public OptionChainDef getDef() {
        return new OptionChainDef(this.getUnderlying(), this.getTradingClass(), this.getExpiration());
    }

    @NotNull
    public <S extends OptionChain<?>> S copy(@NotNull Instant var1);

    @Nullable
    default public T getStrikeValue(@NotNull Option option) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            if (!Intrinsics.areEqual((Object)option.toOptionChainDef(), (Object)this.getDef())) {
                return null;
            }
            Iterable iterable = this.getStrikes();
            for (Object t : iterable) {
                Strike it = (Strike)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getStrike(), (Object)option.getStrike())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Strike strike = v0;
        if (strike == null) {
            return null;
        }
        Strike strike2 = strike;
        return option.getRight() == Right.CALL ? strike2.getCallValue() : strike2.getPutValue();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static <T> OptionChainDef getDef(@NotNull OptionChain<T> $this) {
            return ((OptionChain)$this).getDef();
        }

        @Deprecated
        @Nullable
        public static <T> T getStrikeValue(@NotNull OptionChain<T> $this, @NotNull Option option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            return (T)((OptionChain)$this).getStrikeValue(option);
        }
    }
}

